/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.ContractCommentPatternEvent;
import ru.bitel.common.Utils;

public class CommentPatternManager {
    private final Logger logger = Logger.getLogger(CommentPatternManager.class);
    private Connection con = null;

    public CommentPatternManager(Connection connection) {
        this.con = connection;
    }

    public List<Integer> getCidsByPatternId(int patid) throws SQLException {
        ArrayList<Integer> cids = new ArrayList<Integer>();
        String query = "SELECT id FROM contract WHERE title_pattern_id=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, patid);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            cids.add(new Integer(Utils.parseInt(rs.getString(1))));
        }
        rs.close();
        ps.close();
        return cids;
    }

    public void updateContractComment(int cid) throws SQLException {
        String patid = "";
        String query = "SELECT title_pattern_id FROM contract WHERE id=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, cid);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            patid = rs.getString(1);
        }
        rs.close();
        ps.close();
        if ("0".equals(patid)) {
            return;
        }
        query = "UPDATE contract SET comment=? WHERE id=?";
        ps = this.con.prepareStatement(query);
        ps.setString(1, this.transformValueToComment(Utils.parseInt(patid), cid));
        ps.setInt(2, cid);
        ps.executeUpdate();
        ps.close();
    }

    public String transformValueToComment(int patternId, int contractId) throws SQLException {
        Set<Integer> pids;
        String rawValue = "";
        PreparedStatement ps = this.con.prepareStatement("SELECT pat FROM contract_comment_patterns WHERE id=?");
        ps.setInt(1, patternId);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            rawValue = rs.getString(1);
        }
        rs.close();
        ps.close();
        ContractCommentPatternEvent event = new ContractCommentPatternEvent(contractId, rawValue);
        try {
            rawValue = EventProcessor.getInstance().request(event).getCommentPattern();
        }
        catch (BGException e1) {
            this.logger.error((Object)e1);
        }
        if (rawValue != null && !rawValue.isEmpty() && !(pids = this.getPids(rawValue)).isEmpty()) {
            try (ContractDao contractDao = new ContractDao(this.con, 0);){
                Map<Integer, String> values = contractDao.getContractParameterValuesForParameterIds(contractId, pids);
                for (int key : pids) {
                    rawValue = rawValue.replaceAll("\\$\\{param_" + key + "\\}", Utils.maskNull(values.get(key)));
                }
            }
            catch (Exception e) {
                this.logger.error((Object)e);
            }
        }
        return rawValue;
    }

    private Set<Integer> getPids(String val) {
        int found;
        LinkedHashSet<Integer> result = new LinkedHashSet<Integer>();
        int last = 0;
        while ((found = val.indexOf("${param_", last)) != -1) {
            last = found + 8;
            found = val.indexOf("}", last);
            Integer pid = new Integer(Utils.parseInt(val.substring(last, found)));
            result.add(pid);
        }
        return result;
    }
}

