/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.bean;

import bitel.billing.server.contract.bean.BalanceUtils;
import bitel.billing.server.tariff.TariffTreeSet;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.Calendar;
import java.util.Date;
import javax.xml.bind.annotation.XmlTransient;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.ContractTariffOptionList;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.IdTitle;

public class Contract
extends IdTitle
implements Serializable,
Comparable<Contract> {
    public static final int CREDIT_BALANCE_MODE = 0;
    public static final int DEBET_BALANCE_MODE = 1;
    public static final int IS_SUPER = -1;
    public static final int IS_INDEPENDENT = 0;
    private TariffTreeSet tts;
    private ContractTariffOptionList tariffOptions;
    private int status;
    private Calendar statusDate;
    private int superId;
    private String dependSubList;
    private int subMode;
    private int balanceMode = 0;
    private String pswd = null;
    private BigDecimal limit;
    private long groups = 0L;
    private int paramGroup;
    private int fc;
    private Date date1;
    private Date date2;
    private String comment;
    private int del;
    private int titlePatternId = 0;
    private int domainId;

    public Contract() {
        this.id = -1;
    }

    public static Contract getContractFromNew(ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract contract) {
        if (contract == null) {
            return null;
        }
        Contract contractOld = new Contract();
        contractOld.setId(contract.getId());
        contractOld.setTitle(contract.getTitle());
        contractOld.setGroups(contract.getGroups());
        contractOld.setPswd(contract.getPassword());
        contractOld.setDateFrom(contract.getDateFrom());
        contractOld.setDateTo(contract.getDateTo());
        contractOld.setBalanceMode(contract.getBalanceMode());
        contractOld.setBalanceLimit(contract.getBalanceLimit());
        contractOld.setParamGroup(contract.getParamGroupId());
        contractOld.setFc(contract.getPersonType());
        contractOld.setComment(contract.getComment());
        contractOld.setDel(contract.isHidden() ? 1 : 0);
        contractOld.setSuperId(contract.getSuperCid());
        contractOld.setDependSubList(contract.getDependSubList());
        contractOld.setStatus(contract.getStatus());
        contractOld.setStatusDate(TimeUtils.convertDateToCalendar(contract.getStatusTimeChange()));
        contractOld.setTitlePatternId(contract.getTitlePatternId());
        contractOld.setSubMode(contract.getBalanceSubMode());
        return contractOld;
    }

    public ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract getNewContract() {
        ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract contract = new ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract();
        contract.setId(this.id);
        contract.setTitle(this.title);
        contract.setGroups(this.groups);
        contract.setPassword(this.pswd);
        contract.setDateFrom(this.date1);
        contract.setDateTo(this.date2);
        contract.setBalanceMode((byte)this.balanceMode);
        contract.setBalanceLimit(this.limit);
        contract.setParamGroupId(this.paramGroup);
        contract.setPersonType((byte)this.fc);
        contract.setComment(this.comment);
        contract.setHidden(this.del == 1);
        contract.setSuperCid(this.superId);
        contract.setDependSubList(this.dependSubList);
        contract.setStatus((byte)this.status);
        contract.setStatusTimeChange(TimeUtils.convertCalendarToDate(this.statusDate));
        contract.setTitlePatternId(this.titlePatternId);
        contract.setBalanceSubMode((byte)this.subMode);
        return contract;
    }

    public int getTitlePatternId() {
        return this.titlePatternId;
    }

    public void setTitlePatternId(int id) {
        this.titlePatternId = id;
    }

    public int getBalanceMode() {
        return this.balanceMode;
    }

    public void setBalanceMode(int balanceMode) {
        this.balanceMode = balanceMode;
    }

    public BigDecimal getBalanceLimit() {
        return this.limit;
    }

    public void setBalanceLimit(BigDecimal limit) {
        this.limit = limit;
    }

    @XmlTransient
    public TariffTreeSet getTts() {
        return this.tts;
    }

    public void setTts(TariffTreeSet tts) {
        this.tts = tts;
    }

    @XmlTransient
    public ContractTariffOptionList getTariffOptions() {
        return this.tariffOptions;
    }

    public void setTariffOptions(ContractTariffOptionList tariffOptions) {
        this.tariffOptions = tariffOptions;
    }

    public long getGroups() {
        return this.groups;
    }

    public void setGroups(long groups) {
        this.groups = groups;
    }

    public int getParamGroup() {
        return this.paramGroup;
    }

    public int getFc() {
        return this.fc;
    }

    public Date getDateFrom() {
        return this.date1;
    }

    public Date getDateTo() {
        return this.date2;
    }

    public int getDel() {
        return this.del;
    }

    public String getComment() {
        return this.comment;
    }

    public String getPswd() {
        return this.pswd;
    }

    public void setParamGroup(int paramGroup) {
        this.paramGroup = paramGroup;
    }

    public void setFc(int fc) {
        this.fc = fc;
    }

    public void setDateFrom(Date date1) {
        this.date1 = date1;
    }

    public void setDateTo(Date date2) {
        this.date2 = date2;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setDel(int del) {
        this.del = del;
    }

    public void setPswd(String pswd) {
        this.pswd = pswd;
    }

    public int getSuperId() {
        return this.superId;
    }

    public void setSuperId(int superId) {
        this.superId = superId;
    }

    public String getDependSubList() {
        return this.dependSubList;
    }

    public void setDependSubList(String subList) {
        this.dependSubList = subList;
    }

    public boolean isIndepend() {
        return this.superId == 0;
    }

    public boolean isSuper() {
        return this.superId == -1;
    }

    public boolean isSub() {
        return this.superId > 0;
    }

    public boolean isDependSub() {
        return this.superId > 0 && this.subMode == 0;
    }

    public boolean isIndependSub() {
        return this.superId > 0 && this.subMode == 1;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public Calendar getStatusDate() {
        return this.statusDate;
    }

    public void setStatusDate(Calendar statusDate) {
        this.statusDate = statusDate;
    }

    public int getSubMode() {
        return this.subMode;
    }

    public void setSubMode(int subMode) {
        this.subMode = subMode;
    }

    @Deprecated
    public boolean statusMayBeOpen() {
        return this.status == 3 || this.status == 2;
    }

    @Deprecated
    public boolean statusServiceClosed() {
        return this.status == 3 || this.status == 2 || this.status == 4;
    }

    @Deprecated
    public boolean statusMayByOpenInModule() {
        return this.status == 0;
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer(40);
        result.append("Contract: ");
        result.append(this.title);
        result.append("; limit: ");
        result.append(this.limit);
        result.append("; mode: ");
        result.append(this.balanceMode == 1 ? "DEBET" : "CREDIT");
        return result.toString();
    }

    @Override
    public int compareTo(Contract o) {
        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof Contract && ((Contract)obj).getId() == this.id;
    }

    @Deprecated
    public BigDecimal getBalanceRest(Connection con, Date time) {
        try (BalanceUtils bu = new BalanceUtils(con);){
            BigDecimal bigDecimal = bu.getBalance(time, this.getId()).subtract(this.getBalanceLimit());
            return bigDecimal;
        }
    }

    public int getDomainId() {
        return this.domainId;
    }

    public void setDomainId(int domainId) {
        this.domainId = domainId;
    }
}

