/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import ru.bitel.bgbilling.kernel.script.common.bean.ContractScript;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;

public class ContractScriptManager {
    private Connection con;

    public ContractScriptManager(Connection con) {
        this.con = con;
    }

    public List<ContractScript> getContractScriptList(int cid) {
        ArrayList<ContractScript> result = new ArrayList<ContractScript>();
        try {
            String query = "SELECT * FROM contract_script WHERE cid=? ORDER BY date1";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ContractScript script = new ContractScript();
                ContractScriptManager.loadFromRS(script, rs);
                result.add(script);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public List<ContractScript> getContractScriptList(int cid, Calendar date) {
        ArrayList<ContractScript> result = new ArrayList<ContractScript>();
        try {
            String query = "SELECT * FROM contract_script WHERE cid=? AND (date1 IS NULL OR date1<=?) AND (date2 IS NULL OR date2>=?)";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            ps.setDate(2, TimeUtils.convertCalendarToSqlDate(date));
            ps.setDate(3, TimeUtils.convertCalendarToSqlDate(date));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ContractScript contractScript = new ContractScript();
                ContractScriptManager.loadFromRS(contractScript, rs);
                result.add(contractScript);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public ContractScript getContractScriptById(int id) {
        ContractScript result = null;
        try {
            String query = "SELECT * FROM contract_script WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = new ContractScript();
                ContractScriptManager.loadFromRS(result, rs);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    @Deprecated
    public ContractScript getContractScriptByID(int id) {
        return this.getContractScriptById(id);
    }

    public ContractScript getContractScriptByScriptId(int cid, int scriptId) {
        ContractScript result = null;
        try {
            String query = "SELECT * FROM contract_script WHERE cid=? AND script_id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            ps.setInt(2, scriptId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = new ContractScript();
                ContractScriptManager.loadFromRS(result, rs);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    @Deprecated
    public ContractScript getContractScriptByScriptID(int cid, int scriptId) {
        return this.getContractScriptByScriptId(cid, scriptId);
    }

    @Deprecated
    public void updateContractScript(String id, ContractScript contractScript) {
        contractScript.setId(Utils.parseInt(id));
        this.updateContractScript(contractScript);
    }

    public void updateContractScript(ContractScript contractScript) {
        try {
            String query = null;
            PreparedStatement ps = null;
            boolean isInsert = contractScript.getId() < 1;
            query = (isInsert ? "INSERT INTO " : "UPDATE ") + "contract_script SET cid=?, date1=?, date2=?, script_id=?, comment=?" + (isInsert ? "" : " WHERE id=?");
            ps = this.con.prepareStatement(query, 1);
            ps.setInt(1, contractScript.getContractId());
            Period period = contractScript.getPeriod();
            ps.setDate(2, TimeUtils.convertDateToSqlDate(period != null ? period.getDateFrom() : null));
            ps.setDate(3, TimeUtils.convertDateToSqlDate(period != null ? period.getDateTo() : null));
            ps.setInt(4, contractScript.getScriptId());
            ps.setString(5, contractScript.getComment() == null ? "" : contractScript.getComment());
            if (!isInsert) {
                ps.setInt(6, contractScript.getId());
            }
            ps.executeUpdate();
            contractScript.setId(isInsert ? ServerUtils.lastInsertId(ps) : contractScript.getId());
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void deleteContractScript(int id) {
        try {
            String query = "DELETE FROM contract_script WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void deleteScript(int scriptId) {
        try {
            String query = "DELETE FROM contract_script WHERE script_id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, scriptId);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void deleteScript(int scriptId, List<Integer> cids) {
        if (cids == null || cids.isEmpty()) {
            return;
        }
        try {
            String query = "DELETE FROM contract_script WHERE script_id=? AND cid IN (" + Utils.toString(cids) + ")";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, scriptId);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void loadFromRS(ContractScript script, ResultSet rs) throws SQLException {
        script.setId(rs.getInt("id"));
        script.setContractId(rs.getInt("cid"));
        script.setDate1(TimeUtils.convertDateToCalendar(rs.getDate("date1")));
        script.setDate2(TimeUtils.convertDateToCalendar(rs.getDate("date2")));
        script.setScriptId(rs.getInt("script_id"));
        script.setComment(rs.getString("comment"));
    }
}

