/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.bean;

import bitel.billing.server.contract.bean.ContractTariff;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

@Deprecated
public class ContractTariffManager {
    private Connection con;

    public ContractTariffManager(Connection con) {
        this.con = con;
    }

    public ContractTariff getContractTariffById(int id) {
        ContractTariff result = null;
        try {
            String query = "SELECT * FROM contract_tariff WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = new ContractTariff();
                this.loadFromRS(result, rs);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    @Deprecated
    public ContractTariff getContractTariffByID(int id) {
        return this.getContractTariffById(id);
    }

    public void deleteContractTariff(int id) {
        try {
            String query = "DELETE FROM contract_tariff WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Deprecated
    public void updateContractTariff(String id, ContractTariff value) {
        value.setId(Utils.parseInt(id));
        this.updateContractTariff(value);
    }

    public void updateContractTariff(ContractTariff value) {
        try {
            String query = null;
            PreparedStatement ps = null;
            if (value.getId() <= 0) {
                query = "INSERT INTO contract_tariff( cid, date1, date2, tpid, comment, pos, emid, eid, replaced_from ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
                ps = this.con.prepareStatement(query, 1);
            } else {
                query = "UPDATE contract_tariff SET cid=?, date1=?, date2=?, tpid=?, comment=?, pos=?, emid=?, eid=?, replaced_from=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(10, value.getId());
            }
            ps.setInt(1, value.getContractId());
            ps.setDate(2, TimeUtils.convertCalendarToSqlDate(value.getDate1()));
            ps.setDate(3, TimeUtils.convertCalendarToSqlDate(value.getDate2()));
            ps.setInt(4, value.getTariffPlanId());
            ps.setString(5, value.getComment());
            ps.setInt(6, value.getPos());
            ps.setInt(7, value.getEntityMid());
            ps.setInt(8, value.getEntityId());
            ps.setInt(9, value.getReplacedFromContractTariffId());
            ps.executeUpdate();
            if (value.getId() <= 0) {
                value.setId(ServerUtils.lastInsertId(ps));
            }
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Deprecated
    public List<ContractTariff> getContractTariffList(int cid, Calendar calendar) {
        return this.getContractTariffList(cid, calendar != null ? calendar.getTime() : null);
    }

    public List<ContractTariff> getContractTariffList(int cid, Date date) {
        return this.getContractTariffList(cid, date, 0, 0);
    }

    public List<ContractTariff> getContractTariffList(int cid, Date date, int emid, int eid) {
        ArrayList<ContractTariff> result = new ArrayList<ContractTariff>();
        try {
            String query = "SELECT * FROM contract_tariff WHERE cid=? AND " + (emid >= 0 ? "emid=" + emid + " AND eid=" + eid : "emid=0 AND eid=0") + " AND ( ? IS NULL OR (( date1 IS NULL OR date1<=? ) AND ( date2 IS NULL OR date2>=? )) ) ORDER BY date1";
            PreparedStatement ps = this.con.prepareStatement(query);
            java.sql.Date sqlDate = TimeUtils.convertDateToSqlDate(date);
            ps.setInt(1, cid);
            ps.setDate(2, sqlDate);
            ps.setDate(3, sqlDate);
            ps.setDate(4, sqlDate);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ContractTariff ctp = new ContractTariff();
                this.loadFromRS(ctp, rs);
                result.add(ctp);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public ContractTariff getContractTariff(int cid, Calendar date) {
        ContractTariff result = null;
        List<ContractTariff> list = this.getContractTariffList(cid, date);
        if (list.size() > 0) {
            result = list.get(0);
        }
        return result;
    }

    private void loadFromRS(ContractTariff result, ResultSet rs) throws SQLException {
        result.setId(rs.getInt("id"));
        result.setContractId(rs.getInt("cid"));
        result.setDate1(TimeUtils.convertDateToCalendar(rs.getDate("date1")));
        result.setDate2(TimeUtils.convertDateToCalendar(rs.getDate("date2")));
        result.setTariffPlanId(rs.getInt("tpid"));
        result.setComment(rs.getString("comment"));
        result.setPos(rs.getInt("pos"));
        result.setEntityMid(rs.getInt("emid"));
        result.setEntityId(rs.getInt("eid"));
        result.setReplacedFromContractTariffId(rs.getInt("replaced_from"));
    }

    public boolean checkDoubleTariffForContract(int cid, int tpid, Calendar date1, Calendar date2) {
        try {
            String query = "SELECT * FROM contract_tariff WHERE cid=? AND tpid=? AND (date1 IS NULL OR ? IS NULL OR date1<=?) AND (date2 IS NULL OR ? IS NULL OR ?<=date2)";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            ps.setInt(2, tpid);
            ps.setDate(3, TimeUtils.convertCalendarToSqlDate(date2));
            ps.setDate(4, TimeUtils.convertCalendarToSqlDate(date2));
            ps.setDate(5, TimeUtils.convertCalendarToSqlDate(date1));
            ps.setDate(6, TimeUtils.convertCalendarToSqlDate(date1));
            ResultSet rs = ps.executeQuery();
            boolean result = rs.next();
            ps.close();
            return result;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }
}

