/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.object.action;

import bitel.billing.server.admin.bean.AddressCountry;
import bitel.billing.server.admin.bean.AddressStruct;
import bitel.billing.server.admin.bean.AddressUtils;
import bitel.billing.server.contract.object.action.base.ActionBase;
import bitel.billing.server.contract.object.bean.AddressParamValue;
import java.sql.SQLException;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.directory.address.AddressArea;
import ru.bitel.bgbilling.kernel.directory.address.AddressCity;
import ru.bitel.bgbilling.kernel.directory.address.AddressDirectoryManager;
import ru.bitel.bgbilling.kernel.directory.address.AddressHouse;
import ru.bitel.bgbilling.kernel.directory.address.AddressQuarter;
import ru.bitel.bgbilling.kernel.directory.address.AddressStreet;

public class ActionAddressParamValueUpdate
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        int objectId = this.getIntParameter("object", -1);
        int paramId = this.getIntParameter("param", -1);
        int formatKey = this.getIntParameter("formatKey", 0);
        if (objectId <= 0 || paramId <= 0) {
            throw new BGIllegalArgumentException();
        }
        AddressParamValue paramValue = new AddressParamValue();
        paramValue.setObjectId(objectId);
        paramValue.setParamId(paramId);
        paramValue.setAddress("");
        int hid = this.getIntParameter("hid", -1);
        int pod = this.getIntParameter("pod", 0);
        int floor = this.getIntParameter("floor", 0);
        if (hid > 0) {
            AddressDirectoryManager addressDirectoryManager = new AddressDirectoryManager(this.con);
            AddressHouse addressHouse = addressDirectoryManager.getAddressHouse(hid);
            AddressArea addressArea = addressDirectoryManager.getAddressArea(addressHouse.getAreaId());
            AddressStreet addressStreet = addressDirectoryManager.getAddressStreet(addressHouse.getStreetId());
            AddressQuarter addressQuarter = addressDirectoryManager.getAddressQuarter(addressHouse.getQuarterId());
            AddressCity addressCity = addressDirectoryManager.getAddressCity(addressStreet.getCityId());
            AddressCountry addressCountry = addressDirectoryManager.getAddressCountry(addressCity.getCountryId());
            AddressStruct addressStruct = new AddressStruct();
            addressStruct.setIndex(addressHouse.getPostIndex());
            addressStruct.setCountry(addressCountry != null ? addressCountry.getTitle() : "");
            addressStruct.setCity(addressCity.getTitle());
            addressStruct.setArea(addressArea != null ? addressArea.getTitle() : null);
            addressStruct.setQuarter(addressQuarter != null ? addressQuarter.getTitle() : null);
            addressStruct.setStreet(addressStreet.getTitle());
            addressStruct.setHouse(String.valueOf(addressHouse.getHouse()));
            addressStruct.setFrac(addressHouse.getFrac());
            addressStruct.setFlat(this.getParameter("flat"));
            addressStruct.setRoom(this.getParameter("room", "").trim());
            addressStruct.setPod(pod > 0 ? String.valueOf(pod) : null);
            addressStruct.setFloor(floor != 0 ? String.valueOf(floor) : null);
            addressStruct.setComment(this.getParameter("comment", ""));
            paramValue.setHouseId(hid);
            paramValue.setFlat(addressStruct.getFlat());
            paramValue.setRoom(addressStruct.getRoom());
            paramValue.setPod(pod);
            paramValue.setFloor(floor);
            paramValue.setComment(addressStruct.getComment());
            String sortOrder = this.setup.get("addrs.format.list", null);
            if (sortOrder != null) {
                String[] orderValues = sortOrder.trim().split(";");
                String format = "";
                if (formatKey == 0) {
                    format = String.valueOf(0);
                } else if (formatKey > 0) {
                    format = orderValues[formatKey - 1];
                }
                paramValue.setFormatKey(format);
                String fullAddress = AddressUtils.getAddress(this.setup, addressStruct, format);
                paramValue.setAddress(fullAddress);
            } else {
                paramValue.setFormatKey("");
                String fullAddress = AddressUtils.getAddress(this.setup, addressStruct, "op" + paramId);
                paramValue.setAddress(fullAddress);
            }
        }
        this.changeObjectParam(objectId, paramId, paramValue, this.userId);
    }
}

