/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.object.action;

import bitel.billing.server.contract.object.action.base.ActionBase;
import bitel.billing.server.contract.object.bean.ContractObject;
import bitel.billing.server.contract.object.bean.ObjectManager;
import bitel.billing.server.contract.object.bean.ObjectType;
import bitel.billing.server.contract.object.bean.ObjectTypeManager;
import java.sql.SQLException;
import java.util.Map;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class ActionObjectTable
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        if (this.cid <= 0) {
            throw new BGIllegalArgumentException();
        }
        Page page = this.getPage();
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        Map<Integer, ObjectType> typeMap = new ObjectTypeManager(this.con).getTypeMap();
        SearchResult<ContractObject> searchResult = new SearchResult<ContractObject>();
        searchResult.setPage(page);
        new ObjectManager(this.con).findObjectList(searchResult, this.cid, this.getIntParameter("filterTypeId", -1), this.getParameter("filterTitle"));
        for (ContractObject object : searchResult.getList()) {
            Element row = this.createElement(data, "row");
            row.setAttribute("id", String.valueOf(object.getId()));
            row.setAttribute("title", object.getTitle());
            ObjectType type = typeMap.get(object.getTypeId());
            if (type != null) {
                row.setAttribute("type", type.getTitle());
            } else {
                row.setAttribute("type", "???");
            }
            row.setAttribute("type_id", String.valueOf(object.getTypeId()));
            row.setAttribute("period", TimeUtils.formatPeriod(object.getDate1(), object.getDate2()));
        }
        this.setPageAttribute(table, page);
        if (this.getBooleanParameter("loadObjectTypes", false)) {
            XMLUtils.createListElement(this.rootNode, "types", new ObjectTypeManager(this.con).getTypeList(false), ObjectType.class, new String[]{"id", "title"});
        }
    }
}

