/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.installer;

import bitel.billing.server.installer.Install;
import bitel.billing.server.installer.InstallerModule;
import bitel.billing.server.installer.Update;
import java.io.File;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.stream.Stream;
import ru.bitel.bgbilling.kernel.dynamic.server.ReadWriteClassManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

public class ModuleInstaller {
    private static final String K_KILLHASH = "killhash";
    private static final String K_UPDATE = "update";
    private static final String K_INSTALL = "install";
    private static final String K_RECOMPILE_DYN = "recompileDyn";

    public static void main(String[] args) {
        Setup setup = new Setup("data.data");
        Setup.setSetup(setup);
        try {
            ModuleInstaller.parseArgs(args);
        }
        catch (WrongArgumentsException ex) {
            System.err.println(ex.toString());
            System.out.println(ModuleInstaller.getHelp());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.exit(0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void parseArgs(String[] args) throws WrongArgumentsException {
        if (args == null || args.length == 0) {
            throw new WrongArgumentsException("No arguments!");
        }
        if (args.length == 3) {
            String val1 = args[1];
            String val2 = args[2];
            if (!args[0].equals(K_INSTALL)) throw new WrongArgumentsException("Argument error!");
            new Install(val1, val2);
            return;
        } else if (args.length == 2) {
            String val1 = args[1];
            if (args[0].equals(K_UPDATE)) {
                new Update(val1);
                return;
            } else if (args[0].equals(K_INSTALL)) {
                new Install(val1, null);
                return;
            } else if (args[0].equals(K_KILLHASH)) {
                InstallerModule.clearHashById(val1);
                System.out.println("Hash killing for " + val1 + " finished!");
                return;
            } else if ("autoinstall".equals(args[0]) || "autoinstall-libs".equals(args[0])) {
                ModuleInstaller.autoinstall(args[0], val1);
                return;
            } else {
                if (!K_RECOMPILE_DYN.equals(args[0])) throw new WrongArgumentsException("Argument error!");
                ModuleInstaller.recompileDynClasses();
            }
            return;
        } else {
            if (args.length != 1) throw new WrongArgumentsException("Argument error!");
            if (args[0].equals(K_UPDATE)) {
                new Update();
                return;
            } else if (K_RECOMPILE_DYN.equals(args[0])) {
                ModuleInstaller.recompileDynClasses();
                return;
            } else {
                File zipFile;
                String zipPath = args[0];
                if (zipPath != null && zipPath.endsWith("!")) {
                    zipPath = zipPath.substring(0, zipPath.length() - 1);
                }
                if (!(zipFile = new File(zipPath)).exists()) throw new WrongArgumentsException("Can't find " + zipPath);
                ArrayList<String> replacedFiles = new ArrayList<String>();
                new InstallerModule(zipFile, replacedFiles);
                InstallerModule.replacedReport(replacedFiles);
            }
        }
    }

    private static void autoinstall(String command, String modules) {
        boolean onlyCopyFiles = "autoinstall-libs".equals(command);
        for (String module : Utils.toList(modules)) {
            File zipFile = Stream.of(new File(".install").listFiles((dir, name) -> name.endsWith(".zip") && name.startsWith(module + "_"))).findFirst().orElse(null);
            if (zipFile != null && zipFile.exists()) {
                ArrayList<String> replacedFiles = new ArrayList<String>();
                new InstallerModule(zipFile, replacedFiles, onlyCopyFiles);
                InstallerModule.replacedReport(replacedFiles);
                continue;
            }
            System.err.println("Can't find module for autoinstall: " + module);
        }
    }

    private static void recompileDynClasses() {
        Connection con = Setup.getSetup().getDBConnectionFromPool();
        try {
            con.setAutoCommit(false);
            new ReadWriteClassManager().recompileAllClasses(con);
            con.commit();
        }
        catch (Exception e) {
            System.err.println("Error of dyn class recompilation...");
            e.printStackTrace();
        }
        finally {
            ServerUtils.closeConnection(con);
        }
    }

    private static String getHelp() {
        StringBuffer sb = new StringBuffer();
        sb.append("\nUsage: <module's zip> | update [<set>] | install <module> [<set>] | killhash <id> | recompileDyn");
        sb.append("\nParameters:");
        sb.append("\n\t update\t update all modules.");
        sb.append("\n\t update <set>\t update all modules on <set>.");
        sb.append("\n\t install <module>\t download and (re)install component.");
        sb.append("\n\t install <module> <set>\t download and (re)install component on <set>.");
        sb.append("\n\t killhash <id>\t kills module cash of sql queries with id equal to <id>. Here ");
        sb.append("<id> must begin with 'm' for modules . without  'm' - for plugins. 0 - kernel");
        sb.append("\n\t recompileDyn\t full dyn code recompilation");
        sb.append("\n\nExamples: ");
        sb.append("\n\t bg_installer.sh /tmp/dialup_1.2.zip");
        sb.append("\n\t bg_installer.sh update");
        sb.append("\n\t bg_installer.sh recompileDyn");
        sb.append("\n\t bg_installer.sh install inet");
        sb.append("\n\t bg_installer.sh killhash m1\t- kill hash of sql queries for module with  id=1");
        sb.append("\n\t bg_installer.sh killhash 1\t- kill hash of sql queries for plugin with  id=1");
        return sb.toString();
    }

    private static class WrongArgumentsException
    extends Exception {
        private String message;

        public WrongArgumentsException(String message) {
            this.message = "Wrong arguments: " + message;
        }

        @Override
        public String toString() {
            return this.message;
        }
    }
}

