/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.load;

import bitel.billing.server.load.FileInfo;
import bitel.billing.server.load.Loader;
import bitel.billing.server.load.bean.Source;
import java.io.File;

public class FileLoader
extends Loader {
    public FileLoader(int taskId, Source source, FileInfo fileInfo, String tempDirPath) {
        super(taskId, source, fileInfo, tempDirPath);
    }

    @Override
    public void run() {
        try {
            String fs = System.getProperty("file.separator");
            String dir = this.source.getHostOrDir();
            if (dir == null) {
                dir = "";
            }
            if ("".equals(dir = dir.trim())) {
                throw new Exception("Error: dir = \"" + dir + "\"");
            }
            String fileName = dir + this.fileInfo.getPath(fs) + fs + this.fileInfo.getFileName() + ".zip";
            this.logger.info((Object)(this.taskId + " Load data from: " + fileName));
            File file = new File(fileName);
            try {
                this.fileInfo.setSourceSize(file.length());
                this.fileInfo.setSourceTime(file.lastModified());
            }
            catch (Exception ioError) {
                this.logger.error((Object)(this.taskId + " IOException: " + fileName));
                this.fileInfo.setSourceSize(-1L);
                this.fileInfo.setSourceTime(-1L);
            }
            if (this.fileInfo.needLoadFile()) {
                this.logger.info((Object)(this.taskId + " Set to load " + fileName));
                this.fileInfo.setFile(file);
                this.load = true;
            } else {
                this.logger.info((Object)(this.taskId + " no need load.."));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

