/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.tariff;

import bitel.billing.server.tariff.TariffRequest;
import bitel.billing.server.tariff.TariffTreeNode;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class DefaultTariffTreeNode
implements TariffTreeNode {
    protected TariffTreeNode _parent = null;
    protected int _deep = -1;
    protected int _nodeId = -1;
    protected String _data;
    protected Vector<TariffTreeNode> _childs;

    @Override
    public void init(String data, int deep, int nodeId) {
        this._deep = deep;
        this._data = data;
        this._nodeId = nodeId;
    }

    @Override
    public final Vector<TariffTreeNode> getChilds() {
        if (this._childs == null) {
            this._childs = new Vector();
        }
        return this._childs;
    }

    @Override
    public int getId() {
        return this._nodeId;
    }

    @Override
    public final void loadChilds(TariffTreeNode parent, HashMap<Integer, Vector<TariffTreeNode>> nodes) {
        this._parent = parent;
        this._childs = nodes.remove(this._nodeId);
        if (this._childs != null) {
            int size = this._childs.size();
            TariffTreeNode child = null;
            for (int i = 0; i < size; ++i) {
                child = this._childs.get(i);
                child.loadChilds(this, nodes);
            }
        }
    }

    @Override
    public void processRequest(TariffRequest request) {
        String action = (String)request.getRequestParam("action");
        if (action != null && action.equals("reset") || !request.wasAccepted()) {
            this.processForChilds(request);
        }
    }

    protected final void processForChilds(TariffRequest request) {
        if (this._childs != null) {
            int size = this._childs.size();
            for (int i = 0; i < size; ++i) {
                this._childs.get(i).processRequest(request);
            }
        }
    }

    protected final void processForMirrorNode(TariffRequest request) {
        if (this._parent != null) {
            Vector<TariffTreeNode> near = this._parent.getChilds();
            int size = near.size();
            for (int i = 0; i < size; ++i) {
                if (near.get(i) != this) continue;
                near.get(size - i - 1).processRequest(request);
                break;
            }
        }
    }

    protected final Map<String, String> getDataInHash() {
        HashMap<String, String> result = new HashMap<String, String>();
        StringTokenizer pairsSt = new StringTokenizer(this._data, "%");
        while (pairsSt.hasMoreTokens()) {
            String pair = pairsSt.nextToken();
            StringTokenizer key_value = new StringTokenizer(pair, "&");
            if (key_value.countTokens() != 2) continue;
            result.put(key_value.nextToken(), key_value.nextToken());
        }
        return result;
    }

    protected final long getServiceAmount(int type, long col) {
        long divisor;
        switch (type) {
            case 0: {
                divisor = col;
                break;
            }
            case 1: {
                divisor = col * 1024L;
                break;
            }
            case 2: {
                divisor = col * 0x100000L;
                break;
            }
            case 3: {
                divisor = col * 0x40000000L;
                break;
            }
            case 4: {
                divisor = col;
                break;
            }
            case 5: {
                divisor = col * 60L;
                break;
            }
            case 6: {
                divisor = col * 3600L;
                break;
            }
            default: {
                divisor = 0L;
            }
        }
        return divisor;
    }
}

