/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.tariff;

import bitel.billing.server.tariff.DefaultTariffTreeNode;
import bitel.billing.server.tariff.TariffRequest;
import java.math.BigDecimal;
import java.util.Map;

public class ServiceUnitCostTariffTreeNode
extends DefaultTariffTreeNode {
    private BigDecimal cost;
    private BigDecimal divisor;

    @Override
    public void init(String dataStr, int deep, int nodeID) {
        super.init(dataStr, deep, nodeID);
        Map<String, String> data = this.getDataInHash();
        String cost = data.get("cost");
        String col = data.get("col");
        if (cost != null && col != null) {
            try {
                this.cost = new BigDecimal(cost);
                this.divisor = new BigDecimal(col);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void processRequest(TariffRequest request) {
        if (this.cost != null && this.divisor != null && this.divisor.longValue() > 0L) {
            request.setResponseParam("divisor", this.divisor);
            request.setResponseParam("cost", this.cost);
            request.setAccepted();
        }
    }
}

