/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.tariff;

import bitel.billing.server.tariff.DefaultTariffTreeNode;
import bitel.billing.server.tariff.TariffRequest;
import bitel.billing.server.tariff.TimeLimits;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import ru.bitel.common.Utils;

public class TimeFilterTariffTreeNode
extends DefaultTariffTreeNode {
    private List<TimeLimits> _timeLimits = new ArrayList<TimeLimits>();
    private int timeRange = 0;

    @Override
    public void init(String data, int deep, int nodeID) {
        super.init(data, deep, nodeID);
        Map<String, String> values = this.getDataInHash();
        for (String key : values.keySet()) {
            if (Utils.parseInt(key, -1) < 0) continue;
            String limitStr = values.get(key);
            this._timeLimits.add(new TimeLimits(limitStr));
        }
        this.timeRange = Utils.parseInt(values.get("time_range"), -1);
    }

    private boolean checkTime(Calendar time) {
        boolean result = false;
        int size = this._timeLimits.size();
        if (size == 0) {
            result = true;
        } else {
            TimeLimits tl;
            for (int i = 0; i < size && !(result = (tl = this._timeLimits.get(i)).checkDate(time)); ++i) {
            }
        }
        return result;
    }

    @Override
    public void processRequest(TariffRequest request) {
        String action = (String)request.getRequestParam("action");
        Calendar time = (Calendar)request.getRequestParam("time");
        String paramName = "t_f_a_" + this._parent.getId();
        String timeFilterAccepted = (String)request.getResponseParam(paramName);
        if (action != null && action.equals("reset")) {
            this.processForChilds(request);
        } else if (time != null && timeFilterAccepted == null && this.checkTime(time)) {
            if (this.timeRange > 0) {
                request.setResponseParam("time_range", this.timeRange);
            }
            this.processForChilds(request);
            request.setResponseParam(paramName, "true");
        }
    }
}

