/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.tariff.detail;

import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.tariff.TariffModuleTree;
import bitel.billing.server.tariff.TariffRequest;
import bitel.billing.server.tariff.TariffTreeSet;
import bitel.billing.server.tariff.detail.TariffDetailKey;
import bitel.billing.server.tariff.detail.TariffDetailValue;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class TariffDetailUtils {
    public static final int CALC_TYPE_COMMON = 1;
    public static final int CALC_TYPE_MAX = 2;

    public static final void processRequest(TariffRequest request, int cid, Integer serviceId, long takedAmount, float takedCost, long nodeAmount, float cost, long divisor) {
        Integer costType = (Integer)request.getResponseParam("costType");
        if (costType != null) {
            ArrayList<TariffDetailValue> tariffDetailList;
            if (serviceId == null) {
                serviceId = 0;
            }
            if ((tariffDetailList = (ArrayList<TariffDetailValue>)request.getResponseParam("costTypeList")) == null) {
                tariffDetailList = new ArrayList<TariffDetailValue>(4);
                request.setResponseParam("costTypeList", tariffDetailList);
            }
            if (takedAmount > 0L) {
                Set tariffDetailRangeTakeAllSet = (Set)request.getRequestParam("costTypeRangeTakeAllSet");
                if (tariffDetailRangeTakeAllSet != null && tariffDetailRangeTakeAllSet.contains(costType)) {
                    tariffDetailList.add(new TariffDetailValue(cid, costType, serviceId, nodeAmount, (double)nodeAmount * (double)cost / (double)divisor, false));
                } else {
                    tariffDetailList.add(new TariffDetailValue(cid, costType, serviceId, takedAmount, takedCost));
                }
            }
        }
    }

    public static final void putTariffDetail(Map<TariffDetailKey, TariffDetailValue> tariffDetailMap, TariffRequest calcReq, int contractId, int serviceId, double fullCost, long fullAmount) {
        List tariffDetailValueList = (List)calcReq.getResponseParam("costTypeList");
        if (tariffDetailValueList != null) {
            assert (tariffDetailValueList instanceof RandomAccess);
            int n = tariffDetailValueList.size();
            for (int i = 0; i < n; ++i) {
                TariffDetailValue v = (TariffDetailValue)tariffDetailValueList.get(i);
                TariffDetailValue tariffDetailValue = tariffDetailMap.get(new TariffDetailKey(contractId, v.typeId, serviceId));
                if (tariffDetailValue == null) {
                    tariffDetailValue = new TariffDetailValue(contractId, v.typeId, serviceId, v.amount, v.cost, v.notRangeAll);
                    tariffDetailMap.put(tariffDetailValue, tariffDetailValue);
                    continue;
                }
                if (!tariffDetailValue.notRangeAll) continue;
                tariffDetailValue.cost += v.cost;
                tariffDetailValue.amount += v.amount;
            }
        } else {
            Integer costTypeId = (Integer)calcReq.getResponseParam("costType");
            if (costTypeId != null) {
                TariffDetailValue tariffDetailValue = tariffDetailMap.get(new TariffDetailKey(contractId, costTypeId, serviceId));
                if (tariffDetailValue == null) {
                    tariffDetailValue = new TariffDetailValue(contractId, costTypeId, serviceId);
                    tariffDetailMap.put(tariffDetailValue, tariffDetailValue);
                }
                tariffDetailValue.cost += fullCost;
                tariffDetailValue.amount += fullAmount;
            }
        }
    }

    public static final int flushTariffDetail(Logger logger, String module, DefaultServerSetup setup, Preferences moduleSetup, Connection con, int mid, Calendar startMonth, Calendar endMonth, String workingContracts, long groups, Map<TariffDetailKey, TariffDetailValue> tariffDetailMap, Set<Integer> tariffDetailRangeTakeAllSet, int calcType) throws SQLException {
        PreparedStatement ps;
        logger.info((Object)"Flush tariff detail...");
        String tariffDetailTableName = ServerUtils.getModuleMonthTableName("tariff_detail", startMonth.getTime(), mid);
        Set<Integer> costTypes = TariffDetailUtils.getCostTypeIdSet(moduleSetup, calcType);
        String costTypeIds = Utils.toString(costTypes);
        if (ServerUtils.tableExists(con, tariffDetailTableName)) {
            Statement stmt = con.createStatement();
            try {
                stmt.executeUpdate("ALTER TABLE " + tariffDetailTableName + " MODIFY cost DECIMAL(12,5) NOT NULL");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                stmt.executeUpdate("ALTER TABLE " + tariffDetailTableName + " ADD sid int(11) NOT NULL DEFAULT 0");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            stmt.close();
            if (costTypes.size() > 0) {
                StringBuilder sb = new StringBuilder().append("DELETE tariff_detail.* FROM ");
                sb.append(tariffDetailTableName).append(" as tariff_detail ");
                if (Utils.notBlankString(workingContracts)) {
                    sb.append("WHERE tariff_detail.cid IN (" + workingContracts + ") AND ");
                } else if (groups != 0L) {
                    sb.append("LEFT JOIN contract ON contract.id=tariff_detail.cid ");
                    sb.append("WHERE contract.gr&" + groups + ">0 AND ");
                } else {
                    sb.append("WHERE ");
                }
                sb.append("tariff_detail.cost_type_id IN (" + costTypeIds + ")");
                ps = con.prepareStatement(sb.toString());
                ps.executeUpdate();
                ps.close();
            }
        } else {
            String query = "CREATE TABLE " + tariffDetailTableName + " (cid int(11) NOT NULL, sid int(11) NOT NULL, cost_type_id int(11) NOT NULL, amount bigint(20) NOT NULL, cost DECIMAL(12,5) NOT NULL, KEY cid (cid))";
            setup.checkAndCreatePeriodicTableName(con, tariffDetailTableName, query);
        }
        HashSet<Integer> cids = new HashSet<Integer>(512);
        int lastCid = -1;
        ps = con.prepareStatement("INSERT INTO " + tariffDetailTableName + " (cid,cost_type_id,sid,amount,cost) VALUES (?,?,?,?,?)");
        for (TariffDetailValue v : tariffDetailMap.values()) {
            if (!v.notRangeAll) continue;
            if (lastCid != v.cid) {
                lastCid = v.cid;
                cids.add(v.cid);
            }
            ps.setInt(1, v.cid);
            ps.setInt(2, v.typeId);
            ps.setInt(3, v.serviceId);
            ps.setLong(4, v.amount);
            ps.setDouble(5, v.cost);
            ps.executeUpdate();
        }
        int result = tariffDetailMap.size();
        tariffDetailMap.clear();
        TariffDetailUtils.processTakeAllCostType(logger, module, moduleSetup, con, mid, tariffDetailTableName, costTypeIds, workingContracts, startMonth, endMonth, cids, tariffDetailMap, tariffDetailRangeTakeAllSet, calcType);
        result += tariffDetailMap.size();
        for (TariffDetailValue v : tariffDetailMap.values()) {
            if (v.notRangeAll) continue;
            if (lastCid != v.cid) {
                lastCid = v.cid;
                cids.add(v.cid);
            }
            ps.setInt(1, v.cid);
            ps.setInt(2, v.typeId);
            ps.setInt(3, v.serviceId);
            ps.setLong(4, v.amount);
            ps.setDouble(5, v.cost);
            ps.executeUpdate();
        }
        ps.close();
        logger.info((Object)("Flush tariff detail: [" + result + " records]"));
        return result;
    }

    private static final void processTakeAllCostType(Logger logger, String module, Preferences moduleSetup, Connection con, int mid, String tariffDetailTableName, String costTypeIds, String workingContracts, Calendar startMonth, Calendar endMonth, Set<Integer> cids, Map<TariffDetailKey, TariffDetailValue> tariffDetailMap, Set<Integer> tariffDetailRangeTakeAllSet, int calcType) throws SQLException {
        ContractManager contractManager = new ContractManager(con);
        for (Integer costTypeRangeTakeAllId : tariffDetailRangeTakeAllSet) {
            int sid = moduleSetup.getInt("tariff_detail.cost_type." + costTypeRangeTakeAllId + ".range_take_all.sid", 0);
            if (sid <= 0) continue;
            HashSet<Integer> affectedContracts = new HashSet<Integer>();
            PreparedStatement ps = con.prepareStatement("SELECT cid, date1, date2 FROM contract_service WHERE sid=? AND (date1 IS NULL OR date1<=?) AND (date2 IS NULL OR date2>=?)" + (Utils.notBlankString(workingContracts) ? " AND cid IN (" + workingContracts + ")" : ""));
            ps.setInt(1, sid);
            ps.setDate(2, TimeUtils.convertCalendarToSqlDate(endMonth));
            ps.setDate(3, TimeUtils.convertCalendarToSqlDate(startMonth));
            PreparedStatement clearPS = con.prepareStatement("DELETE FROM " + tariffDetailTableName + " WHERE " + (Utils.notBlankString(workingContracts) ? " cid IN (" + workingContracts + ") AND " : "") + "cost_type_id=" + costTypeRangeTakeAllId);
            clearPS.executeUpdate();
            clearPS.close();
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                int cid = rs.getInt(1);
                if (!affectedContracts.contains(cid)) {
                    Calendar fromDate = TimeUtils.convertDateToCalendar(rs.getDate(2));
                    Calendar toDate = TimeUtils.convertDateToCalendar(rs.getDate(3));
                    if (fromDate == null || TimeUtils.dateBefore(fromDate, startMonth)) {
                        fromDate = startMonth;
                    }
                    if (toDate == null || TimeUtils.dateBefore(endMonth, toDate)) {
                        toDate = endMonth;
                    }
                    TariffRequest calcReq = new TariffRequest();
                    calcReq.setRequestParam("cid", cid);
                    calcReq.setRequestParam("action", "calculate");
                    calcReq.setRequestParam("month_time", startMonth);
                    float part = TimeUtils.getPart(fromDate, toDate, startMonth, endMonth);
                    calcReq.setRequestParam("sid", sid);
                    calcReq.setRequestParam("time", fromDate);
                    calcReq.setRequestParam("amount", 1L);
                    calcReq.setRequestParam("part", Float.valueOf(part));
                    calcReq.setRequestParam("costTypeRangeTakeAllSet", tariffDetailRangeTakeAllSet);
                    TariffTreeSet tts = contractManager.getRealtimeTariffTreeSet(cid, fromDate.getTime(), module, mid, true);
                    TariffModuleTree tree = tts.getTree(fromDate.getTime());
                    if (tree != null) {
                        TariffRequest tariffRequest = new TariffRequest();
                        tariffRequest.setRequestParam("cid", cid);
                        tariffRequest.setRequestParam("action", "reset");
                        tree.processRequest(tariffRequest);
                        tree.processRequest(calcReq);
                        if (calcReq.wasAccepted()) {
                            calcReq.dropResponseParam("costType");
                            TariffDetailUtils.putTariffDetail(tariffDetailMap, calcReq, cid, sid, 0.0, 0L);
                        }
                    }
                }
                affectedContracts.add(cid);
            }
            ps.close();
        }
    }

    public static final Set<Integer> getCostTypeIdSet(Preferences moduleSetup, int calcType) {
        HashSet<Integer> result = new HashSet<Integer>();
        ParameterMap typeMap = moduleSetup.sub("tariff_detail.cost_type.");
        for (Map.Entry<String, String> e : typeMap.entrySet()) {
            int _calcType;
            int id = Utils.parseInt(e.getKey(), 0);
            if (id <= 0 || calcType != (_calcType = Utils.parseInt(typeMap.get(id + ".calc_type", null), 1))) continue;
            result.add(id);
        }
        return result;
    }

    public static final String getCostTypeIdString(Preferences moduleSetup, int calcType) {
        Set<Integer> result = TariffDetailUtils.getCostTypeIdSet(moduleSetup, calcType);
        if (result.size() == 0) {
            return "";
        }
        StringBuilder ids = new StringBuilder(result.size() * 5);
        for (Integer id : result) {
            ids.append(id);
            ids.append(",");
        }
        if (ids.length() > 0) {
            ids.setLength(ids.length() - 1);
        }
        return ids.toString();
    }

    public static final Set<Integer> getCostTypeRangeTakeAllIdSet(Preferences moduleSetup) {
        HashSet<Integer> result = new HashSet<Integer>(8);
        ParameterMap typeMap = moduleSetup.sub("tariff_detail.cost_type.");
        for (Map.Entry<String, String> e : typeMap.entrySet()) {
            int id = Utils.parseInt(e.getKey(), 0);
            if (id <= 0 || Utils.parseInt(typeMap.get(id + ".range_take_all", null), 0) != 1) continue;
            result.add(id);
        }
        return result;
    }
}

