/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.tariff.voice.bean;

import bitel.billing.server.tariff.voice.bean.TableManager;
import bitel.billing.server.tariff.voice.bean.ZoneManager;
import bitel.billing.server.tariff.voice.bean.ZoneMapItem;
import bitel.billing.server.tariff.voice.bean.ZoneMapManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class ZoneMapItemManager {
    private Connection con;
    private String tableName;
    private int mid;
    private PreparedStatement updateItemPS = null;
    private PreparedStatement insertItemPS = null;

    public ZoneMapItemManager(Connection con, int mid) {
        this.con = con;
        this.mid = mid;
        this.tableName = TableManager.getTable(con, mid, "zone_map_item_");
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<ZoneMapItem> getItemList(int mapId) {
        ArrayList<ZoneMapItem> result = new ArrayList<ZoneMapItem>();
        try {
            String query = "SELECT * FROM " + this.tableName + " WHERE map_id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, mapId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getItemFromRs(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void updateItem(ZoneMapItem item) {
        try {
            String query;
            if (this.updateItemPS == null) {
                query = "UPDATE " + this.tableName + " SET zone_id=? WHERE map_id=? AND code=?";
                this.updateItemPS = this.con.prepareStatement(query);
            }
            this.updateItemPS.setInt(1, item.getZoneId());
            this.updateItemPS.setInt(2, item.getMapId());
            this.updateItemPS.setString(3, item.getGCode());
            if (this.updateItemPS.executeUpdate() == 0) {
                if (this.insertItemPS == null) {
                    query = "INSERT INTO " + this.tableName + " (zone_id, map_id, code) VALUES (?, ?, ?)";
                    this.insertItemPS = this.con.prepareStatement(query);
                }
                this.insertItemPS.setInt(1, item.getZoneId());
                this.insertItemPS.setInt(2, item.getMapId());
                this.insertItemPS.setString(3, item.getGCode());
                this.insertItemPS.executeUpdate();
            }
            ServerUtils.changeLastModificationTime(this.con, "zone_map_" + this.mid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateItemLevel(ZoneMapItem item, boolean start) {
        try {
            String query = start ? "UPDATE " + this.tableName + " SET start_level=? WHERE map_id=? AND code=?" : "UPDATE " + this.tableName + " SET end_level=? WHERE map_id=? AND code=?";
            PreparedStatement updateItemLevelPS = this.con.prepareStatement(query);
            updateItemLevelPS.setInt(1, start ? item.getLevelStart() : item.getLevelEnd());
            updateItemLevelPS.setInt(2, item.getMapId());
            updateItemLevelPS.setString(3, item.getGCode());
            if (updateItemLevelPS.executeUpdate() == 0) {
                query = start ? "INSERT INTO " + this.tableName + " (start_level, map_id, code) VALUES (?, ?, ?)" : "INSERT INTO " + this.tableName + " (end_level, map_id, code) VALUES (?, ?, ?)";
                updateItemLevelPS = this.con.prepareStatement(query);
                updateItemLevelPS.setInt(1, start ? item.getLevelStart() : item.getLevelEnd());
                updateItemLevelPS.setInt(2, item.getMapId());
                updateItemLevelPS.setString(3, item.getGCode());
                updateItemLevelPS.executeUpdate();
            }
            updateItemLevelPS.close();
            ServerUtils.changeLastModificationTime(this.con, "zone_map_" + this.mid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteItem(int mapId, String code) {
        try {
            String query = "DELETE FROM " + this.tableName + " WHERE map_id=? AND code=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, mapId);
            ps.setString(2, code);
            ps.executeUpdate();
            ps.close();
            ServerUtils.changeLastModificationTime(this.con, "zone_map_" + this.mid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteCode(String code) {
        try {
            String query = "DELETE FROM " + this.tableName + " WHERE code=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setString(1, code);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteAllCodes() {
        try {
            String query = "DELETE FROM " + this.tableName;
            this.con.prepareStatement(query).executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ZoneMapItem getItemFromRs(ResultSet rs) throws SQLException {
        ZoneMapItem item = new ZoneMapItem();
        item.setMapId(rs.getInt("map_id"));
        item.setGCode(rs.getString("code"));
        item.setZoneId(rs.getInt("zone_id"));
        return item;
    }

    public void importFromFile(int mapId, String data) {
        Document doc = XMLUtils.parseDocument(data);
        try {
            Element code;
            int j;
            NodeList codes;
            Element zone;
            int i;
            String query = "DELETE FROM " + this.tableName + " WHERE map_id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, mapId);
            ps.executeUpdate();
            ps.close();
            ZoneManager man = new ZoneManager(this.con, this.mid);
            NodeList zones = doc.getDocumentElement().getElementsByTagName("zone");
            ZoneMapItem item = new ZoneMapItem();
            item.setMapId(mapId);
            for (i = 0; i < zones.getLength(); ++i) {
                zone = (Element)zones.item(i);
                int zoneId = man.getZoneId(zone.getAttribute("name"));
                item.setZoneId(zoneId);
                codes = zone.getElementsByTagName("code");
                for (j = 0; j < codes.getLength(); ++j) {
                    code = (Element)codes.item(j);
                    item.setGCode(code.getAttribute("id"));
                    this.updateItem(item);
                }
            }
            item.setZoneId(0);
            zones = doc.getDocumentElement().getElementsByTagName("start_level");
            for (i = 0; i < zones.getLength(); ++i) {
                zone = (Element)zones.item(i);
                int startLevel = Utils.parseInt(zone.getAttribute("name"), -1);
                item.setLevelStart(startLevel);
                codes = zone.getElementsByTagName("code");
                for (j = 0; j < codes.getLength(); ++j) {
                    code = (Element)codes.item(j);
                    item.setGCode(code.getAttribute("id"));
                    this.updateItemLevel(item, true);
                }
            }
            item.setLevelStart(0);
            zones = doc.getDocumentElement().getElementsByTagName("end_level");
            for (i = 0; i < zones.getLength(); ++i) {
                zone = (Element)zones.item(i);
                int endLevel = Utils.parseInt(zone.getAttribute("name"), -1);
                item.setLevelEnd(endLevel);
                codes = zone.getElementsByTagName("code");
                for (j = 0; j < codes.getLength(); ++j) {
                    code = (Element)codes.item(j);
                    item.setGCode(code.getAttribute("id"));
                    this.updateItemLevel(item, false);
                }
            }
            ServerUtils.changeLastModificationTime(this.con, "zone_map_" + this.mid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void exportToFile(int mapId, Node node) {
        ZoneMapManager zoneMapMan = new ZoneMapManager(this.con, this.mid);
        ZoneMapItemManager itemMan = new ZoneMapItemManager(this.con, this.mid);
        Map<Integer, String> zoneTitles = new ZoneManager(this.con, this.mid).getZoneTitles();
        HashMap<Integer, Element> zoneMap = new HashMap<Integer, Element>(50);
        HashMap levelStartMap = new HashMap(16);
        HashMap levelEndMap = new HashMap(16);
        Document doc = XMLUtils.newDocument();
        Element zones = doc.createElement("zones");
        zones.setAttribute("name", zoneMapMan.getZoneMap(mapId).getTitle());
        List<ZoneMapItem> itemList = itemMan.getItemList(mapId);
        for (ZoneMapItem item : itemList) {
            int endLevel;
            Element code;
            Element _zone;
            Element zone;
            int startLevel;
            int zoneId = item.getZoneId();
            if (zoneId > 0) {
                Element zone2 = (Element)zoneMap.get(zoneId);
                if (zone2 == null) {
                    Element _zone2 = doc.createElement("zone");
                    _zone2.setAttribute("name", zoneTitles.get(zoneId));
                    zones.appendChild(_zone2);
                    zone2 = doc.createElement("codes");
                    _zone2.appendChild(zone2);
                    zoneMap.put(zoneId, zone2);
                }
                Element code2 = doc.createElement("code");
                code2.setAttribute("id", item.getGCode());
                zone2.appendChild(code2);
            }
            if ((startLevel = item.getLevelStart()) > 0) {
                zone = (Element)levelStartMap.get(startLevel);
                if (zone == null) {
                    _zone = doc.createElement("start_level");
                    _zone.setAttribute("name", String.valueOf(startLevel));
                    zones.appendChild(_zone);
                    zone = doc.createElement("codes");
                    _zone.appendChild(zone);
                    zoneMap.put(startLevel, zone);
                }
                code = doc.createElement("code");
                code.setAttribute("id", item.getGCode());
                zone.appendChild(code);
            }
            if ((endLevel = item.getLevelEnd()) <= 0) continue;
            zone = (Element)levelEndMap.get(endLevel);
            if (zone == null) {
                _zone = doc.createElement("end_level");
                _zone.setAttribute("name", String.valueOf(endLevel));
                zones.appendChild(_zone);
                zone = doc.createElement("codes");
                _zone.appendChild(zone);
                zoneMap.put(endLevel, zone);
            }
            code = doc.createElement("code");
            code.setAttribute("id", item.getGCode());
            zone.appendChild(code);
        }
        node.appendChild(node.getOwnerDocument().importNode(zones, true));
    }
}

