/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.util;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.UserDataHandler;

public abstract class Iter<E>
implements Iterator<E>,
Iterable<E> {
    private static NodeList emptyList = new NodeList(){

        @Override
        public int getLength() {
            return 0;
        }

        @Override
        public Node item(int index) {
            return null;
        }
    };
    private static final BeanElement defaultBeanElement = new BeanElement("row");

    @Override
    public abstract boolean hasNext();

    @Override
    public abstract E next();

    @Override
    public void remove() {
        throw new UnsupportedOperationException("This method not supported!");
    }

    @Override
    public Iterator<E> iterator() {
        return this;
    }

    public static class BeanNodeList
    implements NodeList {
        private final BeanElement element;
        private final int size;

        public BeanNodeList(BeanElement element, int size) {
            this.element = element;
            this.size = size;
        }

        public BeanNodeList(int size) {
            this.element = defaultBeanElement;
            this.size = size;
        }

        @Override
        public int getLength() {
            return this.size;
        }

        @Override
        public Node item(int index) {
            return this.element.item(index);
        }
    }

    public static class BeanElement
    implements Element {
        private final String name;

        public BeanElement(String name) {
            this.name = name;
        }

        @Override
        public String getAttribute(String name) {
            return "";
        }

        @Override
        public String getAttributeNS(String namespaceURI, String localName) throws DOMException {
            return "";
        }

        @Override
        public Attr getAttributeNode(String name) {
            return null;
        }

        @Override
        public Attr getAttributeNodeNS(String namespaceURI, String localName) throws DOMException {
            return null;
        }

        @Override
        public NodeList getElementsByTagName(String name) {
            return emptyList;
        }

        @Override
        public NodeList getElementsByTagNameNS(String namespaceURI, String localName) throws DOMException {
            return emptyList;
        }

        @Override
        public TypeInfo getSchemaTypeInfo() {
            return null;
        }

        @Override
        public String getTagName() {
            return this.name;
        }

        @Override
        public boolean hasAttribute(String name) {
            return false;
        }

        @Override
        public boolean hasAttributeNS(String namespaceURI, String localName) throws DOMException {
            return false;
        }

        @Override
        public void removeAttribute(String name) throws DOMException {
        }

        @Override
        public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        }

        @Override
        public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
            return null;
        }

        @Override
        public void setAttribute(String name, String value) throws DOMException {
        }

        @Override
        public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        }

        @Override
        public Attr setAttributeNode(Attr newAttr) throws DOMException {
            return null;
        }

        @Override
        public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
            return null;
        }

        @Override
        public void setIdAttribute(String name, boolean isId) throws DOMException {
        }

        @Override
        public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
        }

        @Override
        public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
        }

        @Override
        public Node appendChild(Node newChild) throws DOMException {
            return null;
        }

        @Override
        public Node cloneNode(boolean deep) {
            return null;
        }

        @Override
        public short compareDocumentPosition(Node other) throws DOMException {
            return 0;
        }

        @Override
        public NamedNodeMap getAttributes() {
            return null;
        }

        @Override
        public String getBaseURI() {
            return null;
        }

        @Override
        public NodeList getChildNodes() {
            return emptyList;
        }

        @Override
        public Object getFeature(String feature, String version) {
            return null;
        }

        @Override
        public Node getFirstChild() {
            return null;
        }

        @Override
        public Node getLastChild() {
            return null;
        }

        @Override
        public String getLocalName() {
            return null;
        }

        @Override
        public String getNamespaceURI() {
            return null;
        }

        @Override
        public Node getNextSibling() {
            return null;
        }

        @Override
        public String getNodeName() {
            return this.name;
        }

        @Override
        public short getNodeType() {
            return 1;
        }

        @Override
        public String getNodeValue() throws DOMException {
            return null;
        }

        @Override
        public Document getOwnerDocument() {
            return null;
        }

        @Override
        public Node getParentNode() {
            return null;
        }

        @Override
        public String getPrefix() {
            return null;
        }

        @Override
        public Node getPreviousSibling() {
            return null;
        }

        @Override
        public String getTextContent() throws DOMException {
            return "";
        }

        @Override
        public Object getUserData(String key) {
            return null;
        }

        @Override
        public boolean hasAttributes() {
            return false;
        }

        @Override
        public boolean hasChildNodes() {
            return false;
        }

        @Override
        public Node insertBefore(Node newChild, Node refChild) throws DOMException {
            return null;
        }

        @Override
        public boolean isDefaultNamespace(String namespaceURI) {
            return false;
        }

        @Override
        public boolean isEqualNode(Node arg) {
            return false;
        }

        @Override
        public boolean isSameNode(Node other) {
            return false;
        }

        @Override
        public boolean isSupported(String feature, String version) {
            return false;
        }

        @Override
        public String lookupNamespaceURI(String prefix) {
            return null;
        }

        @Override
        public String lookupPrefix(String namespaceURI) {
            return null;
        }

        @Override
        public void normalize() {
        }

        @Override
        public Node removeChild(Node oldChild) throws DOMException {
            return null;
        }

        @Override
        public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
            return null;
        }

        @Override
        public void setNodeValue(String nodeValue) throws DOMException {
        }

        @Override
        public void setPrefix(String prefix) throws DOMException {
        }

        @Override
        public void setTextContent(String textContent) throws DOMException {
        }

        @Override
        public Object setUserData(String key, Object data, UserDataHandler handler) {
            return null;
        }

        public BeanElement item(int index) {
            return this;
        }
    }

    public static final class ResultSetIterator<E>
    extends Iter<E> {
        private final ResultSet rs;
        private final LoadFromRS<E> getFromRS;
        private boolean hasNext;
        private final Statement closeOnEndStatement;

        public ResultSetIterator(ResultSet rs, LoadFromRS<E> getFromRS) {
            this(rs, getFromRS, null);
        }

        public ResultSetIterator(ResultSet rs, LoadFromRS<E> getFromRS, Statement closeOnEndStatement) {
            this.rs = rs;
            this.getFromRS = getFromRS;
            this.closeOnEndStatement = closeOnEndStatement;
            try {
                this.hasNext = rs.next();
            }
            catch (SQLException e) {
                this.hasNext = false;
                e.printStackTrace();
            }
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public E next() {
            try {
                E result = this.getFromRS.getFromRS(this.rs);
                this.hasNext = this.rs.next();
                if (!this.hasNext) {
                    this.close();
                }
                return result;
            }
            catch (SQLException e) {
                this.hasNext = false;
                e.printStackTrace();
                return null;
            }
        }

        public void close() {
            try {
                if (this.closeOnEndStatement != null) {
                    this.closeOnEndStatement.close();
                    if (this.closeOnEndStatement != this.rs.getStatement()) {
                        this.rs.close();
                    }
                } else {
                    this.rs.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static interface LoadFromRS<E> {
        public E getFromRS(ResultSet var1) throws SQLException;
    }

    public static final class PublicIter<E>
    extends Iter<E> {
        private final Iterator<E> iter;

        public PublicIter(Iterator<E> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public E next() {
            return this.iter.next();
        }
    }
}

