/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.phone.tariff.server;

import ru.bitel.bgbilling.kernel.base.phone.tariff.server.AbstractPhoneTariffContext;
import ru.bitel.bgbilling.kernel.base.phone.tariff.server.AbstractPhoneTariffRequest;
import ru.bitel.bgbilling.kernel.tariff.tree.server.DefaultTariffTreeNode;
import ru.bitel.common.ParameterMap;

public class ZoneTrafficRangeTariffTreeNode
extends DefaultTariffTreeNode<AbstractPhoneTariffRequest<AbstractPhoneTariffRequest.AbstractPhoneServiceCost>, AbstractPhoneTariffContext> {
    private final int zone;
    private final int mode;
    private final int from;
    private final int to;

    public ZoneTrafficRangeTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        this.zone = parameterMap.getInt("zone", 0);
        this.mode = parameterMap.getInt("mode", 0);
        this.from = parameterMap.getInt("from", 0);
        this.to = parameterMap.getInt("to", 0);
    }

    @Override
    protected int executeImpl(Long treeNodeId, AbstractPhoneTariffRequest<AbstractPhoneTariffRequest.AbstractPhoneServiceCost> req, AbstractPhoneTariffContext ctx) {
        if (req.isAccepted()) {
            return 0;
        }
        int monthDays = req.getAccountingMonthDays();
        int periodDays = ((AbstractPhoneTariffRequest.AbstractPhoneServiceCost)req.serviceCost).accountingPeriodDays;
        Integer trafficValue = ctx.itemZoneTrafficCache.getZoneTraffic(req.itemId, this.zone);
        trafficValue = trafficValue != null ? Integer.valueOf(trafficValue / 60) : Integer.valueOf(0);
        int from = this.from;
        int to = this.to;
        if (this.mode == 0) {
            double part = (double)periodDays / (double)monthDays;
            from = (int)((double)from * part);
            to = (int)((double)to * part);
        }
        if (trafficValue != null && trafficValue >= from && (to == 0 || trafficValue <= to)) {
            return 1;
        }
        return 0;
    }
}

