/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.server.datalog.hourly;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.kernel.base.server.datalog.DataLog;
import ru.bitel.bgbilling.kernel.base.server.datalog.hourly.HourlyDataLogEntry;
import ru.bitel.common.ParameterMap;

public class HourlyDataLoggerTracker<E extends HourlyDataLogEntry<?>> {
    private static final Logger logger = Logger.getLogger(HourlyDataLoggerTracker.class);
    private final ScheduledExecutorService executor;
    private final ConcurrentHashMap<Long, ConcurrentHashMap<Integer, E>> hourlyMap;
    private final long checkInterval;
    private final long closeDelay = 15000L;

    public HourlyDataLoggerTracker(ParameterMap setup, ConcurrentHashMap<Long, ConcurrentHashMap<Integer, E>> hourlyMap, ScheduledExecutorService executor) {
        this.executor = executor;
        this.hourlyMap = hourlyMap;
        this.checkInterval = setup.getLong("datalog.check.interval", 480L);
        executor.scheduleWithFixedDelay(this.createDataLogChecker(), this.checkInterval, this.checkInterval, TimeUnit.SECONDS);
    }

    private Runnable createDataLogChecker() {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    logger.info((Object)("Checking data log files to close [hours=" + HourlyDataLoggerTracker.this.hourlyMap.size() + "]..."));
                    ArrayList hoursToClear = new ArrayList();
                    for (Map.Entry entryMap : HourlyDataLoggerTracker.this.hourlyMap.entrySet()) {
                        ConcurrentHashMap value = (ConcurrentHashMap)entryMap.getValue();
                        if (value.size() == 0 && System.currentTimeMillis() - (Long)entryMap.getKey() > TimeUnit.HOURS.toMillis(3L)) {
                            hoursToClear.add(entryMap.getKey());
                        }
                        Iterator j = value.values().iterator();
                        while (j.hasNext()) {
                            HourlyDataLogEntry e = (HourlyDataLogEntry)j.next();
                            if (e.wasModified()) continue;
                            j.remove();
                            logger.info((Object)("Remove dataLog file from writers map [" + ((DataLog)e.log).getFile().getAbsolutePath() + "]"));
                            HourlyDataLoggerTracker.this.executor.schedule(HourlyDataLoggerTracker.this.createDataLogCloser(e), 15000L, TimeUnit.MILLISECONDS);
                        }
                    }
                    ConcurrentHashMap emptyMap = new ConcurrentHashMap();
                    for (Long hour : hoursToClear) {
                        HourlyDataLoggerTracker.this.hourlyMap.remove(hour, emptyMap);
                    }
                }
                catch (Throwable t) {
                    logger.error((Object)t.getMessage(), t);
                }
            }
        };
    }

    ScheduledFuture<Boolean> scheduleClose(List<? extends HourlyDataLogEntry<?>> list) {
        return this.executor.schedule(this.createDataLogCloser(list), 2500L, TimeUnit.MILLISECONDS);
    }

    private Callable<Boolean> createDataLogCloser(final List<? extends HourlyDataLogEntry<?>> list) {
        return new Callable<Boolean>(){

            @Override
            public Boolean call() {
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    try {
                        HourlyDataLogEntry e = (HourlyDataLogEntry)list.get(i);
                        logger.info((Object)("Close dataLog file [" + ((DataLog)e.log).getFile().getAbsolutePath() + "]"));
                        e.close();
                        continue;
                    }
                    catch (IOException ex) {
                        logger.error((Object)ex.getMessage(), (Throwable)ex);
                    }
                }
                return Boolean.TRUE;
            }
        };
    }

    private Callable<Boolean> createDataLogCloser(final HourlyDataLogEntry<?> e) {
        return new Callable<Boolean>(){

            @Override
            public Boolean call() {
                try {
                    logger.info((Object)("Close dataLog file [" + ((DataLog)e.log).getFile().getAbsolutePath() + "]"));
                    e.close();
                }
                catch (Exception ex) {
                    logger.error((Object)ex.getMessage(), (Throwable)ex);
                }
                return Boolean.TRUE;
            }
        };
    }
}

