/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.server.servlet;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.contract.bean.PasswordManager;
import bitel.billing.server.contract.logon.ContractLogonLast;
import bitel.billing.server.contract.logon.ContractLogonLockCache;
import bitel.billing.server.contract.logon.LogonManager;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.auth.AuthModes;
import ru.bitel.bgbilling.kernel.auth.ModuleUser;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.ContractWebLoginEvent;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.ServletUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.worker.ThreadContext;

public class BGAuthFilter
implements Filter {
    private static Logger log = Logger.getLogger(BGAuthFilter.class);
    private Setup _setup;
    private String authPage = "/pubexecuter?module=admin&action=Login";
    private ContractLogonLockCache logonLockCache;
    private ServletContext servletContext;
    private Map<Integer, List<Integer>> authModes = new HashMap<Integer, List<Integer>>();
    private boolean saveAllError = false;
    private long setupInitDate = 0L;

    public void init(FilterConfig filterConfig) throws ServletException {
        this._setup = Setup.getSetup();
        this.logonLockCache = new ContractLogonLockCache();
        this.servletContext = filterConfig.getServletContext();
        this.servletContext.setAttribute("logonLockCache", (Object)this.logonLockCache);
        try {
            this.saveAllError = this._setup.getInt("web.error.all", 0) != 0;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.debug((Object)("init filter " + filterConfig.getFilterName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        this.setupInitDate = AuthModes.loadConfig(this._setup, this.setupInitDate, this.authModes);
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpSession session = request.getSession();
        Integer clid = (Integer)session.getAttribute("clientid");
        if (log.isDebugEnabled()) {
            log.debug((Object)("clid=" + clid));
        }
        if (clid != null && !this.checkContractId(request)) {
            session.invalidate();
            clid = null;
            session = request.getSession();
        }
        if (clid == null) {
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            User user = this.getLoginAndPassword(request);
            if (user != null) {
                this.checkPasswordOnce(user);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("user = [" + user.toString() + "]"));
                }
                if (user.name != null) {
                    Date lockTime = this.logonLockCache.checkLogonLock(user.name);
                    if (lockTime != null) {
                        request.setAttribute("error", (Object)"accountLock");
                        request.setAttribute("lockTime", (Object)lockTime);
                        request.setAttribute("user", (Object)user);
                        request.setAttribute("userName", (Object)user.name);
                        this.error(request, response);
                    } else {
                        ModuleUser moduleUser = AuthModes.findModuleUserUserByLogin(user.name, request.getParameter("midAuth"), this.authModes);
                        if (moduleUser != null) {
                            int contractId = moduleUser.getContractId();
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("moduleUser = [" + moduleUser.toString() + "]"));
                            }
                            this.logonLockCache.updateLogonLock(contractId, user.name);
                            lockTime = this.logonLockCache.checkLogonLock(user.name);
                            if (lockTime != null) {
                                request.setAttribute("error", (Object)"accountLock");
                                request.setAttribute("lockTime", (Object)lockTime);
                                request.setAttribute("userName", (Object)user.name);
                                request.setAttribute("user", (Object)user);
                                this.error(request, response);
                            } else {
                                String remoteAddr = ServletUtils.getIpFromHeader(request, this._setup);
                                String userPasswordDigest = Utils.getDigest(user.password, "utf-8");
                                String adminPasswordDigest = this._setup.get("web.admin.password", "");
                                String passwordType = null;
                                if (user.passwordOnce != null) {
                                    passwordType = "p";
                                } else if (userPasswordDigest.equals(adminPasswordDigest)) {
                                    passwordType = "a";
                                } else if (moduleUser.getPassword().equals(user.password) || moduleUser.getPassword().equals(userPasswordDigest)) {
                                    passwordType = "c";
                                }
                                if (passwordType != null) {
                                    Connection con = this._setup.getDBSlaveConnectionFromPool();
                                    try (ContractManager cm = new ContractManager(con);){
                                        Contract contract = cm.getContractById(contractId);
                                        List<Integer> denyStatuses = Utils.toIntegerList(this._setup.get("web.auth.deny.statuses", null));
                                        boolean periodCloseFlag = this._setup.getBoolean("web.auth.deny.periodClose", false);
                                        boolean err = denyStatuses.contains(contract.getStatus());
                                        if (err || periodCloseFlag && TimeUtils.dateBefore(contract.getDateTo(), new Date())) {
                                            request.setAttribute("error", (Object)(err ? "denyStatus" : "denyClosedPeriod"));
                                            request.setAttribute("userName", (Object)user.name);
                                            request.setAttribute("user", (Object)user);
                                            this.error(request, response);
                                            return;
                                        }
                                        this.updateContractLogonLast(contractId, -1, remoteAddr);
                                        this.saveContractLogonOk(contractId, remoteAddr, request.getSession().getId(), passwordType);
                                        session.setAttribute("clientid", (Object)new Integer(contractId));
                                        session.setAttribute("userName", (Object)moduleUser.getContractTitle());
                                        session.setAttribute("contract_current", (Object)contract);
                                        if (contract.isIndepend()) {
                                            session.setAttribute("contract_general", (Object)contract);
                                        } else if (contract.isSuper()) {
                                            session.setAttribute("contract_general", (Object)contract);
                                            session.setAttribute("contract_sublist", cm.getSubContracts(contract.getId()));
                                        } else {
                                            session.setAttribute("contract_general", (Object)cm.getContractById(contract.getSuperId()));
                                            session.setAttribute("contract_sublist", cm.getSubContracts(contract.getSuperId()));
                                        }
                                    }
                                    finally {
                                        ServerUtils.closeConnection(con);
                                    }
                                    if (session.getAttribute("reference") != null) {
                                        response.sendRedirect(String.valueOf(session.getAttribute("reference")));
                                        session.removeAttribute("reference");
                                    } else {
                                        ServerContext context = new ServerContext(this._setup, ConnectionSet.newInstance(this._setup, false), 0, 0);
                                        Object parentContext = ThreadContext.get();
                                        ThreadContext.set(context);
                                        try {
                                            ContractWebLoginEvent contractWebLoginEvent = new ContractWebLoginEvent(request, contractId);
                                            contractWebLoginEvent = EventProcessor.getInstance().request(contractWebLoginEvent);
                                            if (!contractWebLoginEvent.isAccessIsAllow()) {
                                                request.setAttribute("error", (Object)Utils.maskBlank(contractWebLoginEvent.getErrorText(), "\u0414\u043e\u0441\u0442\u0443\u043f \u0437\u0430\u043f\u0440\u0435\u0449\u0451\u043d!"));
                                                this.error(request, response);
                                            }
                                            context.commit();
                                        }
                                        catch (BGException e) {
                                            log.error((Object)e.getMessage(), (Throwable)e);
                                        }
                                        finally {
                                            context.destroy();
                                            ThreadContext.set(parentContext);
                                        }
                                        filterChain.doFilter(servletRequest, servletResponse);
                                    }
                                } else {
                                    this.updateContractLogonLast(contractId, 1, remoteAddr);
                                    this.saveContractLogonError(contractId, remoteAddr, request);
                                    this.logonLockCache.updateLogonLock(contractId, user.name);
                                    lockTime = this.logonLockCache.checkLogonLock(user.name);
                                    request.setAttribute("error", (Object)"passwordInvalid");
                                    request.setAttribute("lockTime", (Object)lockTime);
                                    request.setAttribute("user", (Object)user);
                                    request.setAttribute("userName", (Object)user.name);
                                    this.error(request, response);
                                }
                            }
                        } else {
                            if (this.saveAllError) {
                                this.saveContractLogonError(-1, ServletUtils.getIpFromHeader(request, this._setup), request);
                            }
                            request.setAttribute("error", (Object)"loginNotFound");
                            request.setAttribute("user", (Object)user);
                            request.setAttribute("userName", (Object)user.name);
                            this.error(request, response);
                        }
                    }
                }
            } else {
                this.error(request, response);
            }
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    private boolean checkContractId(HttpServletRequest request) {
        Contract contract;
        HttpSession session = request.getSession();
        int contractId = Utils.parseInt(request.getParameter("contractId"), -1);
        if (contractId > 0 && (contract = (Contract)session.getAttribute("contract_current")).getId() != contractId) {
            contract = (Contract)session.getAttribute("contract_general");
            if (contract.getId() == contractId) {
                session.setAttribute("contract_current", (Object)contract);
                session.setAttribute("clientid", (Object)contract.getId());
            } else {
                List subContractList = (List)session.getAttribute("contract_sublist");
                if (subContractList != null) {
                    for (Contract testContract : subContractList) {
                        if (testContract.getId() != contractId) continue;
                        session.setAttribute("contract_current", (Object)testContract);
                        session.setAttribute("clientid", (Object)testContract.getId());
                        return true;
                    }
                }
                return false;
            }
        }
        return true;
    }

    public void destroy() {
    }

    private User getLoginAndPassword(HttpServletRequest request) {
        User user = null;
        String userName = request.getParameter("user");
        String userIp = request.getParameter("userIp");
        String userPassword = request.getParameter("pswd");
        String userPasswordOnce = request.getParameter("passwordOnce");
        if (userName != null && userPassword != null) {
            user = new User();
            user.name = userName;
            user.password = userPassword;
        } else if (userIp != null) {
            user = new User();
            user.name = ServletUtils.getIpFromHeader(request, this._setup);
            user.password = AuthModes.passwordless();
        } else if (userPasswordOnce != null) {
            user = new User();
            user.passwordOnce = userPasswordOnce;
        }
        return user;
    }

    private void error(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String page = this.authPage;
        request.getSession().invalidate();
        Setup setup = Setup.getSetup();
        String ct = request.getParameter("ct");
        if (ct == null) {
            ct = request.getParameter("contentType");
        }
        if (ct == null) {
            ct = setup.get("web.mode", System.getProperty("web.mode", "html"));
        }
        if ("json".equals(ct)) {
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.put("status", "error");
            dataMap.put("errorCode", request.getAttribute("error"));
            dataMap.put("lockTime", request.getAttribute("lockTime"));
            dataMap.put("user", request.getAttribute("user"));
            dataMap.put("userName", request.getAttribute("userName"));
            JSONObject jsonObject = new JSONObject(dataMap);
            String type = request.getHeader("Content-Type");
            String contentType = "application/json";
            if (type != null && type.startsWith("multipart/form-data")) {
                contentType = "text/plain";
            }
            response.setContentType(contentType + "; charset=UTF-8");
            PrintWriter out = response.getWriter();
            out.print(jsonObject.toString());
            out.flush();
            out.close();
        } else {
            if (request.getParameter("user") != null) {
                page = "/pubexecuter?module=admin&action=authError";
                if (ct != null) {
                    page = page + "&ct=" + ct + "&contentType=" + ct;
                }
            } else {
                if (request.getQueryString() != null) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(request.getRequestURL().toString());
                    sb.append("?");
                    sb.append(request.getQueryString());
                    request.getSession().setAttribute("reference", (Object)sb.toString());
                }
                request.setAttribute("error", (Object)"parameterLoginAndPasswordNotFound");
            }
            RequestDispatcher dispatcher = request.getRequestDispatcher(page);
            try {
                dispatcher.forward((ServletRequest)request, (ServletResponse)response);
            }
            catch (ServletException ex) {
                ex.printStackTrace();
                response.sendRedirect(page);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveContractLogonOk(int contractId, String remoteAddr, String sessionId, String user) {
        Connection con = this._setup.getDBConnectionFromPool();
        try {
            LogonManager logonManager = new LogonManager(con);
            logonManager.saveLogonOk(contractId, remoteAddr, sessionId, user);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            ServerUtils.closeConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveContractLogonError(int contractId, String remoteAddr, HttpServletRequest request) {
        Connection con = this._setup.getDBConnectionFromPool();
        try {
            LogonManager logonManager = new LogonManager(con);
            logonManager.saveLogonError(contractId, remoteAddr, request);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            ServerUtils.closeConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateContractLogonLast(int contractId, int n, String remoteAddr) {
        if (contractId > 0) {
            Connection con = this._setup.getDBConnectionFromPool();
            try {
                LogonManager logonManager = new LogonManager(con);
                ContractLogonLast contractLogonLast = logonManager.getContractLogonLast(contractId);
                if (contractLogonLast != null && contractLogonLast.getDateTime().getTime() < System.currentTimeMillis() - 86400000L) {
                    int logonLogRecord = this._setup.getInt("logon.log.record", 100);
                    int logonLogPeriod = this._setup.getInt("logon.log.period", 100);
                    logonManager.clearLogonOkLog(contractId, logonLogRecord, logonLogPeriod);
                    logonManager.clearLogonErrorLog(contractId, logonLogRecord, logonLogPeriod);
                }
                logonManager.updateContractLogonLast(contractId, n, remoteAddr);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                ServerUtils.closeConnection(con);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPasswordOnce(User user) {
        if (user != null && user.name == null && user.passwordOnce != null) {
            Connection con = this._setup.getDBConnectionFromPool();
            try {
                PasswordManager passwordManager = new PasswordManager(con);
                user.name = passwordManager.findContractTitle(user.passwordOnce);
                passwordManager.deleteContractTitle(user.passwordOnce);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                ServerUtils.closeConnection(con);
            }
        }
    }

    class User {
        public String name = null;
        public String password = null;
        public String passwordOnce = null;

        User() {
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("name=");
            builder.append(this.name);
            builder.append("; password=");
            builder.append(this.password);
            builder.append("; passwordOnce=");
            builder.append(this.passwordOnce);
            return builder.toString();
        }
    }
}

