/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.server.servlet;

import bitel.billing.server.Action;
import bitel.billing.server.ActionResultContentType;
import bitel.billing.server.WebRequestCounter;
import bitel.billing.server.bean.MenuItem;
import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.contract.bean.ContractModuleManager;
import bitel.billing.server.contract.bean.ContractUtils;
import bitel.billing.server.util.captcha.Captcha;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.admin.news.common.bean.News;
import ru.bitel.bgbilling.kernel.admin.news.server.bean.NewsManager;
import ru.bitel.bgbilling.kernel.admin.webmenu.common.bean.WebMenuItem;
import ru.bitel.bgbilling.kernel.admin.webmenu.server.bean.WebMenuDao;
import ru.bitel.bgbilling.kernel.base.server.servlet.CommonExecutor;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.ActionLogEntry;
import ru.bitel.bgbilling.kernel.bgsecure.server.bean.BGActionLogManager;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.kernel.container.web.action.ActionHandler;
import ru.bitel.bgbilling.kernel.contract.api.server.Module;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractNotificationDao;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.bean.ModuleManager;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.server.WebMenuBase;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.ServletUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.xml.strategy.WebMarshallerStrategy;

@WebServlet(name="webexecuter", urlPatterns={"/webexecuter/*"})
public class WebExecuter
extends CommonExecutor {
    private final Logger logger = Logger.getLogger(WebExecuter.class);
    private WebRequestCounter requestCounter;
    private ActionHandler actionHandler;
    private HashMap<Object, Class<? extends WebMenuBase>> menuMap = new HashMap(64);
    private final String WEB_MENU_CACHE_KEY = "webMenu";

    @Override
    public void init() {
        this.setup = Setup.getSetup();
        this.requestCounter = new WebRequestCounter(this.setup);
        this.actionHandler = new ActionHandler(new WebMarshallerStrategy());
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.redirectByPath(request, response)) {
            return;
        }
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Connection conSlave = this.setup.getDBSlaveConnectionFromPool();
        HttpSession session = request.getSession();
        request.setAttribute("setup", (Object)this.setup);
        request.setAttribute("response", (Object)response);
        request.setAttribute("contextPath", (Object)this.setup.get("context.path", "/bgbilling"));
        WebExecuter.rememberBackUrl(request);
        try {
            Document doc = null;
            Element rootNode = null;
            String module = WebExecuter.getParameter(request, "module", "contract");
            String mid = WebExecuter.getParameter(request, "mid", "contract");
            String action = WebExecuter.getParameter(request, "action", "menu");
            this.logRequest(request);
            doc = XMLUtils.newDocument();
            rootNode = doc.createElement("data");
            rootNode.setAttribute("contextPath", this.setup.get("context.path", "/bgbilling"));
            doc.appendChild(rootNode);
            Object webMode = WebExecuter.getRequestParameters(this.setup.get("web.mode", System.getProperty("web.mode", "html")), request, "contentType", "ct");
            Integer clid = (Integer)session.getAttribute("clientid");
            if (clid != null) {
                String xsltFile = null;
                boolean canAccess = true;
                if (!this.requestCounter.checkRequestCount(clid)) {
                    canAccess = false;
                    if (request.getParameter("getcaptcha") != null) {
                        webMode = ActionResultContentType.binary;
                        Captcha.captcha(request, response, session, false);
                    } else {
                        String captcha = WebExecuter.getParameter(request, "captcha", null);
                        if (!Captcha.validate(captcha, request, session)) {
                            if (!Utils.isEmptyString(captcha)) {
                                Element error = XMLUtils.createElement(rootNode, "error");
                                error.setAttribute("id", "badCode");
                            }
                            rootNode.setAttribute("rand", String.valueOf(System.currentTimeMillis() % 1000L));
                            canAccess = false;
                            xsltFile = "limit_error.xsl";
                        } else {
                            request.setAttribute("ResetLimit", (Object)Boolean.TRUE);
                            canAccess = true;
                        }
                    }
                }
                if (canAccess) {
                    Integer moduleId;
                    String year = String.valueOf(new GregorianCalendar().get(1));
                    rootNode.setAttribute("action", action);
                    rootNode.setAttribute("module", module);
                    rootNode.setAttribute("mid", mid);
                    rootNode.setAttribute("year", year);
                    request.setAttribute("action", (Object)action);
                    request.setAttribute("module", (Object)module);
                    request.setAttribute("mid", (Object)mid);
                    request.setAttribute("year", (Object)year);
                    Contract contract = (Contract)session.getAttribute("contract_current");
                    Object list = session.getAttribute(contract.getId() + "_allowed_modules");
                    if (list instanceof List && (moduleId = Integer.valueOf(Utils.parseInt(mid))) != 0 && !((List)list).contains(moduleId)) {
                        WebExecuter.setErrorStatus(request, rootNode, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u044d\u0442\u043e\u0442 \u043c\u043e\u0434\u0443\u043b\u044c!");
                        throw new Error("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u044d\u0442\u043e\u0442 \u043c\u043e\u0434\u0443\u043b\u044c!");
                    }
                    this.executeAction(webMode, action, module, mid, request, response, rootNode);
                    Object requestWebMode = request.getAttribute("contentType");
                    if (requestWebMode != null) {
                        webMode = requestWebMode;
                    }
                    this.buildMenu(conSlave, contract, webMode, request, rootNode);
                    if (!ActionResultContentType.binary.isEquals(webMode)) {
                        if (contract != null) {
                            Contract loggedAsContract = (Contract)session.getAttribute("logged_as_cid");
                            if (loggedAsContract == null) {
                                loggedAsContract = contract;
                                session.setAttribute("logged_as_cid", (Object)contract);
                            }
                            Contract superContract = (Contract)session.getAttribute("contract_general");
                            List subContractList = (List)session.getAttribute("contract_sublist");
                            if ("menu".equals(action)) {
                                webMode = ActionResultContentType.jsp;
                                HashMap<String, List<News>> dataMap = new HashMap<String, List<News>>();
                                dataMap.put("newsList", NewsManager.getNewsList(this.setup, contract.getGroups()));
                                request.setAttribute("dataMap", dataMap);
                            }
                            if (ActionResultContentType.jsp.isEquals(webMode)) {
                                request.setAttribute("contract", (Object)contract);
                                request.setAttribute("superContract", (Object)superContract);
                                request.setAttribute("subContractList", (Object)subContractList);
                                request.setAttribute("currencyTitleMedium", (Object)this.setup.get("client.gui.currency.title.medium", "\u0440\u0443\u0431."));
                            } else {
                                boolean showSubcontractOnly;
                                WebExecuter.addContractDataToXML(rootNode, contract);
                                boolean bl = showSubcontractOnly = this.setup.getInt("web.sub.contract.auth.mode", 1) == 2;
                                if (loggedAsContract.isSub() && showSubcontractOnly) {
                                    Element subContractEl = XMLUtils.createElement(rootNode, "sub_contract");
                                    WebExecuter.addContractDataToXML(subContractEl, loggedAsContract);
                                } else {
                                    if (subContractList != null) {
                                        Element subContracts = XMLUtils.createElement(rootNode, "sub_contracts");
                                        for (Contract subContract : subContractList) {
                                            Element item = XMLUtils.createElement(subContracts, "item");
                                            WebExecuter.addContractDataToXML(item, subContract);
                                        }
                                    }
                                    if (superContract != null) {
                                        Element superContractEl = XMLUtils.createElement(rootNode, "super_contract");
                                        WebExecuter.addContractDataToXML(superContractEl, superContract);
                                    }
                                }
                                this.checkNotifications(conSlave, rootNode, clid);
                            }
                        }
                        if (this.setup.getInt("web.add.contract", -1) > 0) {
                            SoftReference contractDataRef = (SoftReference)session.getAttribute("contract_data");
                            Element contractData = contractDataRef != null ? (Element)contractDataRef.get() : null;
                            Integer contractDataCid = (Integer)session.getAttribute("contract_data_cid");
                            if (contractData != null && contractDataCid != null && !contractDataCid.equals(clid)) {
                                contractData = null;
                            }
                            if (contractData == null) {
                                Document contractDoc = XMLUtils.newDocument();
                                contractData = contractDoc.createElement("contract_data");
                                contractDoc.appendChild(contractData);
                                XMLOutputFactory factory = XMLOutputFactory.newInstance();
                                new ContractUtils(conSlave).addContractXML(clid, factory.createXMLStreamWriter(new DOMResult(contractData)), true);
                                session.setAttribute("contract_data", new SoftReference<Element>(contractData));
                                session.setAttribute("contract_data_cid", (Object)clid);
                            }
                            rootNode.appendChild(doc.importNode(contractData, true));
                        }
                        xsltFile = module.equals("contract") ? "main.xsl" : module + ".xsl";
                    }
                }
                ServerUtils.addNoCache(response);
                if (ActionResultContentType.xml.isEquals(webMode)) {
                    this.sendXmlWithXSLTInstuction(request, response, doc, xsltFile);
                } else if (ActionResultContentType.html.isEquals(webMode)) {
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace((Object)("RequestURI = " + request.getRequestURI()));
                        this.logger.trace((Object)("QueryString = " + request.getQueryString()));
                    }
                    this.xslManager.transform(response, xsltFile, new DOMSource(doc), null, "text/html", null, false);
                } else if (ActionResultContentType.jsp.isEquals(webMode)) {
                    request.getRequestDispatcher("/WEB-INF/jspf/webcontent.jsp").forward((ServletRequest)request, (ServletResponse)response);
                } else if (ActionResultContentType.json.isEquals(webMode)) {
                    JSONObject jsonObject = new JSONObject((Map)request.getAttribute("dataMap"));
                    String type = request.getHeader("Content-Type");
                    boolean isMultipart = type != null && type.startsWith("multipart/form-data");
                    response.setContentType((isMultipart ? "text/plain" : "application/json") + "; charset=UTF-8");
                    PrintWriter out = response.getWriter();
                    out.print(jsonObject.toString());
                    out.flush();
                    out.close();
                }
                if (session.getAttribute("invalidate") != null) {
                    session.invalidate();
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)(e.getMessage() + "; requestURI=" + request.getRequestURI() + "; requestQueryString=" + request.getQueryString()), (Throwable)e);
            response.setContentType("text/plain; charset=UTF-8");
            PrintWriter out = response.getWriter();
            e.printStackTrace(out);
            out.flush();
            out.close();
        }
        catch (Error e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            PrintWriter out = response.getWriter();
            out.flush();
            out.close();
        }
        finally {
            ServerUtils.closeConnection(conSlave);
        }
    }

    private void checkNotifications(Connection conSlave, Element rootNode, int contractId) throws BGException {
        ContractNotificationDao contractNotificationDao = new ContractNotificationDao(conSlave);
        int newNotificationsCount = contractNotificationDao.getUnreadNotificationsCount(contractId);
        rootNode.setAttribute("notificationsCount", String.valueOf(newNotificationsCount));
        contractNotificationDao.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeAction(Object webMode, String action, String module, String mid, HttpServletRequest request, HttpServletResponse response, Element rootNode) {
        Action webAction = null;
        if (!action.equalsIgnoreCase("menu")) {
            ActionLogEntry ql;
            BGActionLogManager qlm;
            block20: {
                qlm = new BGActionLogManager();
                ql = null;
                try {
                    if (qlm.isConnectionActive()) {
                        ql = new ActionLogEntry();
                        ql.setAction("Web:" + action);
                        ql.setDatetime(new Date());
                        ql.setModuleId(Utils.parseInt(mid));
                        ql.setModuleTitle(module);
                        ql.setQuery(WebExecuter.getQueryString(request, true));
                        ql.setUserId(-1);
                        qlm.update(ql);
                    }
                }
                catch (BGException ex) {
                    this.logger.error((Object)ex.getMessage(), (Throwable)ex);
                }
                try {
                    Class<?> actionClass;
                    String className = "Action" + action;
                    if (mid.equals("contract")) {
                        module = "contract";
                    }
                    if ((actionClass = this.findAction(module, "web.", className)) == null) {
                        this.logger.error((Object)("action \"" + module + "." + className + "\" not found!"));
                        WebExecuter.setErrorStatus(request, rootNode, "action \"" + module + "." + className + "\" not found!");
                        break block20;
                    }
                    if (Action.class.isAssignableFrom(actionClass)) {
                        webAction = actionClass.asSubclass(Action.class).newInstance();
                        try {
                            webAction.init(this.setup, rootNode, request, response, this.servletContext);
                            webAction.setOutputMode(WebExecuter.getOutputMode(webMode));
                            webAction.doAction();
                            webAction.commit();
                            break block20;
                        }
                        finally {
                            webAction.freeConnection();
                        }
                    }
                    if (AbstractAction.class.isAssignableFrom(actionClass)) {
                        int contractId = -1;
                        Integer clientid = (Integer)request.getSession().getAttribute("clientid");
                        if (clientid != null) {
                            contractId = clientid;
                        }
                        this.actionHandler.handle(actionClass.asSubclass(AbstractAction.class), this.setup, webMode, ActionResultContentType.jsp.isEquals(webMode) ? null : rootNode, request, response, this.servletContext, contractId, -1);
                    }
                }
                catch (BGMessageException ex) {
                    WebExecuter.setErrorStatus(request, rootNode, ex.getMessage());
                }
                catch (Exception ex) {
                    this.logger.error((Object)ex.getMessage(), (Throwable)ex);
                    WebExecuter.setErrorStatus(request, rootNode, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043d\u0435\u043f\u0440\u0435\u0434\u0432\u0438\u0434\u0435\u043d\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430");
                }
            }
            try {
                if (qlm.isConnectionActive() && ql != null) {
                    qlm.delete(ql.getId());
                }
            }
            catch (BGException ex) {
                this.logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
            try {
                qlm.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static int getOutputMode(Object webMode) {
        int outputMode = 0;
        if (ActionResultContentType.jsp.isEquals(webMode)) {
            outputMode = 1;
        } else if (ActionResultContentType.json.isEquals(webMode)) {
            outputMode = 2;
        }
        return outputMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logRequest(HttpServletRequest request) {
        String queryString;
        boolean log = this.setup.getBoolean("webquery.log", false);
        if (log && (queryString = WebExecuter.getQueryString(request, true)) != null && queryString.length() > 0) {
            String remoteAddr = ServletUtils.getIpFromHeader(request, this.setup);
            String module = request.getParameter("module");
            BGPluginServer plugin = BGPluginManagerServer.getManager().getPlugin(module);
            String mid = null;
            mid = plugin != null ? "p" + plugin.getId() : request.getParameter("mid");
            Integer clientId = (Integer)request.getSession().getAttribute("clientid");
            int cid = clientId == null ? -1 : clientId;
            Connection con = this.setup.getDBConnectionFromPool();
            try {
                GregorianCalendar calendar = new GregorianCalendar();
                String table = "web_query_log_" + TimeUtils.format((Calendar)calendar, "MMyyyy");
                if (ServerUtils.tableExists(con, table)) {
                    String query = "INSERT INTO " + table + " SET dtime=NOW(), cid=?, ip=?, mid=?, query=?";
                    PreparedStatement psInsert = con.prepareStatement(query);
                    psInsert.setInt(1, cid);
                    psInsert.setString(2, remoteAddr);
                    psInsert.setInt(3, Utils.parseInt(mid));
                    psInsert.setString(4, queryString);
                    psInsert.executeUpdate();
                    psInsert.close();
                } else {
                    table = ServerUtils.getMonthTableName("web_query_log", calendar.getTime());
                    if (!ServerUtils.tableExists(con, table)) {
                        String query = "CREATE TABLE " + table + "( id INT AUTO_INCREMENT NOT NULL, dtime DATETIME NOT NULL default '0000-00-00 00:00:00',cid INT NOT NULL,ip VARCHAR(20) NOT NULL,mid INT NOT NULL, query TEXT NOT NULL,c_title VARCHAR(150) NOT NULL,m_title VARCHAR(150) NOT NULL,PRIMARY KEY id(id), KEY cid(cid), KEY dtime(dtime) )";
                        Statement st = con.createStatement();
                        st.execute(query);
                        st.close();
                    }
                    ContractManager contractManager = new ContractManager(con);
                    Contract contract = contractManager.getContractById(cid);
                    contractManager.close();
                    BGModule mod = null;
                    if (plugin == null) {
                        mod = new ModuleManager(con).getModule(Utils.parseInt(mid));
                    }
                    String query = "INSERT INTO " + table + " (dtime, cid, ip, mid, query, c_title, m_title ) VALUES(NOW(), ?, ?, ?, ?, ?, ?)";
                    PreparedStatement psInsert = con.prepareStatement(query);
                    psInsert.setInt(1, cid);
                    psInsert.setString(2, remoteAddr);
                    psInsert.setInt(3, Utils.parseInt(mid));
                    psInsert.setString(4, queryString);
                    psInsert.setString(5, contract != null ? contract.getTitle() : "");
                    psInsert.setString(6, plugin != null ? plugin.getName() : (mod != null ? mod.getTitle() : ""));
                    psInsert.executeUpdate();
                    psInsert.close();
                }
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                ServerUtils.closeConnection(con);
            }
        }
    }

    private void buildMenu(Connection con, Contract contract, Object webMode, HttpServletRequest request, Element rootNode) {
        block18: {
            try {
                String cacheKey = "webMenu_" + contract.getId();
                Document doc = rootNode.getOwnerDocument();
                HttpSession session = request.getSession();
                Object[] data = (Object[])session.getAttribute(cacheKey);
                if (data != null) {
                    rootNode.appendChild(doc.importNode((Element)data[0], true));
                    request.setAttribute("menuItemList", data[1]);
                    request.setAttribute(contract.getId() + "_allowed_modules", data[2]);
                    break block18;
                }
                ArrayList<MenuItem> menuItemList = new ArrayList<MenuItem>();
                WebMenuDao webMenuDao = new WebMenuDao(con);
                int webMenuId = webMenuDao.getWebMenuIdForContract(contract.getId());
                webMenuDao.close();
                if (webMenuId == -1) {
                    List<WebMenuItem> list = webMenuDao.list();
                    for (WebMenuItem webMenuItem : list) {
                        if (!webMenuItem.isDefault()) continue;
                        webMenuId = webMenuItem.getId();
                    }
                }
                ArrayList<Integer> moduleList = new ArrayList<Integer>();
                ContractModuleManager contractModuleManager = new ContractModuleManager(con);
                List<BGModule> bgModules = contractModuleManager.getContractModules(contract.getId());
                for (BGModule bGModule : bgModules) {
                    moduleList.add(bGModule.getId());
                }
                if (webMenuId > 0) {
                    Iterator<Map.Entry<String, BGPluginServer>> webMenuItemDoc = XMLUtils.parseDocument(new InputSource(new StringReader(webMenuDao.getData(webMenuId))));
                    for (Element itemElement : XMLUtils.selectElements((Node)((Object)webMenuItemDoc), "//item")) {
                        MenuItem menuItem = new MenuItem();
                        menuItem.setAction(itemElement.getAttribute("action"));
                        menuItem.setTitle(itemElement.getAttribute("title"));
                        menuItem.setModule(itemElement.getAttribute("moduleName"));
                        menuItem.setModuleId(Utils.parseInt(itemElement.getAttribute("moduleId")));
                        if (menuItem.getModuleId() != 0 && !moduleList.contains(menuItem.getModuleId())) continue;
                        menuItemList.add(menuItem);
                    }
                } else {
                    WebMenuBase menuBase;
                    Class<?> result;
                    Class<? extends WebMenuBase> menuBaseClass;
                    menuItemList.addAll(new Module().getContractWebMenuItems(con, "contract", 0, contract.getId()));
                    for (BGModule bGModule : bgModules) {
                        int moduleId = bGModule.getId();
                        menuBaseClass = this.menuMap.get(moduleId);
                        if (menuBaseClass == null) {
                            try {
                                String packServer2 = bGModule.getInstalledModule().getPackageServer();
                                result = Class.forName(packServer2 + ".Module");
                                menuBaseClass = result.asSubclass(WebMenuBase.class);
                                this.menuMap.put(moduleId, menuBaseClass);
                            }
                            catch (Exception packServer2) {
                                // empty catch block
                            }
                        }
                        if (menuBaseClass == null) continue;
                        menuBase = menuBaseClass.newInstance();
                        menuItemList.addAll(menuBase.getContractWebMenuItems(con, bGModule.getName(), moduleId, contract.getId()));
                    }
                    for (Map.Entry<String, BGPluginServer> entry : BGPluginManagerServer.getManager().getPluginsMap().entrySet()) {
                        String pluginid = entry.getKey();
                        menuBaseClass = this.menuMap.get(pluginid);
                        if (menuBaseClass == null) {
                            try {
                                String packServer3 = entry.getValue().getPackServer();
                                result = Class.forName(packServer3 + ".PluginServerListener");
                                menuBaseClass = result.asSubclass(WebMenuBase.class);
                                this.menuMap.put(pluginid, menuBaseClass);
                            }
                            catch (Exception packServer3) {
                                // empty catch block
                            }
                        }
                        if (menuBaseClass == null) continue;
                        menuBase = menuBaseClass.newInstance();
                        menuItemList.addAll(menuBase.getContractWebMenuItems(con, pluginid, 0, contract.getId()));
                    }
                }
                Element menu = doc.createElement("menu");
                for (MenuItem menuItem : menuItemList) {
                    Element item = doc.createElement("item");
                    item.setAttribute("mid", String.valueOf(menuItem.getModuleId()));
                    item.setAttribute("action", menuItem.getAction());
                    item.setAttribute("title", menuItem.getTitle());
                    item.setAttribute("module", menuItem.getModule());
                    menu.appendChild(item);
                }
                rootNode.appendChild(menu);
                request.setAttribute("menuItemList", menuItemList);
                request.setAttribute(contract.getId() + "_allowed_modules", moduleList);
                session.setAttribute(cacheKey, (Object)new Object[]{menu, menuItemList, moduleList});
            }
            catch (Exception ex) {
                this.logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private static String getParameter(HttpServletRequest request, String name, String defaultValue) {
        String value = request.getParameter(name);
        return value != null ? value : defaultValue;
    }

    private static void addContractDataToXML(Element el, Contract contract) {
        el.setAttribute("id", String.valueOf(contract.getId()));
        el.setAttribute("contract", contract.getTitle());
        el.setAttribute("title", contract.getTitle());
        el.setAttribute("comment", contract.getComment());
        el.setAttribute("balance_mode", String.valueOf(contract.getBalanceMode()));
        el.setAttribute("fc", String.valueOf(contract.getFc()));
    }
}

