/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.container.security.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.kernel.container.security.server.ModuleAction;

class HttpAction
extends ModuleAction {
    private List<ParamPair> paramPairs = new ArrayList<ParamPair>(4);

    public HttpAction(Element description) {
        super(description);
        StringTokenizer st = new StringTokenizer(description.getAttribute("mask"), ";");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            String[] param_value = token.split("=", 2);
            ParamPair pair = new ParamPair(param_value[0], param_value[1]);
            this.paramPairs.add(pair);
        }
    }

    public boolean isCoincide(HttpServletRequest request) {
        boolean result = this.paramPairs.size() > 0;
        for (ParamPair pair : this.paramPairs) {
            String value = request.getParameter(pair.name);
            if (value != null && pair.name.equals("action")) {
                value = value.substring(0, 1).toUpperCase() + value.substring(1);
            }
            if (result = value != null && (value.equals(pair.value) || pair.pattern != null && pair.pattern.matcher(value).matches())) continue;
            break;
        }
        return result;
    }

    public boolean isCoincide(Map<String, String> requestMap) {
        boolean result = this.paramPairs.size() > 0;
        for (ParamPair pair : this.paramPairs) {
            String value = requestMap.get(pair.name);
            if (value != null && pair.name.equals("action")) {
                value = value.substring(0, 1).toUpperCase() + value.substring(1);
            }
            if (result = value != null && (value.equals(pair.value) || pair.pattern != null && pair.pattern.matcher(value).matches())) continue;
            break;
        }
        return result;
    }

    private final class ParamPair {
        final String name;
        final String value;
        final Pattern pattern;

        public ParamPair(String name, String value) {
            this.name = name;
            this.value = value;
            this.pattern = value.startsWith("R:") ? Pattern.compile(value.substring(2)) : null;
        }
    }
}

