/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.container.web.action;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.managed.AbstractManagedBeanInfoManager;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.kernel.container.web.action.ActionContext;
import ru.bitel.bgbilling.kernel.container.web.action.ActionInfo;
import ru.bitel.bgbilling.kernel.container.web.action.ActionRequest;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.worker.ThreadContext;
import ru.bitel.common.xml.strategy.MarshallerStrategy;

public class ActionHandler
extends AbstractManagedBeanInfoManager<ActionInfo, AbstractAction> {
    private static final Logger logger = Logger.getLogger(ActionHandler.class);
    private final Context env;
    final MarshallerStrategy strategy;

    @Override
    protected ActionInfo newManagedBeanInfo(Class<? extends AbstractAction> clazz) {
        return new ActionInfo(this.strategy, clazz);
    }

    public ActionHandler(MarshallerStrategy strategy) {
        Context ctx;
        try {
            ctx = Setup.getEnvironment();
        }
        catch (NamingException e) {
            ctx = null;
        }
        this.env = ctx;
        this.strategy = strategy;
    }

    public void handle(Class<? extends AbstractAction> clazz, Setup setup, Object webMode, Element rootNode, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, int contractId, int userId) throws Exception {
        String operation = request.getParameter("operation");
        if (Utils.isBlankString(operation)) {
            operation = "execute";
        }
        request.setAttribute("operation", (Object)operation);
        try {
            this.handleImpl(clazz, operation, setup, webMode, rootNode, request, response, servletContext, contractId, userId);
        }
        catch (InstantiationException e) {
            logger.error((Object)("Exception in " + clazz.getName() + ":" + operation));
            throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f", e);
        }
        catch (NoSuchMethodException e) {
            logger.error((Object)("Exception in " + clazz.getName() + ":" + operation));
            throw new BGException("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f " + operation + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430", e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof BGMessageException) {
                throw (BGMessageException)e.getCause();
            }
            logger.error((Object)("Exception in " + clazz.getName() + ":" + operation));
            throw new BGException("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430", e.getCause());
        }
        catch (NamingException e) {
            logger.error((Object)("Exception in " + clazz.getName() + ":" + operation));
            throw new BGException("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430", e);
        }
        catch (JAXBException e) {
            logger.error((Object)("Exception in " + clazz.getName() + ":" + operation));
            throw new BGException("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleImpl(Class<? extends AbstractAction> clazz, String operation, Setup setup, Object webMode, Element rootNode, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, int contractId, int userId) throws Exception {
        ActionRequest req = new ActionRequest(request);
        int moduleId = req.getInt("mid", -1);
        Object parentContext = ThreadContext.get();
        AbstractAction action = clazz.newInstance();
        ServerContext context = null;
        try {
            request.setAttribute("dataMap", action.dataMap);
            ActionInfo instance = (ActionInfo)this.getManagedBeanInfo(clazz);
            Method method = instance.getMethod(operation);
            context = new ActionContext(this.env, setup, ConnectionSet.newInstance(setup, false), moduleId, userId, request, response, servletContext, webMode, rootNode, instance);
            context.init();
            action.context = context;
            action.req = req;
            action.con = context.getConnection();
            action.userId = userId;
            action.mid = action.moduleId = moduleId;
            action.cid = action.contractId = contractId;
            action.setup = setup;
            action.moduleSetup = context.getModuleSetup();
            ThreadContext.set(context);
            instance.postConstruct(context, moduleId, action);
            try {
                instance.invoke(rootNode, action, method);
                context.commit();
            }
            finally {
                instance.preDestroy(action);
            }
        }
        finally {
            if (context != null) {
                context.destroy();
            }
            ThreadContext.set(parentContext);
        }
    }
}

