/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.object.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ContractObjectType;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractIdDao;

public class ContractObjectTypeDao
extends AbstractIdDao<ContractObjectType>
implements Directory<ContractObjectType> {
    private PreparedStatement getModuleIdsPS = null;

    public ContractObjectTypeDao(Connection con) {
        super(con, 0, "object_type");
    }

    @Override
    protected ContractObjectType getFromRS(ResultSet rs) throws SQLException, BGException {
        ContractObjectType result = new ContractObjectType();
        result.setId(rs.getInt("id"));
        result.setTitle(rs.getString("title"));
        result.setEntityTitleMacros(rs.getString("name_macros"));
        result.setComment(rs.getString("comment"));
        result.setHidden(rs.getBoolean("ishidden"));
        PreparedStatement ps = this.getModuleIdsPS;
        if (ps == null) {
            ps = this.getModuleIdsPS = this.con.prepareStatement("SELECT mid FROM object_type_module WHERE type_id=?");
        }
        ps.setInt(1, result.getId());
        ResultSet getModuleIdsRS = ps.executeQuery();
        HashSet<Integer> moduleIds = new HashSet<Integer>();
        while (getModuleIdsRS.next()) {
            moduleIds.add(getModuleIdsRS.getInt(1));
        }
        result.setModuleIds(moduleIds);
        return result;
    }

    @Override
    protected void updateImpl(ContractObjectType b2) throws BGException, SQLException {
        String query = null;
        PreparedStatement ps = null;
        if (b2.getId() <= 0) {
            query = "INSERT INTO " + this.tableName + " (title, name_macros, comment, ishidden) VALUES (?, ?, ?, ?)";
            ps = this.con.prepareStatement(query, 1);
        } else {
            query = "UPDATE " + this.tableName + " SET title=?, name_macros=?, comment=?, ishidden=? WHERE id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(5, b2.getId());
        }
        ps.setString(1, b2.getTitle());
        ps.setString(2, b2.getEntityTitleMacros());
        ps.setString(3, b2.getComment());
        ps.setBoolean(4, b2.isHidden());
        ps.executeUpdate();
        if (b2.getId() <= 0) {
            b2.setId(ServerUtils.lastInsertId(ps));
        }
        ps.close();
        ps = this.con.prepareStatement("DELETE FROM object_type_module WHERE type_id=?");
        ps.setInt(1, b2.getId());
        ps.executeUpdate();
        ps.close();
        ps = this.con.prepareStatement("INSERT INTO object_type_module (type_id, mid) VALUES (?,?)");
        ps.setInt(1, b2.getId());
        for (Integer moduleId : b2.getModuleIds()) {
            ps.setInt(1, moduleId);
            ps.executeUpdate();
        }
        ps.close();
    }

    @Override
    protected int deleteImpl(int id) throws BGException, SQLException {
        int result = super.deleteImpl(id);
        PreparedStatement ps = this.con.prepareStatement("DELETE FROM object_type_module WHERE type_id=?");
        ps.setInt(1, id);
        ps.executeUpdate();
        ps.close();
        return result;
    }

    @Override
    public void recycle() throws BGException {
        super.recycle();
        try {
            if (this.getModuleIdsPS != null) {
                this.getModuleIdsPS.close();
                this.getModuleIdsPS = null;
            }
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }

    @Override
    public ContractObjectType get(String title) throws BGException {
        return (ContractObjectType)super.get("title=?", title);
    }

    @Override
    public List<ContractObjectType> list() throws BGException {
        return super.list(null, null, new Object[0]);
    }
}

