/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.selfcare.server.service;

import bitel.billing.server.contract.logon.ContractLogonLast;
import bitel.billing.server.contract.logon.LogonManager;
import bitel.billing.server.util.Config;
import java.util.Collections;
import javax.jws.WebService;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.selfcare.common.service.ContractLoginService;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.ContractWebLoginEvent;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.model.MapHolder;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.contract.selfcare.common.service.ContractLoginService")
public class ContractLoginServiceImpl
extends AbstractService
implements ContractLoginService {
    private static final Logger logger = Logger.getLogger(ContractLoginServiceImpl.class);

    @Override
    public void contractLoginLogAdd(int contractId, boolean success, String remoteAddress, String sessionId, String user, String type, String data) {
        LogonManager logonManager = new LogonManager(this.getConnection());
        try {
            ContractLogonLast contractLogonLast = logonManager.getContractLogonLast(contractId);
            if (contractLogonLast != null && contractLogonLast.getDateTime().getTime() < System.currentTimeMillis() - 86400000L) {
                Conf conf = this.getSetup().getConfig(0, Conf.class);
                int logonLogRecord = conf.logonLogRecord;
                int logonLogPeriod = conf.logonLogPeriod;
                logonManager.clearLogonOkLog(contractId, logonLogRecord, logonLogPeriod);
                logonManager.clearLogonErrorLog(contractId, logonLogRecord, logonLogPeriod);
            }
            logonManager.updateContractLogonLast(contractId, success ? -1 : 1, remoteAddress);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (success) {
            logonManager.saveLogonOk(contractId, remoteAddress, sessionId, type);
        } else {
            logonManager.saveLogonError(contractId, remoteAddress, user, data);
        }
    }

    @Override
    public void contractLoginEvent(int contractId, MapHolder<String, String> params) throws BGException, BGMessageException, BGIllegalArgumentException {
        EventProcessor.getInstance().request(new ContractWebLoginEvent(contractId, new ParameterMap.DefaultParameterMap(params != null && params.getMap() != null ? params.getMap() : Collections.emptyMap())));
    }

    static class Conf
    extends Config {
        final int logonLogRecord;
        final int logonLogPeriod;

        public Conf(int mid, ParameterMap moduleSetup, Setup setup) {
            super(mid, moduleSetup, setup);
            this.logonLogRecord = setup.getInt("logon.log.record", 100);
            this.logonLogPeriod = setup.getInt("logon.log.period", 100);
        }
    }
}

