/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.convert;

import bitel.billing.server.contract.ContractRemover;
import java.sql.Connection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.sql.ConnectionSet;

class RemoveThread
implements Runnable {
    BlockingQueue<Integer> queue = new LinkedBlockingQueue<Integer>();
    private final Setup setup;

    public RemoveThread(Setup setup) {
        this.setup = setup;
    }

    public void addContract(int contractId) throws InterruptedException {
        this.queue.put(contractId);
    }

    public void finish() throws InterruptedException {
        this.queue.put(-1);
    }

    @Override
    public void run() {
        try (ConnectionSet connectionSet = ConnectionSet.newInstance(this.setup, true);
             Connection con = connectionSet.getConnection();
             ContractRemover remover = new ContractRemover(this.setup, con, null);){
            ServerContext context = new ServerContext(this.setup, connectionSet, 0, 0);
            ServerContext.set(context);
            Integer cid = null;
            while ((cid = this.queue.take()) != -1) {
                remover.removeContract(cid, false);
                if (con.getAutoCommit()) continue;
                con.commit();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

