/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.event;

import java.io.EOFException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.event.AbstractConsumer;
import ru.bitel.bgbilling.kernel.event.AcknowledgeConsumer;
import ru.bitel.bgbilling.kernel.event.Consumer;
import ru.bitel.bgbilling.kernel.event.ErrorReturnableEvent;
import ru.bitel.bgbilling.kernel.event.Event;
import ru.bitel.bgbilling.kernel.event.EventKey;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventListenerThreadContext;
import ru.bitel.bgbilling.kernel.event.EventProcessorException;
import ru.bitel.bgbilling.kernel.event.EventType;
import ru.bitel.bgbilling.kernel.event.LocalEvent;
import ru.bitel.bgbilling.kernel.event.LocalEventProcessor;
import ru.bitel.bgbilling.kernel.event.PartitionedQueueEvent;
import ru.bitel.bgbilling.kernel.event.PoolEvent;
import ru.bitel.bgbilling.kernel.event.PoolEventList;
import ru.bitel.bgbilling.kernel.event.PoolEventPublisher;
import ru.bitel.bgbilling.kernel.event.PoolQueueEvent;
import ru.bitel.bgbilling.kernel.event.PoolQueueEventPublisher;
import ru.bitel.bgbilling.kernel.event.PoolTopicEventPublisher;
import ru.bitel.bgbilling.kernel.event.Producer;
import ru.bitel.bgbilling.kernel.event.QueueEvent;
import ru.bitel.bgbilling.kernel.event.SystemEventListener;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.SetupParam;
import ru.bitel.common.Utils;
import ru.bitel.common.bootstrap.Shutdown;
import ru.bitel.common.logging.NestedContext;
import ru.bitel.common.worker.Commitable;
import ru.bitel.common.worker.CommitableHandler;
import ru.bitel.common.worker.ThreadContext;

public class EventProcessor {
    static final Logger logger = Logger.getLogger(EventProcessor.class);
    volatile ExecutorService executor;
    private final ConcurrentMap<String, AbstractConsumer> consumers;
    private final ConcurrentMap<String, Producer> producers;
    final String applicationName;
    private final String commonIdentifierName;
    private final int commonIdentifierValue;
    private final Connection con;
    final Session producerSession;
    private final Session consumerSession;
    private final Session acknowledgeConsumerSession;
    private final Session acknowledgeConsumerSyncSession;
    private final Session consumerSyncSession;
    volatile int threadCount;
    final Setup setup;
    private final LocalEventProcessor local;
    private final ReentrantLock lock;
    private volatile boolean shutdown;
    public final boolean syncAcknowledgeFix;
    private final boolean skipQueueEventListeners;
    private static final LinkedBlockingQueue<Event> unsentQueue = new LinkedBlockingQueue(65536);
    private final Random random;
    private final ConcurrentMap<String, Message> responseMap;
    private final ConcurrentMap<String, Object> requestMap;

    public final void setThreadCount(int count, int queue) {
        this.executor = count > 0 ? EventListenerThreadContext.newExecutorService(this, count, queue) : null;
        this.threadCount = count;
    }

    private static Context getEnv() throws NamingException {
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("java.naming.factory.initial", "org.apache.naming.java.javaURLContextFactory");
        params.put("java.naming.factory.url.pkgs", "org.apache.naming");
        InitialContext ctx = new InitialContext(params);
        return (Context)ctx.lookup("java:comp/env");
    }

    private EventProcessor(Setup setup, Connection con, Session producerSession, Session consumerSession, Session acknowledgeSession, Session consumerSyncSession, Session acknowledgeSyncSession, int threadCount, int threadQueue, ConcurrentMap<String, AbstractConsumer> consumers, LocalEventProcessor local, boolean skipQueueEventListeners) throws BGException {
        Integer commonIdentifierValue;
        String commonIdentifierName;
        block12: {
            this.executor = null;
            this.consumers = new ConcurrentHashMap<String, AbstractConsumer>();
            this.producers = new ConcurrentHashMap<String, Producer>();
            this.lock = new ReentrantLock();
            this.shutdown = false;
            this.random = new Random();
            this.responseMap = new ConcurrentHashMap<String, Message>();
            this.requestMap = new ConcurrentHashMap<String, Object>();
            this.con = con;
            this.producerSession = producerSession;
            this.consumerSession = consumerSession;
            this.acknowledgeConsumerSession = acknowledgeSession;
            this.consumerSyncSession = consumerSyncSession;
            this.acknowledgeConsumerSyncSession = acknowledgeSyncSession;
            this.setThreadCount(threadCount, threadQueue);
            this.setup = setup;
            this.applicationName = SetupParam.getApplicationName();
            this.syncAcknowledgeFix = setup.getInt("mq.syncAcknowledgeFix", 1) > 0;
            this.skipQueueEventListeners = skipQueueEventListeners;
            commonIdentifierName = null;
            commonIdentifierValue = 0;
            try {
                Context ctx = EventProcessor.getEnv();
                commonIdentifierName = (String)ctx.lookup("commonIdentifierName");
                commonIdentifierValue = (Integer)ctx.lookup(commonIdentifierName);
            }
            catch (NamingException e) {
                if (commonIdentifierName == null) {
                    commonIdentifierName = setup.get("commonIdentifierName", null);
                }
                if (commonIdentifierName == null) break block12;
                commonIdentifierValue = setup.getInt("commonIdentifierValue", setup.getInt(commonIdentifierName, 0));
            }
        }
        if (commonIdentifierName != null && commonIdentifierValue != null) {
            this.commonIdentifierName = commonIdentifierName;
            this.commonIdentifierValue = commonIdentifierValue;
        } else {
            this.commonIdentifierName = null;
            this.commonIdentifierValue = 0;
        }
        this.local = new LocalEventProcessor(setup, this.applicationName, local);
        try {
            if (consumers != null) {
                Object e = consumers.entrySet().iterator();
                while (e.hasNext()) {
                    Map.Entry e2 = e.next();
                    AbstractConsumer c = (AbstractConsumer)e2.getValue();
                    String query = c.mc.getMessageSelector();
                    String key = c.destination + " WHERE " + query;
                    if (c instanceof AcknowledgeConsumer) {
                        this.consumers.put(key, new AcknowledgeConsumer(this, this.acknowledgeConsumerSession, c.moduleId, c.pluginId, c.destination, query, !c.topic, c.noLocal, c.deliveryMode, c.priority, c.timeToLive, false, c.classes));
                        continue;
                    }
                    this.consumers.put(key, new Consumer(this, this.consumerSession, c.moduleId, c.pluginId, c.destination, query, !c.topic, c.noLocal, c.deliveryMode, c.priority, c.timeToLive, false, c.classes));
                }
            }
            con.start();
        }
        catch (JMSException e) {
            throw new BGException(e);
        }
        catch (JAXBException e) {
            throw new BGException(e);
        }
        while ((e = unsentQueue.poll()) != null) {
            this.publish((Event)e);
        }
    }

    public <E extends Event> void addListener(EventListener<? super E> l, Class<E> clazz) throws BGException {
        this.addListener(l, clazz, null);
    }

    public <E extends Event> void addListener(EventListener<? super E> l, Class<E> clazz, String query) throws BGException {
        this.addListener(l, clazz, -1, -1, query);
    }

    public <E extends Event> void addListener(EventListener<? super E> l, Class<E> clazz, int moduleId, String query) throws BGException {
        this.addListener(l, clazz, moduleId, -1, query);
    }

    public <E extends Event> void addListener(EventListener<? super E> l, Class<E> clazz, int moduleId, int pluginId, String query) throws BGException {
        this.addListener0(l, clazz, moduleId, pluginId, query, false);
    }

    public <E extends Event> boolean updateListener(EventListener<? super E> l, Class<E> clazz, int moduleId, int pluginId, String query) throws BGException {
        return this.addListener0(l, clazz, moduleId, pluginId, query, true);
    }

    public <E extends Event> boolean updateListener(EventListener<? super E> l, Class<E> clazz) throws BGException {
        return this.updateListener(l, clazz, null);
    }

    public <E extends Event> boolean updateListener(EventListener<? super E> l, Class<E> clazz, String query) throws BGException {
        return this.updateListener(l, clazz, -1, -1, query);
    }

    public <E extends Event> boolean updateListener(EventListener<? super E> l, Class<E> clazz, int moduleId, String query) throws BGException {
        return this.updateListener(l, clazz, moduleId, -1, query);
    }

    static String getQuery(int moduleId, int pluginId, String query) {
        if (moduleId >= 0 || pluginId >= 0) {
            String q = null;
            if (moduleId > 0) {
                q = "moduleId=" + moduleId;
            } else if (pluginId > 0) {
                q = "pluginId=" + pluginId;
            }
            query = query == null ? q : q + " AND (" + query + ")";
        }
        return query;
    }

    public static <E extends Event> String getKey(Class<E> clazz, int moduleId, int pluginId, String query) {
        if ((query = EventProcessor.getQuery(moduleId, pluginId, query)) != null) {
            return "BG.Event." + clazz.getName() + " WHERE " + query;
        }
        return "BG.Event." + clazz.getName();
    }

    private <E extends Event> boolean addListener0(final EventListener<? super E> l, final Class<E> clazz, final int moduleId, final int pluginId, final String query, final boolean update) throws BGException {
        ServerContext context = (ServerContext)ServerContext.get();
        if (context instanceof EventListenerContext) {
            logger.warn((Object)"Adding listener in event-processor thread. Change adding to async thread due possible deadlock");
            final CompletableFuture future = new CompletableFuture();
            new Thread("ep-add-listener"){

                @Override
                public void run() {
                    boolean result = false;
                    try {
                        result = EventProcessor.this.addListener1(l, clazz, moduleId, pluginId, query, update);
                    }
                    catch (BGException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    future.complete(result);
                }
            }.start();
            try {
                return (Boolean)future.get(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                logger.error((Object)"Timeout adding listener. Possible deadlock, continue thread  ", (Throwable)e);
                return true;
            }
        }
        return this.addListener1(l, clazz, moduleId, pluginId, query, update);
    }

    private <E extends Event> boolean addListener1(EventListener<? super E> l, Class<E> clazz, int moduleId, int pluginId, String query, boolean update) throws BGException {
        if (this.skipQueueEventListeners && QueueEvent.class.isAssignableFrom(clazz)) {
            logger.warn((Object)("skipping add listener for " + clazz.getName()));
            return false;
        }
        this.lock.lock();
        try {
            AbstractConsumer consumer;
            String key;
            block17: {
                if (this.shutdown) {
                    throw new BGMessageException("Event processor is shutdown");
                }
                if (EventProcessor.isLocalEvent(clazz)) {
                    if (query != null) {
                        throw new IllegalArgumentException("Can't apply listener query to local events!");
                    }
                    boolean bl = this.local.addListener(l, clazz, moduleId, pluginId, update);
                    return bl;
                }
                if (EventProcessor.isPoolEvent(clazz) && query != null) {
                    logger.debug((Object)("Appling listener query to pool event " + clazz + "!"));
                }
                try {
                    query = EventProcessor.getQuery(moduleId, pluginId, query);
                    String name = "BG.Event." + clazz.getName();
                    key = query != null ? name + " WHERE " + query : name;
                    consumer = this.getConsumer(clazz, moduleId, pluginId, query, key, name);
                    if (!update || !consumer.listenerUpdate(l)) break block17;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Updated listener " + l + " to " + key));
                    }
                    boolean bl = true;
                    return bl;
                }
                catch (JMSException e) {
                    throw new BGException(e);
                }
                catch (JAXBException e) {
                    throw new BGException(e);
                }
            }
            logger.debug((Object)("Add " + l + " to " + key));
            if (l instanceof SystemEventListener) {
                consumer.listenerAddFirst(l);
            } else {
                consumer.listenerAdd(l);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private AbstractConsumer getConsumer(Class<? extends Event> clazz, int moduleId, int pluginId, String query, String key, String name) throws JMSException, JAXBException {
        AbstractConsumer consumer = (AbstractConsumer)this.consumers.get(key);
        if (consumer == null) {
            String destination = PartitionedQueueEvent.class.isAssignableFrom(clazz) ? "BG.Event." + clazz.getPackage().getName() + ".*." + clazz.getSimpleName() : name;
            EventType type = clazz.getAnnotation(EventType.class);
            AbstractConsumer newConsumer = type != null && !type.autoAcknowledge() ? new AcknowledgeConsumer(this, this.acknowledgeConsumerSession, clazz, type, moduleId, pluginId, destination, query, true, false) : new Consumer(this, this.consumerSession, clazz, type, moduleId, pluginId, destination, query, true, false);
            consumer = this.consumers.putIfAbsent(key, newConsumer);
            if (consumer == null) {
                consumer = newConsumer;
            } else {
                newConsumer.close();
                newConsumer.destroy();
            }
        }
        return consumer;
    }

    @Deprecated
    AbstractConsumer getConsumer(Class<? extends Event> clazz, int moduleId, int pluginId, String query) throws JMSException, JAXBException {
        query = EventProcessor.getQuery(moduleId, pluginId, query);
        String name = "BG.Event." + clazz.getName();
        String key = query != null ? name + " WHERE " + query : name;
        AbstractConsumer consumer = (AbstractConsumer)this.consumers.get(key);
        if (consumer == null) {
            EventType type = clazz.getAnnotation(EventType.class);
            AbstractConsumer newConsumer = type != null && !type.autoAcknowledge() ? new AcknowledgeConsumer(this, this.acknowledgeConsumerSession, clazz, type, moduleId, pluginId, name, query, true, false) : new Consumer(this, this.consumerSession, clazz, type, moduleId, pluginId, name, query, true, false);
            consumer = this.consumers.putIfAbsent(key, newConsumer);
            if (consumer == null) {
                consumer = newConsumer;
            } else {
                newConsumer.close();
                newConsumer.destroy();
            }
        }
        return consumer;
    }

    AbstractConsumer newSyncConsumer(Class<? extends Event> clazz, int moduleId, int pluginId, String query) throws JMSException, JAXBException {
        AbstractConsumer newConsumer;
        query = EventProcessor.getQuery(moduleId, pluginId, query);
        String name = "BG.Event." + clazz.getName();
        EventType type = clazz.getAnnotation(EventType.class);
        if (type != null && !type.autoAcknowledge()) {
            if (this.syncAcknowledgeFix) {
                Session acknowledgeConsumerSyncSession = this.con.createSession(false, 2);
                newConsumer = new AcknowledgeConsumer(this, acknowledgeConsumerSyncSession, clazz, type, moduleId, pluginId, name, query, false, true);
            } else {
                newConsumer = new AcknowledgeConsumer(this, this.acknowledgeConsumerSyncSession, clazz, type, moduleId, pluginId, name, query, false, false);
            }
        } else {
            newConsumer = new Consumer(this, this.consumerSyncSession, clazz, type, moduleId, pluginId, name, query, false, false);
        }
        return newConsumer;
    }

    AbstractConsumer newSyncConsumer(String destination, int moduleId, int pluginId, String query, boolean autoAcknowledge, boolean noLocal, int deliveryMode, int priority, long timeToLive, Class<? extends Event> ... clazz) throws JMSException, JAXBException {
        query = EventProcessor.getQuery(moduleId, pluginId, query);
        String name = "BG.Event." + destination;
        if (!autoAcknowledge) {
            if (this.syncAcknowledgeFix) {
                Session acknowledgeConsumerSyncSession = this.con.createSession(false, 2);
                return new AcknowledgeConsumer(this, acknowledgeConsumerSyncSession, moduleId, pluginId, name, query, true, noLocal, deliveryMode, priority, timeToLive, true, clazz);
            }
            return new AcknowledgeConsumer(this, this.acknowledgeConsumerSyncSession, moduleId, pluginId, name, query, true, noLocal, deliveryMode, priority, timeToLive, false, clazz);
        }
        return new Consumer(this, this.consumerSyncSession, moduleId, pluginId, name, query, true, noLocal, deliveryMode, priority, timeToLive, false, clazz);
    }

    AbstractConsumer newConsumer(String destination, int moduleId, int pluginId, String query, boolean autoAcknowledge, boolean noLocal, int deliveryMode, int priority, long timeToLive, Class<? extends Event> ... clazz) throws JMSException, JAXBException {
        query = EventProcessor.getQuery(moduleId, pluginId, query);
        String name = "BG.Event." + destination;
        if (!autoAcknowledge) {
            Session acknowledgeConsumerSyncSession = this.con.createSession(false, 2);
            return new AcknowledgeConsumer(this, acknowledgeConsumerSyncSession, moduleId, pluginId, name, query, true, noLocal, deliveryMode, priority, timeToLive, true, clazz);
        }
        Session autoacknowledgeConsumerSyncSession = this.con.createSession(false, 1);
        return new Consumer(this, autoacknowledgeConsumerSyncSession, moduleId, pluginId, name, query, true, noLocal, deliveryMode, priority, timeToLive, true, clazz);
    }

    AbstractConsumer newConsumer(Class<? extends Event> clazz, int moduleId, int pluginId, String query) throws JMSException, JAXBException {
        AbstractConsumer newConsumer;
        query = EventProcessor.getQuery(moduleId, pluginId, query);
        String name = "BG.Event." + clazz.getName();
        EventType type = clazz.getAnnotation(EventType.class);
        if (type != null && !type.autoAcknowledge()) {
            Session acknowledgeConsumerSyncSession = this.con.createSession(false, 2);
            newConsumer = new AcknowledgeConsumer(this, acknowledgeConsumerSyncSession, clazz, type, moduleId, pluginId, name, query, false, true);
        } else {
            Session autoacknowledgeConsumerSyncSession = this.con.createSession(false, 1);
            newConsumer = new Consumer(this, autoacknowledgeConsumerSyncSession, clazz, type, moduleId, pluginId, name, query, false, true);
        }
        return newConsumer;
    }

    public void removeListener(EventListener<?> l) throws BGException {
        this.removeListener(l, Collections.emptySet());
    }

    public <E extends Event> void removeListener(EventListener<?> l, Class<E> clazz, int moduleId, String query) throws BGException {
        this.local.removeListener(l, Collections.emptySet());
        int pluginId = -1;
        query = EventProcessor.getQuery(moduleId, pluginId, query);
        String name = "BG.Event." + clazz.getName();
        String key = query != null ? name + " WHERE " + query : name;
        AbstractConsumer consumer = (AbstractConsumer)this.consumers.get(key);
        if (consumer.listenerRemove(l) && consumer.listenersCount() == 0) {
            this.consumers.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(EventListener<?> l, Collection<String> exceptKeys) throws BGException {
        this.lock.lock();
        try {
            this.local.removeListener(l, exceptKeys);
            try {
                Iterator iter = this.consumers.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry e = iter.next();
                    AbstractConsumer consumer = (AbstractConsumer)e.getValue();
                    if (exceptKeys.contains(e.getKey()) || !consumer.listenerRemove(l) || consumer.listenersCount() != 0) continue;
                    iter.remove();
                    consumer.close();
                }
            }
            catch (JMSException e) {
                throw new BGException(e);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private final Producer getProducer(Event e) throws JMSException, JAXBException {
        Class<Object> clazz = e instanceof PoolEventList ? ((PoolEventList)e).clazz : e.getClass();
        String name = e.getDestination(clazz);
        Producer producer = (Producer)this.producers.get(name);
        if (producer == null) {
            Producer newProducer = QueueEvent.class.isAssignableFrom(clazz) ? new Producer(this.producerSession, this.requestMap, this.responseMap, clazz, this.producerSession.createProducer((Destination)this.producerSession.createQueue(name)), false) : new Producer(this.producerSession, this.requestMap, this.responseMap, clazz, this.producerSession.createProducer((Destination)this.producerSession.createTopic(name)), true);
            producer = this.producers.putIfAbsent(name, newProducer);
            if (producer == null) {
                producer = newProducer;
            } else {
                newProducer.close();
            }
        }
        return producer;
    }

    private static boolean isLocalEvent(Class<? extends Event> clazz) {
        return LocalEvent.class.isAssignableFrom(clazz);
    }

    private static boolean isLocalEvent(Event e) {
        return e instanceof LocalEvent;
    }

    private static boolean isPoolEvent(Class<? extends Event> clazz) {
        return PoolEvent.class.isAssignableFrom(clazz);
    }

    public final void publishAfterCommit(CommitableHandler context, final Event e) {
        context.addCommitable(new Commitable(){

            @Override
            public final void commit() throws Exception {
                EventProcessor.this.publish(e);
            }
        });
    }

    public final void publishAfterCommit(final Event e) {
        ThreadContext.get(CommitableHandler.class).addCommitable(new Commitable(){

            @Override
            public final void commit() throws Exception {
                EventProcessor.this.publish(e);
            }
        });
    }

    public final void publish(Event e) throws BGException {
        block13: {
            if (EventProcessor.isLocalEvent(e)) {
                throw new IllegalArgumentException("Can't publish local events(" + e.getClass().getName() + ")! Use request()");
            }
            NestedContext.push("mq");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Publish: " + e));
            }
            try {
                Producer producer = this.getProducer(e);
                Message message = producer.createMessage(e);
                if (this.commonIdentifierName != null) {
                    message.setIntProperty(this.commonIdentifierName, this.commonIdentifierValue);
                }
                e.prepareMessage(message);
                message.setStringProperty("bg:app", this.applicationName);
                producer.send(message);
            }
            catch (JMSException ex) {
                if (ex.getCause() instanceof EOFException) {
                    logger.warn((Object)("There is problem with MQ connection! " + ex.getMessage()));
                    try {
                        logger.debug((Object)"Add event to wait queue...");
                        unsentQueue.put(e);
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                        logger.error((Object)e1.getMessage(), (Throwable)e1);
                    }
                    break block13;
                }
                throw new BGException(ex);
            }
            catch (Exception ex) {
                throw new BGException(ex);
            }
            finally {
                NestedContext.pop();
            }
        }
    }

    public final <Q extends QueueEvent> Q request(Q e) throws BGException {
        Q result = this.request(e, 0L);
        this.processError(result);
        return result;
    }

    private void processError(Event e) throws BGException {
        String error;
        if (e instanceof ErrorReturnableEvent && Utils.notBlankString(error = ((ErrorReturnableEvent)((Object)e)).getError())) {
            throw new BGMessageException(error);
        }
    }

    public final <Q extends Event> Q request(Q e, long timeout) throws EventProcessorException {
        if (EventProcessor.isLocalEvent(e)) {
            return this.local.request(e);
        }
        NestedContext.push("mq");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Request, timeout " + timeout + " : " + e));
        }
        String correlationId = null;
        try {
            byte[] bytes = new byte[16];
            this.random.nextBytes(bytes);
            correlationId = Utils.bytesToHexString(bytes);
            Producer producer = this.getProducer(e);
            Message message = producer.createMessage(e);
            if (this.commonIdentifierName != null) {
                message.setIntProperty(this.commonIdentifierName, this.commonIdentifierValue);
            }
            e.prepareMessage(message);
            message.setStringProperty("bg:app", this.applicationName);
            message.setJMSReplyTo((Destination)producer.replyQueue);
            message.setJMSCorrelationID(correlationId);
            if (timeout > 0L) {
                Event event = (Event)producer.request(correlationId, message, timeout);
                return (Q)event;
            }
            Event event = (Event)producer.request(correlationId, message);
            return (Q)event;
        }
        catch (Exception ex) {
            if (correlationId != null) {
                this.requestMap.remove(correlationId);
                this.responseMap.remove(correlationId);
            }
            throw new EventProcessorException(ex);
        }
        finally {
            NestedContext.pop();
        }
    }

    public <Q extends Event> Future<Q> requestAsync(Q e, long timeout) throws EventProcessorException {
        assert (timeout > 0L);
        if (EventProcessor.isLocalEvent(e)) {
            throw new IllegalArgumentException("Can't requestAsync local events! Use request()");
        }
        NestedContext.push("mq");
        String correlationId = null;
        try {
            byte[] bytes = new byte[16];
            this.random.nextBytes(bytes);
            correlationId = Utils.bytesToHexString(bytes);
            Producer producer = this.getProducer(e);
            Message message = producer.createMessage(e);
            if (this.commonIdentifierName != null) {
                message.setIntProperty(this.commonIdentifierName, this.commonIdentifierValue);
            }
            e.prepareMessage(message);
            message.setStringProperty("bg:app", this.applicationName);
            message.setJMSReplyTo((Destination)producer.replyQueue);
            message.setJMSCorrelationID(correlationId);
            Future future = producer.requestAsync(correlationId, message, timeout);
            return future;
        }
        catch (Exception ex) {
            if (correlationId != null) {
                this.requestMap.remove(correlationId);
                this.responseMap.remove(correlationId);
            }
            throw new EventProcessorException(ex);
        }
        finally {
            NestedContext.pop();
        }
    }

    private static EventProcessor newInstance(FutureTask<EventProcessor> task) {
        new Thread(task, "EventProcessor-init").start();
        while (true) {
            try {
                return task.get(4L, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                logger.error((Object)"Problem with MQ connection! Timeout connecting to the MQ broker!");
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                return null;
            }
            break;
        }
    }

    protected static EventProcessor newInstance(final ConnectionFactory connectionFactory) {
        FutureTask<EventProcessor> task = new FutureTask<EventProcessor>(new Callable<EventProcessor>(){

            @Override
            public EventProcessor call() throws Exception {
                NestedContext.push("mq");
                return EventProcessor.newInstance0(null, connectionFactory, null);
            }
        });
        return EventProcessor.newInstance(task);
    }

    private static EventProcessor newInstance(final EventProcessor eventProcessor) {
        FutureTask<EventProcessor> task = new FutureTask<EventProcessor>(new Callable<EventProcessor>(){

            @Override
            public EventProcessor call() throws Exception {
                NestedContext.push("mq");
                try {
                    Context ctx = EventProcessor.getEnv();
                    ConnectionFactory connectionFactory = (ConnectionFactory)ctx.lookup("mq/connectionFactory");
                    return EventProcessor.newInstance0(eventProcessor, connectionFactory, new ExceptionListener(){

                        public void onException(JMSException ex) {
                            EventProcessor.onFault();
                            logger.error((Object)ex.getMessage(), (Throwable)ex);
                        }
                    });
                }
                catch (Throwable t) {
                    if (t.getCause() instanceof EOFException) {
                        EventProcessor.onFault();
                    }
                    NestedContext.push("");
                    try {
                        logger.error((Object)t.getMessage(), t);
                    }
                    finally {
                        NestedContext.pop();
                    }
                    return null;
                }
            }
        });
        return EventProcessor.newInstance(task);
    }

    private static EventProcessor newInstance0(EventProcessor eventProcessor, ConnectionFactory connectionFactory, ExceptionListener exceptionListener) throws JMSException, BGException {
        boolean skipQueueEventListeners;
        logger.info((Object)"Init EventProcessor MQ connection factory...");
        Setup setup = null;
        int threadCount = 0;
        int threadQueue = 8;
        try {
            Context ctx = EventProcessor.getEnv();
            setup = (Setup)ctx.lookup("Setup");
            threadCount = setup.getInt("event.process.thread.count", 1);
            threadQueue = setup.getInt("event.process.thread.queue", 8);
        }
        catch (NamingException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        Connection con = connectionFactory.createConnection();
        if (exceptionListener != null) {
            con.setExceptionListener(exceptionListener);
        }
        Session producerSession = con.createSession(false, 1);
        Session consumerSession = con.createSession(false, 1);
        Session acknowledgeConsumerSession = con.createSession(false, 2);
        Session consumerSyncSession = con.createSession(false, 1);
        Session acknowledgeConsumerSyncSession = con.createSession(false, 2);
        boolean bl = skipQueueEventListeners = setup.get("no.event.process", null) != null;
        if (eventProcessor != null) {
            return new EventProcessor(setup, con, producerSession, consumerSession, acknowledgeConsumerSession, consumerSyncSession, acknowledgeConsumerSyncSession, threadCount, threadQueue, eventProcessor.consumers, eventProcessor.local, skipQueueEventListeners);
        }
        return new EventProcessor(setup, con, producerSession, consumerSession, acknowledgeConsumerSession, consumerSyncSession, acknowledgeConsumerSyncSession, threadCount, threadQueue, null, null, skipQueueEventListeners);
    }

    private static void onFault() {
    }

    public List<Class<? extends Event>> getListeningEvents() {
        ArrayList<Class<? extends Event>> events = new ArrayList<Class<? extends Event>>();
        for (AbstractConsumer c : this.consumers.values()) {
            for (Class clazz : c.classes) {
                events.add(clazz);
            }
        }
        return events;
    }

    public List<Class<? extends Event>> getListeningQueueEvents() {
        ArrayList<Class<? extends Event>> events = new ArrayList<Class<? extends Event>>();
        for (AbstractConsumer c : this.consumers.values()) {
            for (Class clazz : c.classes) {
                if (!QueueEvent.class.isAssignableFrom(clazz)) continue;
                events.add(clazz);
            }
        }
        return events;
    }

    public List<EventKey> getListeningEventKeys() {
        ArrayList<EventKey> events = new ArrayList<EventKey>();
        for (AbstractConsumer c : this.consumers.values()) {
            for (Class clazz : c.classes) {
                EventKey key = new EventKey(clazz, c.moduleId, c.pluginId, c.query);
                events.add(key);
            }
        }
        events.addAll(this.local.getListeningEventKeys());
        return events;
    }

    public static final EventProcessor getInstance() {
        return InstanceHolder.processor;
    }

    public <E extends PoolEvent> PoolEventPublisher<E> newPoolEventPublisher(Class<E> clazz, int moduleId) {
        return new PoolTopicEventPublisher<E>(this, clazz, moduleId, -1);
    }

    public <E extends PoolEvent> PoolEventPublisher<E> newPoolEventPublisher(Class<E> clazz, int moduleId, int capacity, long delay) {
        return new PoolTopicEventPublisher<E>(this, clazz, moduleId, -1, capacity, delay);
    }

    public <E extends PoolQueueEvent> PoolEventPublisher<E> newPoolQueueEventPublisher(Class<E> clazz, int moduleId) {
        return new PoolQueueEventPublisher<E>(this, clazz, moduleId, -1);
    }

    public <E extends PoolQueueEvent> PoolEventPublisher<E> newPoolQueueEventPublisher(Class<E> clazz, int moduleId, int capacity, long delay) {
        return new PoolQueueEventPublisher<E>(this, clazz, moduleId, -1, capacity, delay);
    }

    public void shutdown() throws JMSException, InterruptedException {
        this.lock.lock();
        try {
            this.shutdown = true;
            logger.info((Object)"Shutdown EventProcessor...");
            Iterator iter = this.consumers.values().iterator();
            while (iter.hasNext()) {
                AbstractConsumer consumer = (AbstractConsumer)iter.next();
                iter.remove();
                consumer.close();
            }
            ExecutorService executor = this.executor;
            if (executor != null) {
                executor.shutdown();
                executor.awaitTermination(0L, TimeUnit.SECONDS);
            }
            this.producerSession.close();
            this.consumerSession.close();
            this.acknowledgeConsumerSession.close();
        }
        finally {
            this.lock.unlock();
        }
    }

    static /* synthetic */ EventProcessor access$100(EventProcessor x0) {
        return EventProcessor.newInstance(x0);
    }

    static {
        Shutdown.addOnShutdown(new Shutdown.OnShutdown(){

            @Override
            public void onShutdown() {
                EventProcessor processor = InstanceHolder.processor;
                if (processor != null) {
                    try {
                        processor.shutdown();
                    }
                    catch (JMSException e) {
                        e.printStackTrace();
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    static class InstanceHolder {
        static final EventProcessor processor = EventProcessor.access$100(null);

        InstanceHolder() {
        }
    }
}

