/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.event.events;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.apps.server.bean.AppsManager;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.LocalEvent;
import ru.bitel.common.SerialUtils;

@XmlRootElement
public class AppsEvent
extends LocalEvent {
    private static final Logger logger = Logger.getLogger(AppsEvent.class);
    private static final long serialVersionUID = SerialUtils.generateSerialVersionUID(AppsEvent.class);
    private boolean isModule = true;
    private String module = null;
    private String plugin = null;
    private String action = null;
    private HttpServletRequest request = null;
    private Map<String, String> requestParamsMap;
    private Map<String, Object> dataMap = new HashMap<String, Object>();

    public AppsEvent(String module, int moduleId, String action, int contractId, HttpServletRequest request, Map<String, String> requestParamsMap) {
        super(moduleId, contractId, -1);
        this.module = module;
        this.action = action;
        this.request = request;
        this.requestParamsMap = requestParamsMap;
        this.isModule = true;
    }

    public AppsEvent(String plugin, String action, int contractId, HttpServletRequest request, Map<String, String> requestParamsMap) {
        super(0, contractId, -1);
        this.plugin = plugin;
        this.action = action;
        this.request = request;
        this.requestParamsMap = requestParamsMap;
        this.isModule = false;
    }

    public String getModule() {
        return this.module;
    }

    public String getPlugin() {
        return this.plugin;
    }

    public String getAction() {
        return this.action;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public Map<String, Object> getDataMap() {
        return this.dataMap;
    }

    public Map<String, String> getRequestParamsMap() {
        return this.requestParamsMap;
    }

    static {
        try {
            EventProcessor.getInstance().addListener(new EventListener<AppsEvent>(){

                @Override
                public void notify(AppsEvent event, EventListenerContext eventListenerContext) throws BGException {
                    try (AppsManager appsManager = new AppsManager(eventListenerContext.getConnection(), event.getUserId());){
                        if (event.isModule) {
                            appsManager.doModuleAction(event.getModule(), event.getModuleId(), event.getAction(), event.getContractId(), event.getRequest(), event.getDataMap(), event.getRequestParamsMap());
                        } else {
                            appsManager.doPluginAction(event.getPlugin(), event.getAction(), event.getContractId(), event.getRequest(), event.getDataMap(), event.getRequestParamsMap());
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }, AppsEvent.class);
        }
        catch (Throwable e) {
            logger.error((Object)e.getMessage(), e);
        }
    }
}

