/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.module.server.service;

import bitel.billing.server.contract.bean.ContractModuleManager;
import bitel.billing.server.installer.ScanUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.annotation.PostConstruct;
import javax.jws.WebService;
import javax.xml.ws.Holder;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.module.common.bean.BGInstalledModule;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.common.service.ModuleService;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.module.server.bean.ModuleManager;
import ru.bitel.bgbilling.kernel.module.server.event.ModulesChangedEvent;
import ru.bitel.bgbilling.kernel.task.server.TaskCache;
import ru.bitel.common.Utils;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.module.common.service.ModuleService")
public class ModuleServiceImpl
extends AbstractService
implements ModuleService {
    private ModuleManager mm;

    @PostConstruct
    protected void init() {
        this.mm = new ModuleManager(this.getConnection());
    }

    @Override
    public int moduleAdd(String module, String title) throws BGException {
        BGInstalledModule installedModule = ModuleCache.getInstance().getInstalledModule(module);
        if (installedModule == null) {
            throw new BGMessageException("\u041c\u043e\u0434\u0443\u043b\u044c " + module + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!");
        }
        int result = this.mm.addModule(installedModule, title, this.userId);
        TaskCache.getInstance().reloadTasks();
        this.context.publishAfterCommit(new ModulesChangedEvent(this.userId));
        return result;
    }

    @Override
    public void moduleUpdate(BGModule module) throws BGException {
        if (module.getId() <= 0) {
            throw new BGIllegalArgumentException();
        }
        this.mm.updateModule(module);
        this.context.publishAfterCommit(new ModulesChangedEvent(this.userId));
    }

    @Override
    public void moduleDelete(int id) throws BGException {
        ModuleCache cache = ModuleCache.getInstance();
        if (cache.getModuleServicesList(id).size() > 0) {
            throw new BGMessageException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043c\u043e\u0434\u0443\u043b\u044c \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0449\u0438\u0439 \u0443\u0441\u043b\u0443\u0433\u0438.");
        }
        BGModule module = cache.getModule(id);
        if (module == null) {
            throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043c\u043e\u0434\u0443\u043b\u044c \u0441 \u043a\u043e\u0434\u043e\u043c: " + id);
        }
        this.mm.deleteModule(module.getInstalledModule(), id);
        this.context.publishAfterCommit(new ModulesChangedEvent(this.userId));
    }

    @Override
    public List<BGModule> moduleList() throws BGException {
        return ModuleCache.getInstance().getModulesList();
    }

    @Override
    public List<BGInstalledModule> installedModuleList() throws BGException {
        return ModuleCache.getInstance().getInstalledModulesList().stream().filter(n -> n.getType().equals("module")).collect(Collectors.toList());
    }

    @Override
    public Set<Integer> contractModuleIds(int contractId) throws BGException {
        return new ContractModuleManager(this.getConnection()).getContractModuleSet(contractId);
    }

    @Override
    public List<BGInstalledModule> installedClientModuleList() throws BGException {
        ArrayList<BGInstalledModule> result = new ArrayList<BGInstalledModule>();
        for (ScanUtils.ModuleInfo mi : new ScanUtils(this.getConnection()).getModulesInfo(null)) {
            BGInstalledModule module = new BGInstalledModule();
            module.setTitle(mi.name);
            module.setName(mi.packetName);
            module.setBuild(mi.build);
            module.setName(mi.packetName);
            result.add(module);
        }
        return result;
    }

    @Override
    public void installedClientModulePacketGet(final String name, Holder<DataHandler> result) throws BGException {
        File nameJarDir;
        if (Utils.isBlankString(name)) {
            throw new BGIllegalArgumentException();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(100000);
        boolean fl = false;
        File clientJarDir = new File("client.jars");
        if (clientJarDir.exists() && (nameJarDir = new File(clientJarDir, name)).exists()) {
            try {
                ZipOutputStream zipOutputStream = new ZipOutputStream(baos);
                for (String jarName : nameJarDir.list(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name != null && name.endsWith(".jar");
                    }
                })) {
                    int count;
                    ZipEntry zipEntry = new ZipEntry(jarName);
                    zipEntry.setTime(System.currentTimeMillis());
                    zipOutputStream.putNextEntry(zipEntry);
                    ByteBuffer buffer = ByteBuffer.allocate(1024);
                    FileInputStream fileInputStream = new FileInputStream(new File(nameJarDir, jarName));
                    FileChannel jarFileChannel = fileInputStream.getChannel();
                    while ((count = jarFileChannel.read(buffer)) != -1) {
                        buffer.flip();
                        zipOutputStream.write(buffer.array(), 0, count);
                        buffer.clear();
                    }
                    jarFileChannel.close();
                    fileInputStream.close();
                    zipOutputStream.closeEntry();
                }
                zipOutputStream.flush();
                zipOutputStream.close();
                fl = true;
            }
            catch (Exception ex) {
                throw new BGException(ex);
            }
        }
        if (!fl) {
            try {
                byte[] data;
                String query = "SELECT client_zip FROM installed_modules WHERE name=?";
                PreparedStatement ps = this.getConnection().prepareStatement(query);
                ps.setString(1, name);
                ResultSet rs = ps.executeQuery();
                if (rs.next() && (data = rs.getBytes(1)) != null) {
                    ByteArrayOutputStream out = baos;
                    out.write(data);
                    out.flush();
                    ((OutputStream)out).close();
                }
                rs.close();
                ps.close();
            }
            catch (Exception ex) {
                throw new BGException(ex);
            }
        }
        final ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        result.value = new DataHandler(new DataSource(){

            public String getContentType() {
                return "application/octet-stream";
            }

            public InputStream getInputStream() throws IOException {
                return bais;
            }

            public String getName() {
                return name + ".zip";
            }

            public OutputStream getOutputStream() throws IOException {
                return null;
            }
        });
    }
}

