/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.flow;

import bitel.billing.common.IPUtils;
import bitel.billing.server.admin.errorlog.AlarmSender;
import bitel.billing.server.admin.errorlog.bean.AlarmErrorMessage;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.kernel.network.flow.Data;
import ru.bitel.common.ByteBufferUtils;

public class SnmpFlowRecord
extends Data {
    static final Logger logger = Logger.getLogger(SnmpFlowRecord.class);
    public static final int RECORD_SIZE = 68;
    protected final Map<Integer, SnmpFlowRecord> lastSnmp;
    protected ByteBuffer data = ByteBuffer.allocate(68);
    public static volatile boolean FIX_OVERFLOW = false;
    protected int snmpInterface;
    protected long snmpInputOctets;
    protected long snmpOutputOctets;
    protected long snmpSysUptime;
    protected int snmpAdminStatus;
    protected int snmpOperStatus;
    protected long snmpStatusLastChange;

    public SnmpFlowRecord(Map<Integer, SnmpFlowRecord> lastSnmp) {
        this.lastSnmp = lastSnmp;
    }

    @Override
    public long getMilliseconds() {
        return this.milliseconds;
    }

    public int snmpGetInteface() {
        return this.snmpInterface;
    }

    public void fillData(ByteBuffer byteBuffer) {
        int offset = byteBuffer.position();
        this.snmpInterface = byteBuffer.getInt(offset + 4);
        this.snmpInputOctets = (long)byteBuffer.getInt(offset + 32) & 0xFFFFFFFFL;
        this.snmpOutputOctets = (long)byteBuffer.getInt(offset + 52) & 0xFFFFFFFFL;
        this.snmpSysUptime = (long)byteBuffer.getInt(offset) & 0xFFFFFFFFL;
        this.snmpAdminStatus = byteBuffer.getInt(offset + 20);
        this.snmpOperStatus = byteBuffer.getInt(offset + 24);
        this.snmpStatusLastChange = (long)byteBuffer.getInt(offset + 28) & 0xFFFFFFFFL;
        this.srcAddress.address = this.ipv4SrcAddress;
        this.srcAddress.clear();
        this.dstAddress.address = this.ipv4DstAddress;
        this.dstAddress.clear();
        this.nextHop = 0L;
        this.packets = 0L;
        this.first = 0L;
        this.last = 0L;
        this.srcPort = 0;
        this.dstPort = 0;
        this.diffServ = 0;
        byteBuffer.position(offset);
    }

    public ByteBuffer getData() {
        ByteBuffer bb = ByteBuffer.allocate(68);
        ByteBufferUtils.putUnsignedInt(bb, this.snmpSysUptime);
        bb.putInt(this.snmpInterface);
        bb.putInt(0);
        bb.putInt(0);
        bb.putInt(0);
        bb.putInt(0);
        bb.putInt(0);
        bb.putInt(0);
        ByteBufferUtils.putUnsignedInt(bb, this.snmpInputOctets);
        bb.putInt(0);
        bb.putInt(0);
        bb.putInt(0);
        bb.putInt(0);
        ByteBufferUtils.putUnsignedInt(bb, this.snmpOutputOctets);
        bb.putInt(0);
        bb.putInt(0);
        bb.putInt(0);
        bb.rewind();
        return bb;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder(50).append("Flow ");
        result.append(this.getInputInterface());
        result.append(":");
        result.append(String.valueOf(this.getSrcIpAddress()));
        result.append(":");
        result.append(this.getSrcPort());
        result.append(" / ");
        result.append(this.getOutputInterface());
        result.append(":");
        result.append(String.valueOf(this.getDstIpAddress()));
        result.append(":");
        result.append(this.getDstPort());
        result.append(" ");
        result.append(this.getOctets());
        result.append(" nextHop: ");
        result.append(IPUtils.convertLongIpToString(this.getNextHop()));
        return result.toString();
    }

    public static class SnmpFlowOutput
    extends SnmpFlowRecord {
        public SnmpFlowOutput(Map<Integer, SnmpFlowRecord> lastSnmp) {
            super(lastSnmp);
        }

        @Override
        public void fillData(ByteBuffer byteBuffer) {
            super.fillData(byteBuffer);
            SnmpFlowRecord snmp = (SnmpFlowRecord)this.lastSnmp.get(this.snmpInterface);
            if (snmp != null) {
                boolean newer = true;
                if (this.snmpSysUptime < snmp.snmpSysUptime && (newer = this.milliseconds > snmp.milliseconds) || this.milliseconds - snmp.milliseconds > this.snmpSysUptime) {
                    logger.debug((Object)"Hardware reset detected");
                    this.octets = this.snmpOutputOctets;
                } else if (newer) {
                    if (this.snmpOutputOctets < snmp.snmpOutputOctets) {
                        if (this.milliseconds > snmp.milliseconds) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)MessageFormat.format("Counter overflow detected,  currentSysUpTime: {0,number,######0}, prevSysUpTime: {1,number,######0}, current: {2,time,yyyy-MM-dd HH:mm:ss}, prev: {3,time,yyyy-MM-dd HH:mm:ss}", this.snmpSysUptime / 10L, snmp.snmpSysUptime / 10L, new Date(this.milliseconds), new Date(snmp.milliseconds)));
                            }
                            if (this.snmpOutputOctets == 0L && FIX_OVERFLOW) {
                                logger.warn((Object)"Counter new value is 0.");
                                this.octets = 0L;
                                this.snmpOutputOctets = snmp.snmpOutputOctets;
                                String key = "ipn.snmp.overflowWithZero";
                                long time = System.currentTimeMillis();
                                if (AlarmSender.needAlarmSend(key, time, 3600000L)) {
                                    AlarmSender.sendAlarm(new AlarmErrorMessage(key, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u0447\u0435\u0442\u0447\u0438\u043a\u0430 snmp", "\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u043e \u043f\u0435\u0440\u0435\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0447\u0438\u043a\u0430 snmp, \u043e\u0434\u043d\u0430\u043a\u043e \u043d\u043e\u0432\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0447\u0438\u043a\u0430 \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430 " + this.snmpInterface + " = 0."), time);
                                }
                            } else {
                                this.octets = 0xFFFFFFFFL + this.snmpOutputOctets - snmp.snmpOutputOctets;
                            }
                        } else {
                            this.octets = 0L;
                        }
                    } else {
                        this.octets = this.snmpOutputOctets - snmp.snmpOutputOctets;
                    }
                } else {
                    this.octets = 0L;
                }
            }
            this.inputInterface = -1;
            this.outputInterface = this.snmpInterface;
        }
    }

    public static class SnmpFlowInput
    extends SnmpFlowRecord {
        public SnmpFlowInput(Map<Integer, SnmpFlowRecord> lastSnmp) {
            super(lastSnmp);
        }

        @Override
        public void fillData(ByteBuffer byteBuffer) {
            super.fillData(byteBuffer);
            SnmpFlowRecord snmp = (SnmpFlowRecord)this.lastSnmp.get(this.snmpInterface);
            if (snmp != null) {
                boolean newer = true;
                if (this.snmpSysUptime < snmp.snmpSysUptime && (newer = this.milliseconds > snmp.milliseconds) || this.milliseconds - snmp.milliseconds > this.snmpSysUptime) {
                    logger.debug((Object)"Hardware reset detected");
                    this.octets = this.snmpInputOctets;
                } else if (newer) {
                    if (this.snmpInputOctets < snmp.snmpInputOctets) {
                        if (this.milliseconds > snmp.milliseconds) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)MessageFormat.format("Counter overflow detected,  currentSysUpTime: {0,number,######0}, prevSysUpTime: {1,number,######0}, current: {2,time,yyyy-MM-dd HH:mm:ss}, prev: {3,time,yyyy-MM-dd HH:mm:ss}", this.snmpSysUptime / 10L, snmp.snmpSysUptime / 10L, new Date(this.milliseconds), new Date(snmp.milliseconds)));
                            }
                            if (this.snmpInputOctets == 0L && FIX_OVERFLOW) {
                                logger.warn((Object)"Counter new value is 0.");
                                this.octets = 0L;
                                this.snmpInputOctets = snmp.snmpInputOctets;
                                String key = "ipn.snmp.overflowWithZero";
                                long time = System.currentTimeMillis();
                                if (AlarmSender.needAlarmSend(key, time, 3600000L)) {
                                    AlarmSender.sendAlarm(new AlarmErrorMessage(key, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u0447\u0435\u0442\u0447\u0438\u043a\u0430 snmp", "\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u043e \u043f\u0435\u0440\u0435\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0447\u0438\u043a\u0430 snmp, \u043e\u0434\u043d\u0430\u043a\u043e \u043d\u043e\u0432\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0447\u0438\u043a\u0430 \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430 " + this.snmpInterface + " = 0."), time);
                                }
                            } else {
                                this.octets = 0xFFFFFFFFL + this.snmpInputOctets - snmp.snmpInputOctets;
                            }
                        } else {
                            this.octets = 0L;
                        }
                    } else {
                        this.octets = this.snmpInputOctets - snmp.snmpInputOctets;
                    }
                } else {
                    this.octets = 0L;
                }
            }
            this.inputInterface = this.snmpInterface;
            this.outputInterface = -1;
        }
    }
}

