/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.radius.nas;

import java.io.Closeable;
import java.io.IOException;
import java.util.Set;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.kernel.network.radius.AccountingSession;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttribute;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttributeSet;
import ru.bitel.bgbilling.kernel.network.radius.RadiusDictionary;
import ru.bitel.bgbilling.kernel.network.radius.nas.Nas;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasList;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;

public class NasConnection<S extends AccountingSession>
implements Closeable {
    private static final Logger logger = Logger.getLogger(NasConnection.class);
    protected final DefaultServerSetup setup;
    protected final NasList<? extends NasConnection<?>, ? extends Nas<? extends NasConnection<?>, ?, ?>> nasList;
    private final int nasId;
    protected final S session;
    private volatile Status status = Status.waiting;
    long lastUpdate;
    private boolean kill = false;
    private volatile RadiusAttributeSet authorizationAttributes = null;

    public NasConnection(S session, DefaultServerSetup setup, NasList<? extends NasConnection<?>, ? extends Nas<? extends NasConnection<?>, ?, ?>> nasList, int nasId) {
        this.session = session;
        this.setup = setup;
        this.nasList = nasList;
        this.nasId = nasId;
    }

    public <N extends Nas<? extends NasConnection<?>, ?, ?>> N getNas() {
        Nas<? extends NasConnection<?>, ?, ?> nas = this.nasList.get(this.nasId);
        if (nas != null) {
            return (N)nas;
        }
        logger.error((Object)("Nas with id=" + this.nasId + " not found!"));
        return null;
    }

    public S getSession() {
        return this.session;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void kill(Nas<?, ?, ?> nas) {
        this.kill = true;
        if (nas.inspector != null) {
            nas.inspector.kill(this);
        }
    }

    public void notKill() {
        this.kill = false;
    }

    public boolean isKill() {
        return this.kill;
    }

    public void addRadiusAttributes(RadiusAttributeSet response, Set<Integer> attrSets, String limitAttribute, String limitValue) {
        RadiusAttribute<?> limitAttr;
        Object nas = this.getNas();
        for (Integer i : attrSets) {
            RadiusAttributeSet set = ((Nas)nas).getAttributeSetMap().get(i);
            if (set == null) continue;
            response.addAttributes(set);
        }
        this.addPersonalRadiusAttributes(response);
        if (limitAttribute != null && (limitAttr = RadiusDictionary.newRadiusAttribute(limitAttribute, limitValue)) != null) {
            response.setAttribute(limitAttr);
        }
    }

    protected void addPersonalRadiusAttributes(RadiusAttributeSet response) {
    }

    @Override
    @Deprecated
    public void close() throws IOException {
        this.kill = true;
        Object nas = this.getNas();
        if (nas != null && ((Nas)nas).inspector != null) {
            ((Nas)nas).inspector.kill(this);
        }
    }

    public void modify(Nas<?, ?, ?> nas, RadiusAttributeSet authorization) throws IOException {
        this.authorizationAttributes = authorization;
        if (nas != null && nas.inspector != null) {
            nas.inspector.modify(this);
        }
    }

    public RadiusAttributeSet getAuthorizationAttributes() {
        return this.authorizationAttributes;
    }

    public static enum Status {
        waiting,
        working,
        suspended,
        stopped;

    }
}

