/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.sms.smsassistent;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.common.Utils;

public class SmsAssistent {
    private static final Logger logger = Logger.getLogger(SmsAssistent.class);
    private String url;
    private String login;
    private String password;
    private String sign;

    public SmsAssistent(String url, String login, String password, String sign) {
        this.url = url;
        this.login = login;
        this.password = password;
        this.sign = sign;
    }

    public int send(String recipient, String message) throws BGException {
        int result;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("\t\t\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438: url = %s; user = %s; recipient = %s; message = %s; sender = %s; validity_period = 48", this.url, this.login, recipient, message, this.sign));
            }
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            nvps.add(new BasicNameValuePair("user", this.login));
            nvps.add(new BasicNameValuePair("password", this.password));
            nvps.add(new BasicNameValuePair("recipient", recipient));
            nvps.add(new BasicNameValuePair("message", message));
            nvps.add(new BasicNameValuePair("sender", this.sign));
            nvps.add(new BasicNameValuePair("validity_period", String.valueOf(48)));
            URIBuilder uriBuilder = new URIBuilder(this.url);
            HttpPost httpPost = new HttpPost(uriBuilder.build());
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, "UTF-8"));
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            try (InputStreamReader inputStreamReader = new InputStreamReader(response.getEntity().getContent());
                 BufferedReader rd = new BufferedReader(inputStreamReader);){
                String line;
                StringBuilder r = new StringBuilder();
                while ((line = rd.readLine()) != null) {
                    r.append(line);
                }
                result = Utils.parseInt(r.toString(), -12);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\t\t\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442: " + result));
            }
        }
        catch (Exception e) {
            throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0435 \u0441\u043c\u0441 \u0447\u0435\u0440\u0435\u0437 \u0441\u0435\u0440\u0432\u0438\u0441 sms-assistent. \u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435: " + e.getMessage(), e);
        }
        return result;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getSign() {
        return this.sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }
}

