/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.snmp;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Calendar;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.common.concurrent.FutureObserver;
import ru.bitel.common.inet.IpAddress;
import uk.co.westhawk.snmp.net.StandardSocket;
import uk.co.westhawk.snmp.pdu.BlockPdu;
import uk.co.westhawk.snmp.pdu.OneGetPdu;
import uk.co.westhawk.snmp.stack.AbstractSnmpContext;
import uk.co.westhawk.snmp.stack.AsnInteger;
import uk.co.westhawk.snmp.stack.AsnNull;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.AsnObjectId;
import uk.co.westhawk.snmp.stack.AsnOctets;
import uk.co.westhawk.snmp.stack.AsnUnsInteger;
import uk.co.westhawk.snmp.stack.AsnUnsInteger64;
import uk.co.westhawk.snmp.stack.GetNextPdu;
import uk.co.westhawk.snmp.stack.Pdu;
import uk.co.westhawk.snmp.stack.PduException;
import uk.co.westhawk.snmp.stack.SetPdu;
import uk.co.westhawk.snmp.stack.SnmpContext;
import uk.co.westhawk.snmp.stack.SnmpContextBasisFace;
import uk.co.westhawk.snmp.stack.SnmpContextv2c;
import uk.co.westhawk.snmp.stack.varbind;

public class SnmpClient {
    private static final Logger logger = Logger.getLogger(SnmpClient.class);
    private int[] retryIntervals = null;
    private SnmpContext snmpContext;
    private boolean destroyed = false;

    public static SnmpContext newSnmpContext(String host, int snmpVersion, String community) throws BGException {
        return SnmpClient.newSnmpContext(host, 161, snmpVersion, community);
    }

    public static SnmpContext newSnmpContext(String host, int port, int snmpVersion, String community) throws BGException {
        try {
            SnmpContext snmpContext;
            switch (snmpVersion) {
                case 1: {
                    snmpContext = new SnmpContext(host, port);
                    break;
                }
                case 2: {
                    snmpContext = new SnmpContextv2c(host, port);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported snmpVersion=" + snmpVersion);
                }
            }
            if (community != null) {
                snmpContext.setCommunity(community);
            } else {
                snmpContext.setCommunity("public");
            }
            return snmpContext;
        }
        catch (IOException ex) {
            throw new BGException(ex);
        }
    }

    public static final void setBufferSizes(SnmpContext context, int receiveBufferSize, int sendBufferSize) {
        try {
            Field field = AbstractSnmpContext.class.getDeclaredField("soc");
            field.setAccessible(true);
            StandardSocket socket = (StandardSocket)field.get(context);
            field = StandardSocket.class.getDeclaredField("soc");
            field.setAccessible(true);
            DatagramSocket dSocket = (DatagramSocket)field.get(socket);
            dSocket.setReceiveBufferSize(receiveBufferSize);
            dSocket.setSendBufferSize(sendBufferSize);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public SnmpClient(String host, int snmpVersion, String community) throws BGException {
        this(host, 161, snmpVersion, community);
    }

    public SnmpClient(String host, int port, int snmpVersion, String community) throws BGException {
        this.snmpContext = SnmpClient.newSnmpContext(host, port, snmpVersion, community);
    }

    public void setBufferSizes(int receiveBufferSize, int sendBufferSize) {
        if (this.snmpContext != null) {
            SnmpClient.setBufferSizes(this.snmpContext, receiveBufferSize, sendBufferSize);
        }
    }

    public void destroy() {
        this.destroyed = true;
        this.snmpContext.destroy();
        this.snmpContext = null;
    }

    protected void finalize() throws Throwable {
        if (!this.destroyed) {
            logger.warn((Object)"SnmpSupport was not destroyed before finalize!");
            this.destroy();
        }
        super.finalize();
    }

    public SnmpContext getSnmpContext() {
        return this.snmpContext;
    }

    private AsnObject convertToAsn(Object value) {
        if (value instanceof AsnObject) {
            return (AsnObject)value;
        }
        if (value instanceof Integer) {
            return new AsnInteger(((Integer)value).intValue());
        }
        if (value instanceof Long) {
            return new AsnUnsInteger(((Long)value).longValue());
        }
        if (value instanceof byte[]) {
            return new AsnOctets((byte[])value);
        }
        if (value instanceof String) {
            try {
                return new AsnOctets(((String)value).getBytes("UTF-8"));
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
        if (value == null) {
            return new AsnNull();
        }
        throw new IllegalArgumentException("Unknown type - " + value.getClass() + " " + value);
    }

    private <K> K convertFromAsn(AsnObject value, Class<K> clazz) {
        Object result;
        if (value instanceof AsnInteger) {
            result = ((AsnInteger)value).getValue();
        } else if (value instanceof AsnUnsInteger) {
            result = ((AsnUnsInteger)value).getValue();
        } else if (value instanceof AsnUnsInteger64) {
            result = ((AsnUnsInteger64)value).getValue();
        } else if (value instanceof AsnOctets) {
            result = clazz == String.class ? ((AsnOctets)value).getValue() : (clazz == Calendar.class ? ((AsnOctets)value).getCalendar() : (clazz == InetAddress.class ? ((AsnOctets)value).getIpAddress() : (clazz == IpAddress.class ? new IpAddress(((AsnOctets)value).getBytes()) : (Object)((AsnOctets)value).getBytes())));
        } else {
            if (value instanceof AsnNull) {
                return null;
            }
            if (value instanceof AsnObject) {
                result = value;
            } else {
                throw new IllegalArgumentException("Unknown type - " + value);
            }
        }
        if (String.class.equals(clazz)) {
            return clazz.cast(String.valueOf(result));
        }
        return clazz.cast(result);
    }

    private void addOid(BlockPdu pdu, long[] oid, long subOid, Object value) {
        AsnObjectId objectId = new AsnObjectId(oid);
        if (subOid != -1L) {
            objectId.add(subOid);
        }
        pdu.addOid(objectId, this.convertToAsn(value));
    }

    private void addOid(BlockPdu pdu, long[] oid, long subOid) {
        AsnObjectId objectId = new AsnObjectId(oid);
        if (subOid != -1L) {
            objectId.add(subOid);
        }
        pdu.addOid(objectId);
    }

    private void addOid(Pdu pdu, long[] oid, long subOid, Object value) {
        AsnObjectId objectId = new AsnObjectId(oid);
        if (subOid != -1L) {
            objectId.add(subOid);
        }
        pdu.addOid(objectId, this.convertToAsn(value));
    }

    private void addOid(Pdu pdu, long[] oid, long subOid) {
        AsnObjectId objectId = new AsnObjectId(oid);
        if (subOid != -1L) {
            objectId.add(subOid);
        }
        pdu.addOid(objectId);
    }

    public boolean set(long[] oid, long subOid, Object value) throws IOException, PduException {
        BlockPdu pdu = new BlockPdu((SnmpContextBasisFace)this.snmpContext);
        if (this.retryIntervals != null) {
            pdu.setRetryIntervals(this.retryIntervals);
        }
        pdu.setPduType(1);
        this.addOid(pdu, oid, subOid, value);
        varbind varbind2 = pdu.getResponseVariableBinding();
        if (pdu.getErrorStatus() == 0) {
            logger.info((Object)("Ok: " + pdu));
            return true;
        }
        logger.error((Object)("PDU set error: " + varbind2));
        return false;
    }

    public boolean set(String oid, Object value) throws IOException, PduException {
        BlockPdu pdu = new BlockPdu((SnmpContextBasisFace)this.snmpContext);
        if (this.retryIntervals != null) {
            pdu.setRetryIntervals(this.retryIntervals);
        }
        pdu.setPduType(1);
        AsnObjectId objectId = new AsnObjectId(oid);
        pdu.addOid(objectId, this.convertToAsn(value));
        varbind varbind2 = pdu.getResponseVariableBinding();
        if (pdu.getErrorStatus() == 0) {
            logger.info((Object)("Ok: " + pdu));
            return true;
        }
        logger.error((Object)("PDU set error: " + varbind2));
        return false;
    }

    public boolean set(Map<String, Object> values) throws IOException, PduException {
        BlockPdu pdu = new BlockPdu((SnmpContextBasisFace)this.snmpContext);
        if (this.retryIntervals != null) {
            pdu.setRetryIntervals(this.retryIntervals);
        }
        pdu.setPduType(1);
        for (Map.Entry<String, Object> e : values.entrySet()) {
            AsnObjectId objectId = new AsnObjectId(e.getKey());
            pdu.addOid(objectId, this.convertToAsn(e.getValue()));
        }
        varbind varbind2 = pdu.getResponseVariableBinding();
        if (pdu.getErrorStatus() == 0) {
            logger.info((Object)("Ok: " + pdu));
            return true;
        }
        logger.error((Object)("PDU set error: " + varbind2));
        return false;
    }

    public void setAsync(long[] oid, long subOid, Object value, Observer observer) throws BGException {
        SetPdu pdu = new SetPdu((SnmpContextBasisFace)this.snmpContext);
        if (this.retryIntervals != null) {
            pdu.setRetryIntervals(this.retryIntervals);
        }
        this.addOid((Pdu)pdu, oid, subOid, value);
        pdu.addObserver(observer);
        try {
            pdu.send();
        }
        catch (Exception e) {
            throw new BGException(e);
        }
    }

    public Future<Boolean> setAsync(long[] oid, long subOid, Object value) throws BGException {
        SnmpFutureSetObserver result = new SnmpFutureSetObserver();
        this.setAsync(oid, subOid, value, result);
        return result;
    }

    public boolean set(long[] oid1, long subOid1, Object value1, long[] oid2, long subOid2, Object value2) throws IOException, PduException {
        BlockPdu pdu = new BlockPdu((SnmpContextBasisFace)this.snmpContext);
        if (this.retryIntervals != null) {
            pdu.setRetryIntervals(this.retryIntervals);
        }
        pdu.setPduType(1);
        this.addOid(pdu, oid1, subOid1, value1);
        this.addOid(pdu, oid2, subOid2, value2);
        varbind varbind2 = pdu.getResponseVariableBinding();
        if (pdu.getErrorStatus() == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Ok: " + pdu));
            }
            return true;
        }
        logger.error((Object)("PDU set error: " + varbind2));
        return false;
    }

    public void setAsync(long[] oid1, long subOid1, Object value1, long[] oid2, long subOid2, Object value2, Observer observer) throws BGException {
        SetPdu pdu = new SetPdu((SnmpContextBasisFace)this.snmpContext);
        if (this.retryIntervals != null) {
            pdu.setRetryIntervals(this.retryIntervals);
        }
        this.addOid((Pdu)pdu, oid1, subOid1, value1);
        this.addOid((Pdu)pdu, oid2, subOid2, value2);
        pdu.addObserver(observer);
        try {
            pdu.send();
        }
        catch (Exception e) {
            throw new BGException(e);
        }
    }

    public Future<Boolean> setAsync(long[] oid1, long subOid1, Object value1, long[] oid2, long subOid2, Object value2) throws BGException {
        SnmpFutureSetObserver result = new SnmpFutureSetObserver();
        this.setAsync(oid1, subOid1, value1, oid2, subOid2, value2, result);
        return result;
    }

    public <V> V get(long[] oid, long subOid, Class<V> clazz) throws BGException {
        varbind varbind2;
        BlockPdu pdu = new BlockPdu((SnmpContextBasisFace)this.snmpContext);
        if (this.retryIntervals != null) {
            pdu.setRetryIntervals(this.retryIntervals);
        }
        pdu.setPduType(0);
        this.addOid(pdu, oid, subOid);
        try {
            varbind2 = pdu.getResponseVariableBinding();
        }
        catch (Exception e) {
            throw new BGException(e);
        }
        if (pdu.getErrorStatus() == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Ok: " + pdu));
            }
            return this.convertFromAsn(varbind2.getValue(), clazz);
        }
        logger.error((Object)("PDU get error: " + varbind2));
        throw new BGException("PDU get error=" + pdu.getErrorStatusString() + ": " + varbind2);
    }

    public <V> V get(String oid, Class<V> clazz) throws BGException {
        varbind varbind2;
        BlockPdu pdu = new BlockPdu((SnmpContextBasisFace)this.snmpContext);
        if (this.retryIntervals != null) {
            pdu.setRetryIntervals(this.retryIntervals);
        }
        pdu.setPduType(0);
        AsnObjectId objectId = new AsnObjectId(oid);
        pdu.addOid(objectId);
        try {
            varbind2 = pdu.getResponseVariableBinding();
        }
        catch (Exception e) {
            throw new BGException(e);
        }
        if (pdu.getErrorStatus() == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Ok: " + pdu));
            }
            return this.convertFromAsn(varbind2.getValue(), clazz);
        }
        logger.error((Object)("PDU get error: " + varbind2));
        throw new BGException("PDU get error=" + pdu.getErrorStatusString() + ": " + varbind2);
    }

    public void getAsync(long[] oid, long subOid, Observer observer) throws BGException {
        OneGetPdu pdu = new OneGetPdu((SnmpContextBasisFace)this.snmpContext);
        if (this.retryIntervals != null) {
            pdu.setRetryIntervals(this.retryIntervals);
        }
        this.addOid((Pdu)pdu, oid, subOid);
        pdu.addObserver(observer);
        try {
            pdu.send();
        }
        catch (Exception e) {
            throw new BGException(e);
        }
    }

    public <V> Future<V> getAsync(long[] oid, long subOid, Class<V> clazz) throws BGException {
        SnmpFutureGetObserver<V> result = new SnmpFutureGetObserver<V>(clazz);
        this.getAsync(oid, subOid, result);
        return result;
    }

    public int[] getRetryIntervals() {
        return this.retryIntervals;
    }

    public void setRetryIntervals(int[] retryIntervals) {
        this.retryIntervals = retryIntervals;
    }

    public <U> void walk(long[] oid, Class<U> clazz, BiConsumer<long[], U> consumer) throws BGException {
        AsnObjectId start = new AsnObjectId(oid);
        boolean finished = false;
        while (!finished) {
            varbind[] response;
            varbind vb = null;
            GetNextPdu pdu = new GetNextPdu((SnmpContextBasisFace)this.snmpContext);
            if (this.retryIntervals != null) {
                pdu.setRetryIntervals(this.retryIntervals);
            }
            pdu.addOid(new AsnObjectId(oid));
            try {
                SnmpFutureGetNextObserver<U> observer = new SnmpFutureGetNextObserver<U>(clazz);
                pdu.addObserver(observer);
                pdu.send();
                observer.get();
                response = pdu.getResponseVarbinds();
            }
            catch (Exception e) {
                throw new BGException(e);
            }
            if (response != null) {
                vb = response[0];
            }
            if (response == null) {
                finished = true;
                continue;
            }
            if (pdu.getErrorStatus() != 0) {
                throw new BGException(pdu.getErrorStatusString());
            }
            if (vb.getOid() == null) {
                finished = true;
                continue;
            }
            if (vb.getOid().getSize() < oid.length) {
                finished = true;
                continue;
            }
            if (!vb.getOid().startsWith(start)) {
                finished = true;
                continue;
            }
            oid = vb.getOid().getOid();
            U u = this.convertFromAsn(vb.getValue(), clazz);
            consumer.accept(oid, u);
        }
    }

    public static long[] oidFromString(String oid) {
        return new AsnObjectId(oid).getOid();
    }

    public static String oidToString(long[] oid) {
        return new AsnObjectId(oid).toString();
    }

    public static void main(String[] args) throws BGException, InterruptedException, ExecutionException {
        SnmpClient snmpClient = new SnmpClient("192.168.184.100", 1, "public");
        System.out.println(snmpClient.getAsync(SnmpClient.oidFromString("1.3.6.1.2.1.43.15.1.1.10.1.1"), -1L, String.class).get());
        snmpClient.walk(SnmpClient.oidFromString("1.3.6.1.2.1.43.15.1.1.10.1"), String.class, (o, v) -> System.out.println(new AsnObjectId(o) + " = " + v));
    }

    class SnmpFutureGetNextObserver<V>
    extends FutureObserver<V> {
        private final Class<V> clazz;
        private volatile AsnObjectId oid;
        private volatile Pdu pdu;

        SnmpFutureGetNextObserver(Class<V> clazz) {
            this.clazz = clazz;
        }

        @Override
        protected V updateImpl(Observable obs, Object varbind2) {
            Pdu pdu = (Pdu)obs;
            if (pdu.getErrorStatus() == 0) {
                varbind resultVarbind;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Ok: " + pdu));
                }
                try {
                    resultVarbind = pdu.getResponseVarbinds()[0];
                }
                catch (PduException e) {
                    throw new IllegalStateException(e);
                }
                this.pdu = pdu;
                this.oid = resultVarbind.getOid();
                return (V)SnmpClient.this.convertFromAsn(resultVarbind.getValue(), this.clazz);
            }
            logger.error((Object)("PDU get error: " + varbind2));
            throw new IllegalStateException("PDU get error=" + pdu.getErrorStatusString() + ": " + varbind2);
        }

        public AsnObjectId getOid() {
            return this.oid;
        }

        public Pdu getPdu() {
            return this.pdu;
        }
    }

    class SnmpFutureGetObserver<V>
    extends FutureObserver<V> {
        private final Class<V> clazz;

        SnmpFutureGetObserver(Class<V> clazz) {
            this.clazz = clazz;
        }

        @Override
        protected V updateImpl(Observable obs, Object varbind2) {
            Pdu pdu = (Pdu)obs;
            if (pdu.getErrorStatus() == 0) {
                varbind resultVarbind;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Ok: " + pdu));
                }
                try {
                    resultVarbind = pdu.getResponseVarbinds()[0];
                }
                catch (PduException e) {
                    throw new IllegalStateException(e);
                }
                return (V)SnmpClient.this.convertFromAsn(resultVarbind.getValue(), this.clazz);
            }
            logger.error((Object)("PDU get error: " + varbind2));
            throw new IllegalStateException("PDU get error=" + pdu.getErrorStatusString() + ": " + varbind2);
        }
    }

    class SnmpFutureSetObserver
    extends FutureObserver<Boolean> {
        SnmpFutureSetObserver() {
        }

        @Override
        protected Boolean updateImpl(Observable obs, Object varbind2) {
            Pdu pdu = (Pdu)obs;
            if (pdu.getErrorStatus() == 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Ok: " + pdu));
                }
                return true;
            }
            logger.error((Object)("PDU set error: " + varbind2));
            return false;
        }
    }
}

