/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.script.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.script.common.bean.EventScriptLink;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractIdDao;

public class EventScriptLinkDao
extends AbstractIdDao<EventScriptLink> {
    public EventScriptLinkDao(Connection con) {
        super(con, 0, "event_script_link");
    }

    @Override
    protected EventScriptLink getFromRS(ResultSet rs) throws SQLException, BGException {
        EventScriptLink link = new EventScriptLink();
        link.setClassName(rs.getString("class_name"));
        link.setEventKey(rs.getString("event_key"));
        link.setId(rs.getInt("id"));
        link.setScriptId(rs.getInt("script_id"));
        link.setTitle(rs.getString("title"));
        return link;
    }

    @Override
    protected void updateImpl(EventScriptLink b2) throws BGException, SQLException {
        PreparedStatement ps = null;
        if (b2.getId() <= 0) {
            String query = "INSERT INTO event_script_link(class_name, event_key, script_id, title) VALUES(?,?,?,?)";
            ps = this.con.prepareStatement(query, 1);
        } else {
            String query = "UPDATE event_script_link SET class_name=?, event_key=?, script_id=?, title=? WHERE id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(5, b2.getId());
        }
        ps.setString(1, b2.getClassName());
        ps.setString(2, b2.getEventKey());
        ps.setInt(3, b2.getScriptId());
        ps.setString(4, b2.getTitle());
        ps.executeUpdate();
        if (b2.getId() <= 0) {
            b2.setId(ServerUtils.lastInsertId(ps));
        }
        ps.close();
    }

    public List<EventScriptLink> getScriptLinkListByScript(int scriptId) throws BGException {
        return this.list("script_id=?", "title", scriptId);
    }

    public List<EventScriptLink> getScriptLinkList() throws BGException {
        return this.list("", "title", new Object[0]);
    }
}

