/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.tree.server;

import bitel.billing.server.contract.bean.ContractTariff;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.tariff.tree.server.TariffModuleTree;
import ru.bitel.bgbilling.kernel.tariff.tree.server.TariffModuleTreeSet;
import ru.bitel.bgbilling.kernel.tariff.tree.server.TariffTreeCache;
import ru.bitel.common.TimeUtils;

public class TariffModuleTreeSetDao
implements AutoCloseable {
    private static final Logger log = Logger.getLogger(TariffModuleTreeSetDao.class);
    private final Connection con;
    private PreparedStatement dayTariffPS = null;
    private PreparedStatement dayPersonalTariffPS = null;
    private PreparedStatement realtimeTariffPS = null;
    private PreparedStatement realtimePersonalTariffPS = null;

    public TariffModuleTreeSetDao(Connection con) {
        this.con = con;
    }

    public TariffModuleTreeSet getRealtimeTariffTreeSet(int cid, java.util.Date time, String module, int mid, int emid, int eid) throws BGException {
        ArrayList<TariffModuleTreeSet.Entry> result = new ArrayList<TariffModuleTreeSet.Entry>(8);
        try {
            Date sqlTime = TimeUtils.convertDateToSqlDate(time);
            GregorianCalendar utilCalendar = new GregorianCalendar();
            PreparedStatement ps = this.realtimePersonalTariffPS;
            if (ps == null) {
                ps = this.realtimePersonalTariffPS = this.con.prepareStatement("SELECT tree_id, date1, date2 FROM contract_tree_link WHERE cid=? AND ((emid=0 AND eid=0) OR (emid=? AND eid=?)) AND (date2 IS NULL OR date2>=?) ORDER BY emid DESC, eid DESC, pos ASC");
            }
            ps.setInt(1, cid);
            ps.setInt(2, emid);
            ps.setInt(3, eid);
            ps.setDate(4, sqlTime);
            this.loadTreeEntries(module, mid, result, utilCalendar, ps);
            ps = this.realtimeTariffPS;
            if (ps == null) {
                ps = this.realtimeTariffPS = this.con.prepareStatement("SELECT tree_id, date1, date2 FROM contract_tariff INNER JOIN tariff_plan ON contract_tariff.tpid=tariff_plan.id WHERE cid=? AND ((emid=0 AND eid=0) OR (emid=? AND eid=?)) AND ( isNull(date2) OR date2='0000-00-00' OR date2>=? ) ORDER BY emid DESC, eid DESC, pos ASC");
            }
            ps.setInt(1, cid);
            ps.setInt(2, emid);
            ps.setInt(3, eid);
            ps.setDate(4, sqlTime);
            this.loadTreeEntries(module, mid, result, utilCalendar, ps);
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
        return new TariffModuleTreeSet(result);
    }

    public TariffModuleTreeSet getRealtimeTariffTreeSet(String module, int mid, List<ContractTariff> tariffList) throws BGException {
        ArrayList<TariffModuleTreeSet.Entry> result = new ArrayList<TariffModuleTreeSet.Entry>(8);
        try {
            if (tariffList.size() > 0) {
                HashMap<Integer, Integer> tariffTreeMap = new HashMap<Integer, Integer>();
                StringBuilder tariffIds = new StringBuilder(20);
                for (ContractTariff tariff : tariffList) {
                    if (tariffIds.length() > 0) {
                        tariffIds.append(",");
                    }
                    tariffIds.append(tariff.getTariffPlanId());
                }
                String query = "SELECT id, tree_id FROM tariff_plan WHERE id IN(" + tariffIds.toString() + ")";
                PreparedStatement ps = this.con.prepareStatement(query);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    tariffTreeMap.put(rs.getInt(1), rs.getInt(2));
                }
                ps.close();
                TariffTreeCache tariffTreeBuilder = TariffTreeCache.getInstance();
                GregorianCalendar utilCalendar = new GregorianCalendar();
                for (ContractTariff tariff : tariffList) {
                    AtomicReference<TariffModuleTree> treeRef;
                    Integer treeId = (Integer)tariffTreeMap.get(tariff.getTariffPlanId());
                    if (treeId == null) {
                        log.error((Object)("Not found treeId for tariff: " + tariff.getTariffPlanId()));
                    }
                    if ((treeRef = tariffTreeBuilder.getModuleTree(this.con, treeId, mid, module)) == null) continue;
                    result.add(new TariffModuleTreeSet.Entry(treeRef, TimeUtils.convertDateToMillisFrom(utilCalendar, TimeUtils.convertCalendarToDate(tariff.getDate1())), TimeUtils.convertDateToMillisTo(utilCalendar, TimeUtils.convertCalendarToDate(tariff.getDate2()))));
                }
            }
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
        return new TariffModuleTreeSet(result);
    }

    @Deprecated
    public TariffModuleTreeSet getTariffTreeSetForDay(int contractId, Calendar time, String module, int moduleId, int emid, int eid) throws BGException {
        LocalDate localDate = LocalDateTime.ofInstant(time.toInstant(), time.getTimeZone().toZoneId()).toLocalDate();
        return this.getTariffTreeSetForDay(contractId, localDate, module, moduleId, emid, eid);
    }

    public TariffModuleTreeSet getTariffTreeSetForDay(int contractId, LocalDate time, String module, int moduleId, int emid, int eid) throws BGException {
        ArrayList<TariffModuleTreeSet.Entry> result = new ArrayList<TariffModuleTreeSet.Entry>(8);
        try {
            Date day = TimeUtils.convertLocalDateToSqlDate(time);
            GregorianCalendar utilCalendar = new GregorianCalendar();
            PreparedStatement ps = this.dayPersonalTariffPS;
            if (ps == null) {
                ps = this.dayPersonalTariffPS = this.con.prepareStatement("SELECT tree_id, date1, date2 FROM contract_tree_link WHERE cid=? AND ((emid=0 AND eid=0) OR (emid=? AND eid=?))  AND (date1 IS NULL OR date1<=?) AND (date2 IS NULL OR date2>=?) ORDER BY emid DESC, eid DESC, pos ASC");
            }
            ps.setInt(1, contractId);
            ps.setInt(2, emid);
            ps.setInt(3, eid);
            ps.setDate(4, day);
            ps.setDate(5, day);
            this.loadTreeEntries(module, moduleId, result, utilCalendar, ps);
            ps = this.dayTariffPS;
            if (ps == null) {
                ps = this.dayTariffPS = this.con.prepareStatement("SELECT tree_id, date1, date2 FROM contract_tariff INNER JOIN tariff_plan ON contract_tariff.tpid=tariff_plan.id WHERE cid=? AND ((emid=0 AND eid=0) OR (emid=? AND eid=?)) AND ( isNull(date1) OR date1='0000-00-00' OR date1<=? ) AND ( isNull(date2) OR date2='0000-00-00' OR date2>=? ) ORDER BY emid DESC, eid DESC, pos ASC");
            }
            ps.setInt(1, contractId);
            ps.setInt(2, emid);
            ps.setInt(3, eid);
            ps.setDate(4, day);
            ps.setDate(5, day);
            this.loadTreeEntries(module, moduleId, result, utilCalendar, ps);
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
        return new TariffModuleTreeSet(result);
    }

    private void loadTreeEntries(String module, int mid, List<TariffModuleTreeSet.Entry> result, Calendar utilCalendar, PreparedStatement ps) throws SQLException {
        TariffTreeCache tariffTreeBuilder = TariffTreeCache.getInstance();
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            int treeId = rs.getInt(1);
            Date dateFrom = rs.getDate(2);
            Date dateTo = rs.getDate(3);
            AtomicReference<TariffModuleTree> treeRef = tariffTreeBuilder.getModuleTree(this.con, treeId, mid, module);
            if (treeRef == null) continue;
            result.add(new TariffModuleTreeSet.Entry(treeRef, TimeUtils.convertDateToMillisFrom(utilCalendar, dateFrom), TimeUtils.convertDateToMillisTo(utilCalendar, dateTo)));
        }
        rs.close();
    }

    public void freeResources() throws BGException {
        try {
            if (this.check(this.realtimePersonalTariffPS)) {
                this.realtimePersonalTariffPS.close();
            }
            if (this.check(this.realtimeTariffPS)) {
                this.realtimeTariffPS.close();
            }
            if (this.check(this.dayPersonalTariffPS)) {
                this.dayPersonalTariffPS.close();
            }
            if (this.check(this.dayTariffPS)) {
                this.dayTariffPS.close();
            }
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    private boolean check(PreparedStatement ps) throws SQLException {
        return ps != null && !ps.isClosed();
    }

    @Override
    public void close() throws BGException {
        this.freeResources();
    }
}

