/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.tree.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.kernel.tariff.tree.server.AbstractTariffRequest;
import ru.bitel.bgbilling.kernel.tariff.tree.server.TariffContext;
import ru.bitel.bgbilling.kernel.tariff.tree.server.TariffTreeNodeHolder;
import ru.bitel.bgbilling.kernel.tariff.tree.server.TreeContext;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.worker.ThreadContext;

public abstract class TariffTreeNode<R extends AbstractTariffRequest<?>, C extends TariffContext, T extends TreeContext, W extends ThreadContext> {
    protected final Logger logger = Logger.getLogger(this.getClass());
    public static final int RESULT_CANCEL = 0;
    public static final int RESULT_OK = 1;
    protected final String fingerprint;
    protected final int id;
    private static final Comparator<Map.Entry<String, String>> fingerprintComparator = new Comparator<Map.Entry<String, String>>(){

        @Override
        public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
            return o1.getKey().compareTo(o2.getKey());
        }
    };

    public TariffTreeNode(int id, ParameterMap parameterMap) {
        this.id = id;
        StringBuilder result = new StringBuilder(100);
        result.append(this.getClass().getName()).append(':').append(id);
        ArrayList<Map.Entry<String, String>> entryList = new ArrayList<Map.Entry<String, String>>(parameterMap.entrySet());
        Collections.sort(entryList, fingerprintComparator);
        int size = entryList.size();
        for (int i = 0; i < size; ++i) {
            Map.Entry entry = (Map.Entry)entryList.get(i);
            result.append(" {").append((String)entry.getKey()).append("}=[").append((String)entry.getValue()).append("];");
        }
        this.fingerprint = result.toString();
    }

    public int hashCode() {
        return this.fingerprint.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TariffTreeNode other = (TariffTreeNode)obj;
        return this.fingerprint.equals(other.fingerprint);
    }

    public void executeChildren(Long treeNodeId, AbstractTariffRequest<?> req, TariffTreeNodeHolder holder, C ctx, T treeContext, W workerContext) {
        TariffTreeNodeHolder[] children = holder.children;
        if (children != null) {
            int size = children.length;
            for (int i = 0; i < size; ++i) {
                children[i].execute(treeNodeId, req, (TariffContext)ctx, (TreeContext)treeContext, (ThreadContext)workerContext);
            }
        }
    }

    public int execute(Long treeNodeId, Long parentTreeNodeId, R req, TariffTreeNodeHolder holder, C ctx, T treeContext, W workerContext) {
        int result = this.executeImpl(treeNodeId, parentTreeNodeId, req, ctx, treeContext, workerContext);
        if (result == 1) {
            this.executeChildren(treeNodeId, (AbstractTariffRequest<?>)req, holder, ctx, treeContext, workerContext);
        }
        return this.postExecute(treeNodeId, parentTreeNodeId, req, holder, ctx, treeContext, workerContext, result);
    }

    public int postExecute(Long treeNodeId, Long parentTreeNodeId, R req, TariffTreeNodeHolder holder, C context, T treeContext, W workerContext, int executeResult) {
        return this.postExecuteImpl(treeNodeId, parentTreeNodeId, req, context, treeContext, workerContext, executeResult);
    }

    protected abstract int executeImpl(Long var1, Long var2, R var3, C var4, T var5, W var6);

    protected int postExecuteImpl(Long treeNodeId, Long parentTreeNodeId, R req, C context, T treeContext, W workerContext, int executeResult) {
        return executeResult;
    }

    protected final long getServiceAmount(int type, long col) {
        long divisor;
        switch (type) {
            case 0: {
                divisor = col;
                break;
            }
            case 1: {
                divisor = col * 1024L;
                break;
            }
            case 2: {
                divisor = col * 0x100000L;
                break;
            }
            case 3: {
                divisor = col * 0x40000000L;
                break;
            }
            case 4: {
                divisor = col;
                break;
            }
            case 5: {
                divisor = col * 60L;
                break;
            }
            case 6: {
                divisor = col * 3600L;
                break;
            }
            default: {
                divisor = 0L;
            }
        }
        return divisor;
    }
}

