/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.task.server.bean;

import java.util.Calendar;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.kernel.task.common.bean.LightweightTaskData;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;

public class TaskData
extends LightweightTaskData {
    private static final Logger log = Logger.getLogger(TaskData.class);
    private TaskBase task;
    private TaskBase dependTask;

    public TaskData(int month, int day, int hour, int dayOfWeek, long min) {
        super(month, day, hour, dayOfWeek, min);
    }

    public TaskBase getTask() {
        return this.task;
    }

    public TaskBase getDependTask() {
        return this.dependTask;
    }

    public void initTask(Calendar time, Setup setup) {
        try {
            this.task = (TaskBase)Class.forName(this.getClassName()).newInstance();
            if (this.task != null) {
                this.task.setExecutingTime((Calendar)time.clone());
                this.task.setModuleId(this.getModuleId());
                this.task.initTask(setup, this.getId(), this.getParams());
            }
        }
        catch (Exception ex) {
            log.error((Object)("error init task #" + this.getId() + " (" + this.getClassName() + ")"), (Throwable)ex);
        }
    }

    public boolean canWork(Calendar time) {
        return TimeUtils.checkMasks(time, this.hour, this.dayOfWeek, this.month, this.day) && (this.min == 0L || (this.min & 1L << time.get(12)) > 0L);
    }
}

