/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.bootstrap;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class BootstrapClassLoader
extends URLClassLoader {
    private static final FileFilter jarFilter = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.isFile() && pathname.getName().endsWith(".jar");
        }
    };
    private static final FileFilter folderFilter = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    };

    public BootstrapClassLoader(String path, URL[] urls, ClassLoader parent) {
        super(BootstrapClassLoader.getURLsForLoad(path, urls), parent);
    }

    private static URL[] getURLsForLoad(String path, URL[] urls) {
        int i;
        URL[] jars = BootstrapClassLoader.getJars(new File(path), true);
        HashSet<URL> urlList = new HashSet<URL>();
        HashSet<URL> loaded = new HashSet<URL>();
        ClassLoader system = BootstrapClassLoader.getSystemClassLoader();
        if (system instanceof URLClassLoader) {
            URLClassLoader l = (URLClassLoader)system;
            loaded.addAll(Arrays.asList(l.getURLs()));
        }
        for (i = 0; i < jars.length; ++i) {
            if (loaded.contains(jars[i])) continue;
            urlList.add(jars[i]);
        }
        for (i = 0; i < urls.length; ++i) {
            if (loaded.contains(urls[i])) continue;
            urlList.add(urls[i]);
        }
        URL[] all = new URL[urlList.size()];
        all = urlList.toArray(all);
        return all;
    }

    private static void getJarsRecursively(List<File> jars, File currentPath) {
        for (File path : currentPath.listFiles(folderFilter)) {
            Collections.addAll(jars, path.listFiles(jarFilter));
        }
    }

    public static URL[] getJars(File path, boolean withInnerFolders) {
        if (jarFilter.accept(path)) {
            try {
                return new URL[]{path.toURI().toURL()};
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                return new URL[0];
            }
        }
        if (path.isDirectory()) {
            ArrayList<File> jars = new ArrayList<File>();
            Collections.addAll(jars, path.listFiles(jarFilter));
            if (withInnerFolders) {
                BootstrapClassLoader.getJarsRecursively(jars, path);
            }
            ArrayList<URL> urlList = new ArrayList<URL>();
            for (File f : jars) {
                try {
                    urlList.add(f.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
            URL[] urls = new URL[urlList.size()];
            return urlList.toArray(urls);
        }
        throw new IllegalArgumentException("Unknown path to jars!");
    }
}

