/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.logging;

import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;

public class Log4JMDCFilter
extends Filter {
    protected String key;
    protected String value = "";
    protected Set<String> filterSet;

    public int decide(LoggingEvent e) {
        Object o = e.getMDC(this.key);
        if (o != null) {
            String val = o.toString();
            if (val == null || this.value.equals(val) || this.filterSet.contains(val) || e.getLoggerName().equals(this.value)) {
                return 0;
            }
            return -1;
        }
        return 0;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.filterSet = new HashSet<String>();
        if (value != null) {
            for (String filter : value.split("\\s*[\\s,;]\\s*")) {
                this.filterSet.add(filter.intern());
            }
        }
        this.value = value != null ? value.intern() : "";
    }
}

