/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.logging;

import java.util.Deque;
import java.util.LinkedList;
import org.apache.log4j.MDC;
import ru.bitel.common.logging.Log4j;

public class NestedContext {
    public static final String KEY = "nestedContext";
    static final InheritableThreadLocal<Deque<String>> nestedContext;
    static final ThreadLocal<Deque<String>> nestedContextWrapper;

    public static void push(String name) {
        nestedContextWrapper.get().offer(name);
    }

    public static void pop() {
        nestedContextWrapper.get().pollLast();
    }

    public static String get() {
        return nestedContextWrapper.get().peekLast();
    }

    static {
        Log4j.init();
        nestedContext = new InheritableThreadLocal<Deque<String>>(){

            @Override
            protected Deque<String> initialValue() {
                LinkedList<String> result = new LinkedList<String>(){

                    @Override
                    public String toString() {
                        return (String)this.peekLast();
                    }
                };
                return result;
            }

            @Override
            public final Deque<String> childValue(Deque<String> parentValue) {
                if (parentValue != null) {
                    return new LinkedList<String>(parentValue){

                        @Override
                        public String toString() {
                            return (String)this.peekLast();
                        }
                    };
                }
                return null;
            }
        };
        nestedContextWrapper = new ThreadLocal<Deque<String>>(){

            @Override
            protected Deque<String> initialValue() {
                Deque result = (Deque)nestedContext.get();
                MDC.put((String)NestedContext.KEY, (Object)result);
                return result;
            }
        };
    }
}

