/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.model;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import javax.xml.bind.annotation.XmlAttribute;
import ru.bitel.common.TimeUtils;

public class Period
implements Comparable<Period> {
    private Date dateFrom;
    private LocalDate localDateFrom;
    private Date dateTo;
    private LocalDate localDateTo;

    public Period() {
    }

    public Period(Date fromDate, Date toDate) {
        this.setDateFrom(fromDate);
        this.setDateTo(toDate);
    }

    public Period(LocalDate localDateFrom, LocalDate localDateTo) {
        this.setLocalDateFrom(localDateFrom);
        this.setLocalDateTo(localDateTo);
    }

    public Period(long startEpoch, long stopEpoch) {
        this.setLocalDateFrom(TimeUtils.convertSecEpochToLocalDateTime(startEpoch).toLocalDate());
        this.setLocalDateTo(TimeUtils.convertSecEpochToLocalDateTime(stopEpoch).toLocalDate());
    }

    public Period(int year, int month, int dayFrom, int dayTo) {
        LocalDate localDate = LocalDate.of(year, month + 1, 1);
        int maxday = localDate.lengthOfMonth();
        this.setLocalDateFrom(localDate.withDayOfMonth(dayFrom < 1 ? 1 : (dayFrom > maxday ? maxday : dayFrom)));
        this.setLocalDateTo(localDate.withDayOfMonth(dayTo < 1 ? 1 : (dayTo > maxday ? maxday : dayTo)));
    }

    @XmlAttribute
    public Date getDateFrom() {
        return this.dateFrom;
    }

    public void setDateFrom(Date date) {
        this.dateFrom = date;
        this.localDateFrom = date == null ? null : LocalDate.from(Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()));
    }

    @XmlAttribute
    public LocalDate getLocalDateFrom() {
        return this.localDateFrom;
    }

    public void setLocalDateFrom(LocalDate localDate) {
        this.localDateFrom = localDate;
        this.dateFrom = localDate == null ? null : Date.from(localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public int getMonthFrom() {
        int month = -1;
        if (this.localDateFrom != null) {
            month = this.localDateFrom.getMonthValue();
        }
        return month;
    }

    public int getYearFrom() {
        int year = -1;
        if (this.localDateFrom != null) {
            year = this.localDateFrom.getYear();
        }
        return year;
    }

    @XmlAttribute
    public Date getDateTo() {
        return this.dateTo;
    }

    public void setDateTo(Date date) {
        this.dateTo = date;
        this.localDateTo = date == null ? null : LocalDate.from(Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()));
    }

    @XmlAttribute
    public LocalDate getLocalDateTo() {
        return this.localDateTo;
    }

    public void setLocalDateTo(LocalDate localDate) {
        this.localDateTo = localDate;
        this.dateTo = localDate == null ? null : Date.from(localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public Calendar getDateFromCalendar() {
        return TimeUtils.convertDateToCalendar(this.dateFrom);
    }

    public Calendar getDateToCalendar() {
        return TimeUtils.convertDateToCalendar(this.dateTo);
    }

    public String toString() {
        return TimeUtils.formatPeriod(this);
    }

    @Override
    public int compareTo(Period period) {
        Date periodDateTo;
        int result = 0;
        Date periodDateFrom = period != null && period.getDateFrom() != null ? period.getDateFrom() : null;
        Date date = periodDateTo = period != null && period.getDateTo() != null ? period.getDateTo() : null;
        result = this.dateFrom == null ? (periodDateFrom == null ? (this.dateTo == null ? (periodDateTo == null ? 0 : -1) : this.dateTo.compareTo(periodDateTo)) : -1) : (periodDateFrom == null ? 1 : (this.dateFrom.equals(periodDateFrom) ? (this.dateTo == null ? (periodDateTo == null ? 0 : -1) : this.dateTo.compareTo(periodDateTo)) : this.dateFrom.compareTo(periodDateFrom)));
        return result;
    }
}

