/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.server.multipart;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import ru.bitel.common.server.multipart.MultipartRequest;

public class MultipartWrapper
extends HttpServletRequestWrapper {
    MultipartRequest multipartRequest = null;

    public MultipartWrapper(HttpServletRequest request, String saveDirectory) throws IOException {
        super(request);
        this.multipartRequest = new MultipartRequest(request, saveDirectory);
    }

    public String getFileContentType(String name) {
        return this.multipartRequest.getFileContentType(name);
    }

    public File getFile(String name) {
        return this.multipartRequest.getFile(name);
    }

    public Set<String> getFileNames() {
        return this.multipartRequest.getFileNames();
    }

    public String getFilesystemName(String name) {
        return this.multipartRequest.getFileSystemName(name);
    }

    public String getParameter(String name) {
        return this.multipartRequest.getParameter(name);
    }

    public Map<String, String[]> getParameterMap() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        Enumeration<String> en = this.getParameterNames();
        while (en.hasMoreElements()) {
            String name = en.nextElement();
            map.put(name, this.multipartRequest.getParameterValues(name));
        }
        return map;
    }

    public Enumeration<String> getParameterNames() {
        Vector<String> vector = new Vector<String>();
        for (String name : this.multipartRequest.getParameterNames()) {
            vector.add(name);
        }
        return vector.elements();
    }

    public String[] getParameterValues(String name) {
        return this.multipartRequest.getParameterValues(name);
    }
}

