/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class TimeoutKeyMap<K extends Delayed, V> {
    private static final Logger logger = Logger.getLogger(TimeoutKeyMap.class);
    private final ConcurrentMap<K, V> map = new ConcurrentHashMap();
    private final DelayQueue<K> queue = new DelayQueue();
    private final Runnable worker;

    public TimeoutKeyMap(ScheduledExecutorService scheduledExecutorService, long initialDelay, long period, TimeUnit unit) {
        this.worker = new Worker();
        scheduledExecutorService.scheduleWithFixedDelay(this.worker, initialDelay, period, unit);
    }

    public TimeoutKeyMap(String workerName) {
        this.worker = new ThreadWorker();
        new Thread(this.worker, workerName).start();
    }

    public void put(K key, V value) {
        this.map.put(key, value);
        this.queue.add(key);
    }

    public V remove(K key) {
        return this.map.remove(key);
    }

    public boolean remove(K key, V value) {
        return this.map.remove(key, value);
    }

    public V get(K key) {
        return this.map.get(key);
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    private class Worker
    implements Runnable {
        private Worker() {
        }

        @Override
        public void run() {
            try {
                Delayed k;
                DelayQueue queue = TimeoutKeyMap.this.queue;
                while ((k = (Delayed)queue.poll()) != null) {
                    TimeoutKeyMap.this.map.remove(k);
                }
            }
            catch (Throwable e) {
                logger.error((Object)e.getMessage(), e);
            }
        }
    }

    private class ThreadWorker
    implements Runnable {
        private ThreadWorker() {
        }

        @Override
        public void run() {
            DelayQueue queue = TimeoutKeyMap.this.queue;
            while (true) {
                try {
                    while (true) {
                        Delayed k = (Delayed)queue.take();
                        TimeoutKeyMap.this.map.remove(k);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    continue;
                }
                catch (Throwable e) {
                    logger.error((Object)e.getMessage(), e);
                    continue;
                }
                break;
            }
        }
    }
}

