/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Result;
import ru.bitel.oss.kernel.entity.common.bean.AbstractEntity;
import ru.bitel.oss.kernel.entity.common.bean.Entity;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpec;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttr;
import ru.bitel.oss.kernel.entity.server.bean.AbstractEntityAttrDao;

public abstract class AbstractEntityDao<E extends Entity>
extends AbstractEntityAttrDao<E> {
    private static final Logger logger = Logger.getLogger(AbstractEntityDao.class);
    protected PreparedStatement insertEntityPS = null;
    protected PreparedStatement updateEntityPS = null;
    protected PreparedStatement updateEntityPS2 = null;
    protected PreparedStatement getImplPS = null;

    public AbstractEntityDao(Connection con, int moduleId, int userId, String tableName) {
        super(con, moduleId, userId, tableName, ENTITY_SUPPORT);
    }

    protected void linkEntity(Entity entity) throws SQLException {
        if (entity.getId() <= 0 || entity.getEntitySpecId() > 0 && entity.getEntityId() == 0) {
            PreparedStatement ps = this.insertEntityPS;
            if (ps == null) {
                ps = this.insertEntityPS = this.con.prepareStatement("INSERT INTO entity SET entitySpecId=?, title=?", 1);
            }
            ps.setInt(1, entity.getEntitySpecId());
            ps.setString(2, entity.getEntityTitle());
            ps.executeUpdate();
            entity.setEntityId(ServerUtils.lastInsertId(ps));
        } else if (entity.getEntitySpecId() > 0) {
            PreparedStatement ps = this.updateEntityPS;
            if (ps == null) {
                ps = this.updateEntityPS = this.con.prepareStatement("UPDATE entity SET entitySpecId=?, title=? WHERE id=?");
            }
            ps.setInt(1, entity.getEntitySpecId());
            ps.setString(2, entity.getEntityTitle());
            ps.setInt(3, entity.getEntityId());
            ps.executeUpdate();
        } else {
            PreparedStatement ps = this.updateEntityPS2;
            if (ps == null) {
                ps = this.updateEntityPS2 = this.con.prepareStatement("UPDATE entity SET title=? WHERE id=?");
            }
            ps.setString(1, entity.getEntityTitle());
            ps.setInt(2, entity.getEntityId());
            ps.executeUpdate();
        }
    }

    protected void unlinkEntity(int entityId) throws SQLException {
        PreparedStatement ps = this.con.prepareStatement("DELETE FROM entity WHERE entity.id=?");
        ps.setInt(1, entityId);
        ps.executeUpdate();
        ps.close();
    }

    @Override
    protected int deleteImpl(int id) throws BGException {
        int result = 0;
        try {
            PreparedStatement ps = this.con.prepareStatement("DELETE FROM e, entity, entity_attr_text, entity_attr_int, entity_attr_list, entity_attr_date, entity_attr_house, entity_attr_address USING " + this.tableName + " as e LEFT JOIN entity ON entity.id=e.entityId LEFT JOIN entity_attr_text ON entity_attr_text.entityId=e.entityId LEFT JOIN entity_attr_int ON entity_attr_int.entityId=e.entityId LEFT JOIN entity_attr_list ON entity_attr_list.entityId=e.entityId LEFT JOIN entity_attr_date ON entity_attr_date.entityId=e.entityId LEFT JOIN entity_attr_house ON entity_attr_house.entityId=e.entityId LEFT JOIN entity_attr_address ON entity_attr_address.entityId=e.entityId WHERE e.id=?");
            ps.setInt(1, id);
            result = ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
        return result;
    }

    @Override
    public void update(E b2) throws BGException {
        block9: {
            try {
                Directory<Id> entitySpecDirectory;
                EntitySpec entitySpec;
                String entityTitle = ((IdTitle)b2).getTitle();
                if (((AbstractEntity)b2).getEntitySpecId() > 0 && (entitySpec = (EntitySpec)(entitySpecDirectory = this.getEntitySpecDirectory()).get(((AbstractEntity)b2).getEntitySpecId())) != null) {
                    entityTitle = entitySpec.createEntityTitle((Entity)b2);
                }
                ((Entity)b2).setEntityTitle(entityTitle);
                if (((Id)b2).getId() <= 0) {
                    this.linkEntity((Entity)b2);
                    try {
                        this.updateImpl(b2);
                    }
                    catch (SQLException e) {
                        this.unlinkEntity(((Entity)b2).getEntityId());
                        throw e;
                    }
                    catch (BGException e) {
                        this.unlinkEntity(((Entity)b2).getEntityId());
                        throw e;
                    }
                    this.updateEntityAttributes(((Entity)b2).getEntityId(), ((AbstractEntity)b2).getEntityAttributes());
                    break block9;
                }
                if (((AbstractEntity)b2).getEntitySpecId() > 0 && ((Entity)b2).getEntityId() == 0) {
                    this.linkEntity((Entity)b2);
                    this.updateImpl(b2);
                    this.updateEntityAttributes(((Entity)b2).getEntityId(), ((AbstractEntity)b2).getEntityAttributes());
                } else {
                    this.updateImpl(b2);
                    this.updateEntityAttributes(((Entity)b2).getEntityId(), ((AbstractEntity)b2).getEntityAttributes());
                    this.linkEntity((Entity)b2);
                }
            }
            catch (SQLException e) {
                this.processException(e);
            }
        }
    }

    @Override
    protected List<E> list(boolean loadAttributes, Page page, String what, String join, List<FilterEntityAttr> entityFilter, String filter, String groupBy, String orderBy, Object ... params) throws BGException {
        try {
            what = what == null ? "SQL_CALC_FOUND_ROWS " + this.tableName + ".*, entity.entitySpecId, entity.title as entityTitle" : "SQL_CALC_FOUND_ROWS " + what + ", entity.entitySpecId, entity.title as entityTitle";
            List result = this.listImpl(loadAttributes, page, "SQL_CALC_FOUND_ROWS " + this.tableName + ".*, entity.entitySpecId, entity.title as entityTitle", "LEFT JOIN entity ON entity.id=" + this.tableName + ".entityId", join, entityFilter, filter, groupBy, orderBy, params);
            if (page != null) {
                page.setRecordCount(ServerUtils.foundRows(this.con));
            }
            return result;
        }
        catch (SQLException e) {
            this.processException(e);
            return Collections.emptyList();
        }
    }

    @Override
    protected E getImpl(int id) throws BGException, SQLException {
        PreparedStatement ps = this.getImplPS;
        if (ps == null) {
            ps = this.getImplPS = this.con.prepareStatement("SELECT " + this.tableName + ".*, entity.entitySpecId, entity.title as entityTitle FROM " + this.tableName + " LEFT JOIN entity ON entity.id=" + this.tableName + ".entityId WHERE " + this.tableName + ".id=?");
        }
        ps.setInt(1, id);
        ResultSet rs = ps.executeQuery();
        Id result = rs.next() ? this.getFromRS(rs, true, true) : null;
        rs.close();
        return (E)result;
    }

    @Override
    protected E getFromRS(ResultSet rs, boolean loadAttributes, boolean loadEntityTitle) throws SQLException, BGException {
        E result = this.getFromRSImpl(rs);
        if (loadAttributes) {
            if (((AbstractEntity)result).getEntitySpecId() == 0) {
                ((AbstractEntity)result).setEntitySpecId(rs.getInt("entitySpecId"));
            }
            ((AbstractEntity)result).setEntityAttributes(this.getEntityAttributes(((AbstractEntity)result).getEntitySpecId(), ((Entity)result).getEntityId(), false));
        }
        if (loadEntityTitle) {
            ((Entity)result).setEntityTitle(rs.getString("entityTitle"));
        }
        return result;
    }

    protected abstract E getFromRSImpl(ResultSet var1) throws SQLException, BGException;

    @Override
    public void recycle() throws BGException {
        try {
            if (this.insertEntityPS != null) {
                this.insertEntityPS.close();
                this.insertEntityPS = null;
            }
            if (this.updateEntityPS != null) {
                this.updateEntityPS.close();
                this.updateEntityPS = null;
            }
            if (this.updateEntityPS2 != null) {
                this.updateEntityPS2.close();
                this.updateEntityPS2 = null;
            }
            if (this.getImplPS != null) {
                this.getImplPS.close();
                this.getImplPS = null;
            }
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
        finally {
            super.recycle();
        }
    }

    @Override
    protected Result<E> list(Page page, String filter, String orderBy, Object ... params) throws BGException {
        try {
            List result = this.listImpl(true, page, "SQL_CALC_FOUND_ROWS " + this.tableName + ".*, entity.entitySpecId, entity.title as entityTitle", "LEFT JOIN entity ON entity.id=" + this.tableName + ".entityId", null, null, filter, null, orderBy, params);
            if (page != null) {
                page.setRecordCount(ServerUtils.foundRows(this.con));
            }
            return new Result(result, page);
        }
        catch (SQLException e) {
            this.processException(e);
            return new Result(Collections.emptyList());
        }
    }

    @Override
    protected List<E> listImpl(Page page, String filter, String orderBy, Object ... params) throws BGException, SQLException {
        List result = this.listImpl(true, page, this.tableName + ".*, entity.entitySpecId, entity.title as entityTitle", "LEFT JOIN entity ON entity.id=" + this.tableName + ".entityId", null, null, filter, null, orderBy, params);
        return result;
    }

    static {
        try {
            new AbstractEntityAttrDao.AddressItemModifiedEventListener(){

                @Override
                protected AbstractEntityAttrDao<?> newDao(ServerContext context) {
                    return new AbstractEntityDao<Entity>(context.getConnection(), context.getModuleId(), context.getUserId(), null){

                        @Override
                        protected Entity getFromRSImpl(ResultSet rs) throws SQLException, BGException {
                            return null;
                        }

                        @Override
                        protected void updateImpl(Entity b2) throws BGException, SQLException {
                        }
                    };
                }
            };
        }
        catch (Throwable t) {
            logger.error((Object)t.getMessage(), t);
        }
    }
}

