/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import ru.bitel.common.Utils;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrEmail;
import ru.bitel.oss.kernel.entity.server.bean.AbstractEntityAttrDao;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrDefaultDao;

class EntityAttrEmailDao
extends EntityAttrDefaultDao<EntityAttrEmail> {
    public EntityAttrEmailDao(Connection con, AbstractEntityAttrDao<?> entityAttrDao, String intTable) {
        super(con, entityAttrDao, intTable);
    }

    @Override
    protected PreparedStatement getSelectPS(int entityId, int entitySpecAttrId) throws SQLException {
        if (this.selectPS == null) {
            this.selectPS = this.con.prepareStatement("SELECT email FROM " + this.table + " WHERE " + this.idName() + "=? AND " + this.typeName() + "=?");
        }
        this.selectPS.setInt(1, entityId);
        this.selectPS.setInt(2, entitySpecAttrId);
        return this.selectPS;
    }

    @Override
    protected PreparedStatement getInsertPS(int entityId, int entitySpecAttrId) throws SQLException {
        if (this.insertPS == null) {
            this.insertPS = this.con.prepareStatement("INSERT INTO " + this.table + " (" + this.idName() + ", " + this.typeName() + ", email) VALUES (?, ?, ?)");
        }
        this.insertPS.setInt(1, entityId);
        this.insertPS.setInt(2, entitySpecAttrId);
        return this.insertPS;
    }

    @Override
    protected PreparedStatement getUpdatePS(int entityId, int entitySpecAttrId) throws SQLException {
        if (this.updatePS == null) {
            this.updatePS = this.con.prepareStatement("UPDATE " + this.table + " SET email=? WHERE " + this.idName() + "=? AND " + this.typeName() + "=? AND (@oldValue:=email) IS NOT NULL");
        }
        this.updatePS.setInt(2, entityId);
        this.updatePS.setInt(3, entitySpecAttrId);
        return this.updatePS;
    }

    @Override
    protected PreparedStatement getDeletePS(int entityId, int entitySpecAttrId) throws SQLException {
        if (this.deletePS == null) {
            this.deletePS = this.con.prepareStatement("DELETE FROM " + this.table + " WHERE " + this.idName() + "=? AND " + this.typeName() + "=? AND (@oldValue:=email) IS NOT NULL");
        }
        this.deletePS.setInt(1, entityId);
        this.deletePS.setInt(2, entitySpecAttrId);
        return this.deletePS;
    }

    @Override
    public EntityAttrEmail get(int entityId, int attrSpecId) throws SQLException {
        PreparedStatement ps = this.getSelectPS(entityId, attrSpecId);
        ResultSet rs = ps.executeQuery();
        EntityAttrEmail result = rs.next() ? EntityAttrEmail.parse(entityId, attrSpecId, rs.getString(1)) : null;
        rs.close();
        return result;
    }

    @Override
    public void insert(int entityId, EntityAttr a2) throws SQLException {
        PreparedStatement ps = this.getInsertPS(entityId, a2.getEntitySpecAttrId());
        ps.setString(3, ((EntityAttrEmail)a2).getData());
        ps.executeUpdate();
    }

    @Override
    public boolean updateImpl(int entityId, EntityAttrEmail attr) throws SQLException {
        String value = attr.getData();
        if (Utils.isBlankString(value)) {
            return this.deleteImpl(entityId, attr.getEntitySpecAttrId());
        }
        PreparedStatement ps = this.getUpdatePS(entityId, attr.getEntitySpecAttrId());
        ps.setString(1, value);
        if (ps.executeUpdate() == 0) {
            ps = this.getInsertPS(entityId, attr.getEntitySpecAttrId());
            ps.setString(3, value);
            ps.executeUpdate();
            return true;
        }
        ps = this.entityAttrDao.getSelectOldValuePS();
        ResultSet rs = ps.executeQuery();
        String oldValue = rs.next() ? rs.getString(1) : null;
        rs.close();
        return !value.equals(oldValue);
    }
}

