/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.server.bean;

import java.io.ByteArrayInputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResource;

public class IpResourceDao
extends AbstractIdDao<IpResource> {
    public IpResourceDao(Connection con, int mid) {
        super(con, 0, "inv_ip_resource_" + mid);
    }

    @Override
    protected IpResource getFromRS(ResultSet rs) throws SQLException, BGException {
        IpResource result = new IpResource();
        result.setId(rs.getInt("id"));
        result.setCategoryId(rs.getInt("categoryId"));
        result.setAddressFrom(rs.getBytes("addressFrom"));
        result.setAddressTo(rs.getBytes("addressTo"));
        result.setPrefixLength(rs.getShort("prefixLength"));
        result.setDateFrom(rs.getDate("dateFrom"));
        result.setDateTo(rs.getDate("dateTo"));
        result.setRouter(rs.getString("router"));
        result.setDns(rs.getString("dns"));
        result.setSubnetMask(rs.getString("subnetMask"));
        result.setConfig(rs.getString("config"));
        result.setComment(rs.getString("comment"));
        return result;
    }

    public static IpResource getIpResourceFromRS(ResultSet rs) throws SQLException, BGException {
        IpResource result = new IpResource();
        result.setId(rs.getInt("resource.id"));
        result.setCategoryId(rs.getInt("resource.categoryId"));
        result.setAddressFrom(rs.getBytes("resource.addressFrom"));
        result.setAddressTo(rs.getBytes("resource.addressTo"));
        result.setPrefixLength(rs.getShort("resource.prefixLength"));
        result.setDateFrom(rs.getDate("resource.dateFrom"));
        result.setDateTo(rs.getDate("resource.dateTo"));
        result.setRouter(rs.getString("resource.router"));
        result.setDns(rs.getString("resource.dns"));
        result.setSubnetMask(rs.getString("resource.subnetMask"));
        result.setConfig(rs.getString("resource.config"));
        result.setComment(rs.getString("resource.comment"));
        return result;
    }

    @Override
    protected void updateImpl(IpResource b2) throws BGException, SQLException {
        PreparedStatement ps;
        if (b2.getId() <= 0) {
            ps = this.con.prepareStatement("INSERT INTO " + this.tableName + " (categoryId, addressFrom, addressTo, dateFrom, dateTo, router, subnetMask, dns, config, comment, dynamic, prefixLength) VALUES (?,?,?,?,?,?,?,?,?,?,0,?)", 1);
        } else {
            ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET categoryId=?, addressFrom=?, addressTo=?, dateFrom=?, dateTo=?, router=?, subnetMask=?, dns=?, config=?, comment=?, prefixLength=? WHERE id=?");
            ps.setInt(12, b2.getId());
        }
        ps.setInt(1, b2.getCategoryId());
        ps.setBlob(2, new ByteArrayInputStream(b2.getAddressFrom()));
        ps.setBlob(3, new ByteArrayInputStream(b2.getAddressTo()));
        ps.setDate(4, TimeUtils.convertDateToSqlDate(b2.getDateFrom()));
        ps.setDate(5, TimeUtils.convertDateToSqlDate(b2.getDateTo()));
        ps.setString(6, Utils.maskNull(b2.getRouter()));
        ps.setString(7, Utils.maskNull(b2.getSubnetMask()));
        ps.setString(8, Utils.maskNull(b2.getDns()));
        ps.setString(9, Utils.maskNull(b2.getConfig()));
        ps.setString(10, b2.getComment());
        ps.setShort(11, b2.getPrefixLength());
        ps.executeUpdate();
        if (b2.getId() <= 0) {
            b2.setId(ServerUtils.lastInsertId(ps));
        }
        ps.close();
    }

    public List<IpResource> list(Collection<Integer> categoryIds, Collection<Integer> resourceIds, Date dateFrom, Date dateTo, Boolean dynamic) throws BGException {
        ArrayList<IpResource> result = new ArrayList<IpResource>();
        try {
            StringBuilder sb = new StringBuilder(50).append("1=1");
            if (categoryIds != null && categoryIds.size() > 0) {
                sb.append(" AND categoryId IN (").append(Utils.toString(categoryIds)).append(")");
            }
            if (resourceIds != null && resourceIds.size() > 0) {
                sb.append(" AND id IN (").append(Utils.toString(resourceIds)).append(")");
            }
            sb.append(" AND (dateFrom IS NULL OR dateFrom<=?) AND (dateTo IS NULL OR dateTo>=?) ");
            String query = " SELECT * FROM " + this.tableName + " WHERE " + sb.toString();
            if (dynamic != null) {
                query = query + " AND dynamic = ?";
            }
            query = query + " ORDER BY id";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setDate(1, TimeUtils.convertDateToSqlDate(dateFrom));
            ps.setDate(2, TimeUtils.convertDateToSqlDate(dateTo));
            if (dynamic != null) {
                ps.setBoolean(3, dynamic);
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getFromRS(rs));
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
        return result;
    }

    public List<IpResource> list(Set<Integer> categoryIds, Date dateFrom, Date dateTo) throws BGException {
        ArrayList<IpResource> result = new ArrayList<IpResource>();
        try {
            StringBuilder sb = new StringBuilder(100);
            sb.append(" SELECT * FROM " + this.tableName);
            sb.append(" WHERE 1 =1 ");
            if (categoryIds.size() > 0) {
                sb.append("AND categoryId IN (" + Utils.toString(categoryIds) + ")");
            }
            sb.append(" AND (dateFrom IS NULL OR ? OR dateFrom<=?) AND (dateTo IS NULL OR ? OR dateTo>=?)");
            java.sql.Date dateFromSql = TimeUtils.convertDateToSqlDate(dateFrom);
            java.sql.Date dateToSql = TimeUtils.convertDateToSqlDate(dateTo);
            PreparedStatement ps = this.con.prepareStatement(sb.toString());
            ps.setBoolean(1, dateFromSql == null);
            ps.setDate(2, dateFromSql);
            ps.setBoolean(3, dateToSql == null);
            ps.setDate(4, dateToSql);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getFromRS(rs));
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
        return result;
    }

    public List<IpResource> list(int categoryId, Date dateFrom, Date dateTo) throws BGException {
        ArrayList<IpResource> result = new ArrayList<IpResource>();
        try {
            java.sql.Date dateFromSql = TimeUtils.convertDateToSqlDate(dateFrom);
            java.sql.Date dateToSql = TimeUtils.convertDateToSqlDate(dateTo);
            String query = " SELECT * FROM " + this.tableName + " WHERE 1=1 ";
            query = query + "AND (dateFrom IS NULL OR ? OR dateFrom<=?) AND (dateTo IS NULL OR ? OR dateTo>=?)";
            if (categoryId > 0) {
                query = query + " AND categoryId=?";
            }
            query = query + "ORDER BY id";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setBoolean(1, dateFromSql == null);
            ps.setDate(2, dateFromSql);
            ps.setBoolean(3, dateToSql == null);
            ps.setDate(4, dateToSql);
            if (categoryId > 0) {
                ps.setInt(5, categoryId);
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
        return result;
    }

    public List<IpResource> list(int categoryId) throws BGException {
        return this.list("categoryId=?", "id", categoryId);
    }

    public List<IpResource> list() throws BGException {
        return this.list("", "id", new Object[0]);
    }

    public List<IpResource> listFree(int categoryId, byte[] mask, int size) throws BGException {
        return this.list("categoryId=?", "id", categoryId);
    }
}

