/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResourceSubscriptionReal;

public class IpResourceSubscriptionRealDao
extends AbstractIdDao<IpResourceSubscriptionReal> {
    public IpResourceSubscriptionRealDao(Connection con, int mid) {
        super(con, mid, "inv_ip_resource_subscription_real");
    }

    @Override
    protected IpResourceSubscriptionReal getFromRS(ResultSet rs) throws SQLException, BGException {
        IpResourceSubscriptionReal result = new IpResourceSubscriptionReal();
        result.setId(rs.getInt("id"));
        result.setAddressFrom(rs.getBytes("addressFrom"));
        result.setAddressTo(rs.getBytes("addressTo"));
        result.setDateFrom(TimeUtils.convertSqlDateToDate(rs.getDate("dateFrom")));
        result.setDateTo(TimeUtils.convertSqlDateToDate(rs.getDate("dateTo")));
        result.setSubscriberId(rs.getInt("subscriberId"));
        result.setSubscriberTitle(rs.getString("subscriberTitle"));
        return result;
    }

    @Override
    protected void updateImpl(IpResourceSubscriptionReal b2) throws BGException, SQLException {
        PreparedStatement ps;
        if (b2.getId() <= 0) {
            ps = this.con.prepareStatement("INSERT INTO " + this.tableName + " (addressFrom, addressTo,  dateFrom, dateTo, subscriberId, subscriberTitle ) VALUES (?,?,?,?,?,?)", 1);
        } else {
            ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET  addressFrom=?, addressTo=?, dateFrom=?, dateTo=?, subscriberId=?, subscriberTitle = ? WHERE id=?");
            ps.setInt(7, b2.getId());
        }
        ps.setBytes(1, b2.getAddressFrom());
        ps.setBytes(2, b2.getAddressTo());
        ps.setDate(3, TimeUtils.convertDateToSqlDate(b2.getDateFrom()));
        ps.setDate(4, TimeUtils.convertDateToSqlDate(b2.getDateTo()));
        ps.setInt(5, b2.getSubscriberId());
        ps.setString(6, b2.getSubscriberTitle());
        ps.executeUpdate();
        if (b2.getId() <= 0) {
            b2.setId(ServerUtils.lastInsertId(ps));
        }
        ps.close();
    }

    public IpResourceSubscriptionReal findFromDate(int subscriberId, byte[] addressFrom, byte[] addressTo, Date dateFrom) throws BGException {
        if (addressTo == null) {
            addressTo = addressFrom;
        }
        IpResourceSubscriptionReal result = null;
        try {
            StringBuilder sb = new StringBuilder(100);
            sb.append("SELECT *  FROM " + this.tableName + " as subscription  WHERE 1=1 AND (subscription.dateTo IS NULL OR subscription.dateTo>=?)");
            sb.append(" AND (subscription.addressFrom<=?) AND (subscription.addressTo>=?)");
            sb.append(" AND subscription.subscriberId = " + subscriberId);
            PreparedStatement ps = this.con.prepareStatement(sb.toString());
            java.sql.Date todaySql = TimeUtils.convertDateToSqlDate(dateFrom);
            ps.setDate(1, todaySql);
            ps.setBytes(2, addressTo);
            ps.setBytes(3, addressFrom);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getFromRS(rs);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
        return result;
    }
}

