<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	version="1.0">
<xsl:import href="layout.xsl"/>

<xsl:output encoding="UTF-8" method='html' indent='yes'/>

<xsl:variable name="mid" select="/data/@mid"/>
<xsl:variable name="activateType" select="/data/@activateType"/>

<xsl:template match="/">
	<xsl:call-template name="main">
  		<xsl:with-param name="mode" select="'pub'"/>
  	</xsl:call-template>
</xsl:template>

<xsl:template name="title">Воcстановление пароля</xsl:template>

<xsl:template match="/data">
<!-- 
<h2>Востановление пароля</h2>
 -->
<xsl:if test="error">
	<xsl:choose>
		<xsl:when test="error/@id='contractNotFound'">
			<div class="errorMessage">
				<b>ОШИБКА: Договор не найден</b><br/>
				Введенный Вами номер договора (<xsl:value-of select="@userName"/>) не найден в базе данных. Проверьте правильность ввода номера договора. Номер договора состоит из нескольких букв в начале, затем несколько цифр, затем тире "-" и две цифры (последние две цифры от года, когда был заключен договор). Номер вводиться слитно без пробелов. Например: NK00001-05, КФ123456-06 и т.д.
			</div>
		</xsl:when>
		<xsl:when test="error/@id='emailNotValid'">
			<div class="errorMessage">
				<b>ОШИБКА: Неправильный Email</b><br/>
				Введенный Вами Email (<xsl:value-of select="error/@email"/>) не совпадает с email указанным в договоре (<xsl:value-of select="@userName"/>) для функции восcтановления пароля.
			</div>
		</xsl:when>
		<xsl:when test="error/@id='emailNotFound'">
			<div class="errorMessage">
				<b>ОШИБКА: Функция воcстановления пароля заблокирована</b><br/>
				Для указанного договора (<xsl:value-of select="@userName"/>) функция воcстановления пароля заблокирована. За дополнительной информацией обратитесь в расчетную службу.
			</div>
		</xsl:when>
		<xsl:otherwise>
			<div class="errorMessage">
				<b>ОШИБКА: Неизвестная</b><br/>
				это что то новенькое!!! [error = '<xsl:value-of select="error/@id"/>'] Свяжитесь с разработчиками!
			</div>
			<h3></h3>
		</xsl:otherwise>
	</xsl:choose>
</xsl:if>

<xsl:if test="not(ok)">
	<p>Для воcстановления пароля введите номер Вашего договора и email (указанный в договоре для функции восcтановления пароля). Дальнейшие инструкции по воcстановлению пароля будут высланы на указанный email.</p>
	<form action="{$PUBEXECUTER}">
		<input type="hidden" name="action" value="PasswordForgot" />
		<input type="hidden" name="module" value="admin" />
		<table class="filter">
			<tr valign="top">
				<td nowrap="nowrap">Номер договора:</td>
				<td>
					<input type="text" name="contract" size="20" value="{@userName}" />
					<br/>
					<em class="comment">
						Номер договора состоит из нескольких букв в начале, затем несколько цифр, затем
						тире "-" и две цифры (последние две цифры от года, когда был заключен договор).
						Номер вводится слитно без пробелов. Например: NK00001-05, КФ123456-06 и т.д.
					</em>
				</td>
			</tr>
			
			<xsl:if test="maskEmail">
				<tr valign="top"> 
					<td nowrap="nowrap">Ваши Email:</td>
					<td>
						<table>
							<xsl:for-each select="maskEmail/row">
								<tr valign="top">
									<td> <xsl:value-of select="@mail"/> </td>
								</tr>
							</xsl:for-each>
						</table>
						<br/>
					</td>
				 </tr>
				
				<tr valign="top">
					<br/>
					<td nowrap="nowrap">Email:</td> 
					<td>
						<input type="text" name="email" size="20" />
						<br/>
						<em class="comment">
							Email указанный в договоре для функции воcстановления пароля.
						</em>
					</td>
				</tr>
			</xsl:if>
			
			
			<tr valign="top">
				<td nowrap="nowrap"></td>
				<td>
					<input type="submit" value="Применить" />
				</td>
			</tr>
		</table>
	</form>
</xsl:if>

<xsl:if test="ok">
	<div class="infoMessage">Дальнейшие инструкции по воcстановлению пароля высланы на указанный Вами E-mail.</div>
</xsl:if>
</xsl:template>

</xsl:stylesheet>
