/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.export.parameters;

import java.io.File;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Map;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.FileHtmlResourceHandler;
import net.sf.jasperreports.engine.export.HtmlResourceHandler;
import net.sf.jasperreports.export.JsonExporterOutput;
import net.sf.jasperreports.export.parameters.ParametersWriterExporterOutput;

public class ParametersJsonExporterOutput
extends ParametersWriterExporterOutput
implements JsonExporterOutput {
    private HtmlResourceHandler fontHandler;
    private HtmlResourceHandler resourceHandler;

    public ParametersJsonExporterOutput(JasperReportsContext jasperReportsContext, Map<JRExporterParameter, Object> parameters, JasperPrint jasperPrint) {
        super(jasperReportsContext, parameters, jasperPrint);
        OutputStream os;
        Writer writer;
        StringBuffer sb = (StringBuffer)parameters.get(JRExporterParameter.OUTPUT_STRING_BUFFER);
        if (sb == null && (writer = (Writer)parameters.get(JRExporterParameter.OUTPUT_WRITER)) == null && (os = (OutputStream)parameters.get(JRExporterParameter.OUTPUT_STREAM)) == null) {
            File destFile = (File)parameters.get(JRExporterParameter.OUTPUT_FILE);
            if (destFile == null) {
                String fileName = (String)parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
                if (fileName != null) {
                    destFile = new File(fileName);
                } else {
                    throw new JRRuntimeException("export.parameters.no.output.specified", (Object[])null);
                }
            }
            if (this.fontHandler == null || this.resourceHandler == null) {
                File resourcesDir = new File(destFile.getParent(), destFile.getName() + "_files");
                FileHtmlResourceHandler defaultHandler = new FileHtmlResourceHandler(resourcesDir, resourcesDir.getName() + "/{0}");
                this.fontHandler = this.fontHandler == null ? defaultHandler : this.fontHandler;
                this.resourceHandler = this.resourceHandler == null ? defaultHandler : this.resourceHandler;
            }
        }
    }

    @Override
    public HtmlResourceHandler getFontHandler() {
        return this.fontHandler;
    }

    @Override
    public HtmlResourceHandler getResourceHandler() {
        return this.resourceHandler;
    }
}

