/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.jsp.taglib;

import java.io.IOException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tiles.Attribute;
import org.apache.tiles.AttributeContext;
import org.apache.tiles.ListAttribute;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.jsp.context.JspUtil;
import org.apache.tiles.jsp.taglib.PutAttributeTag;
import org.apache.tiles.jsp.taglib.PutAttributeTagParent;
import org.apache.tiles.jsp.taglib.PutListAttributeTag;
import org.apache.tiles.jsp.taglib.PutListAttributeTagParent;
import org.apache.tiles.jsp.taglib.TilesBodyTag;
import org.apache.tiles.jsp.taglib.TilesJspException;

public abstract class RenderTag
extends TilesBodyTag
implements PutAttributeTagParent,
PutListAttributeTagParent {
    private final Log log = LogFactory.getLog(RenderTag.class);
    protected String role;
    protected String preparer;
    protected boolean flush;
    protected boolean ignore;
    protected TilesContainer container;
    protected AttributeContext attributeContext;

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getPreparer() {
        return this.preparer;
    }

    public void setPreparer(String preparer) {
        this.preparer = preparer;
    }

    public boolean isFlush() {
        return this.flush;
    }

    public void setFlush(boolean flush) {
        this.flush = flush;
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    protected void reset() {
        super.reset();
        this.preparer = null;
        this.flush = false;
        this.ignore = false;
        this.container = null;
        this.attributeContext = null;
        this.role = null;
    }

    public int doStartTag() throws TilesJspException {
        this.container = JspUtil.getCurrentContainer(this.pageContext);
        if (this.container != null) {
            this.startContext(this.pageContext);
            return 2;
        }
        throw new TilesJspException("TilesContainer not initialized");
    }

    public int doEndTag() throws TilesJspException {
        try {
            this.render();
            if (this.flush) {
                this.pageContext.getOut().flush();
            }
            int n = 6;
            return n;
        }
        catch (IOException io) {
            String message = "IO Error executing tag: " + io.getMessage();
            this.log.error((Object)message, (Throwable)io);
            throw new TilesJspException(message, io);
        }
        finally {
            this.endContext(this.pageContext);
        }
    }

    protected abstract void render() throws TilesJspException, IOException;

    protected void startContext(PageContext context) {
        if (this.container != null) {
            this.attributeContext = this.container.startContext(new Object[]{this.pageContext});
        }
    }

    protected void endContext(PageContext context) {
        if (this.attributeContext != null && this.container != null) {
            this.container.endContext(new Object[]{this.pageContext});
        }
    }

    public void processNestedTag(PutAttributeTag nestedTag) {
        Attribute attribute = new Attribute(nestedTag.getValue(), null, nestedTag.getRole(), nestedTag.getType());
        this.attributeContext.putAttribute(nestedTag.getName(), attribute, nestedTag.isCascade());
    }

    public void processNestedTag(PutListAttributeTag nestedTag) {
        ListAttribute attribute = new ListAttribute(nestedTag.getAttributes());
        attribute.setRole(nestedTag.getRole());
        attribute.setInherit(nestedTag.getInherit());
        this.attributeContext.putAttribute(nestedTag.getName(), (Attribute)attribute, nestedTag.isCascade());
    }
}

