/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.extensions;

import com.novell.ldap.LDAPExtendedResponse;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.LBERDecoder;
import com.novell.ldap.rfc2251.RfcLDAPMessage;
import java.io.IOException;

public class ListReplicasResponse
extends LDAPExtendedResponse {
    private String[] replicaList;

    public ListReplicasResponse(RfcLDAPMessage rfcMessage) throws IOException {
        super(rfcMessage);
        if (this.getResultCode() != 0) {
            this.replicaList = new String[0];
        } else {
            byte[] returnedValue = this.getValue();
            if (returnedValue == null) {
                throw new IOException("No returned value");
            }
            LBERDecoder decoder = new LBERDecoder();
            if (decoder == null) {
                throw new IOException("Decoding error");
            }
            ASN1Sequence returnedSequence = (ASN1Sequence)decoder.decode(returnedValue);
            if (returnedSequence == null) {
                throw new IOException("Decoding error");
            }
            int len = returnedSequence.size();
            this.replicaList = new String[len];
            for (int i = 0; i < len; ++i) {
                ASN1OctetString asn1_nextReplica = (ASN1OctetString)returnedSequence.get(i);
                if (asn1_nextReplica == null) {
                    throw new IOException("Decoding error");
                }
                this.replicaList[i] = asn1_nextReplica.stringValue();
                if (this.replicaList[i] != null) continue;
                throw new IOException("Decoding error");
            }
        }
    }

    public String[] getReplicaList() {
        return this.replicaList;
    }
}

