/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.util;

import com.novell.ldap.LDAPAddRequest;
import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPAttributeSet;
import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPDeleteRequest;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.LDAPModification;
import com.novell.ldap.LDAPModifyDNRequest;
import com.novell.ldap.LDAPModifyRequest;
import com.novell.ldap.LDAPSearchResult;
import com.novell.ldap.util.Base64;
import com.novell.ldap.util.LDAPWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.util.Iterator;

public class LDIFWriter
implements LDAPWriter {
    private Boolean requestFile = null;
    private BufferedWriter bufWriter;
    private String version;

    public LDIFWriter(OutputStream out) throws IOException {
        this(out, "1", null);
    }

    public LDIFWriter(OutputStream out, String version, boolean request) throws IOException {
        this(out, version, new Boolean(request));
    }

    private LDIFWriter(OutputStream out, String version, Boolean request) throws IOException {
        if (version != "1") {
            throw new RuntimeException("com.novell.ldap.ldif_dsml.LDIFWriter: LDIF version:found: " + version + ", Should be: 1");
        }
        this.version = version;
        this.requestFile = request;
        OutputStreamWriter osw = new OutputStreamWriter(out, "UTF-8");
        this.bufWriter = new BufferedWriter(osw);
        this.writeComments("This LDIF file was generated by the LDIF APIs. of Novell's Java LDAP SDK");
        this.writeVersionLine();
    }

    public void writeEntry(LDAPEntry entry) throws IOException {
        this.writeEntry(entry, new LDAPControl[0]);
    }

    public void writeEntry(LDAPEntry entry, LDAPControl[] controls) throws IOException {
        this.requestFile = Boolean.FALSE;
        this.writeAddRequest(entry, controls);
        this.bufWriter.newLine();
    }

    public void writeMessage(LDAPMessage request) throws IOException {
        LDAPControl[] controls = request.getControls();
        switch (request.getType()) {
            case 4: {
                if (this.requestFile == null) {
                    this.requestFile = Boolean.FALSE;
                }
                if (!this.isRequest()) break;
                throw new RuntimeException("Attempting to write content  in a request stream");
            }
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                if (this.requestFile == null) {
                    this.requestFile = Boolean.TRUE;
                }
                if (this.isRequest()) break;
                throw new RuntimeException("Attempting to write request  in a content stream");
            }
            default: {
                throw new RuntimeException("Unsupported request type: " + request.toString());
            }
        }
        switch (request.getType()) {
            case 4: {
                LDAPSearchResult sreq = (LDAPSearchResult)request;
                this.writeAddRequest(sreq.getEntry(), controls);
                break;
            }
            case 8: {
                LDAPAddRequest areq = (LDAPAddRequest)request;
                this.writeAddRequest(areq.getEntry(), controls);
                break;
            }
            case 10: {
                LDAPDeleteRequest dreq = (LDAPDeleteRequest)request;
                this.writeDeleteRequest(dreq.getDN(), controls);
                break;
            }
            case 12: {
                LDAPModifyDNRequest rreq = (LDAPModifyDNRequest)request;
                this.writeModifyDNRequest(rreq.getDN(), rreq.getNewRDN(), rreq.getDeleteOldRDN(), rreq.getParentDN(), controls);
                break;
            }
            case 6: {
                LDAPModifyRequest mreq = (LDAPModifyRequest)request;
                this.writeModifyRequest(mreq.getDN(), mreq.getModifications(), controls);
            }
        }
        this.bufWriter.newLine();
    }

    public void writeComments(String line) throws IOException {
        String rline;
        BufferedReader in = new BufferedReader(new StringReader(line));
        while ((rline = in.readLine()) != null) {
            this.bufWriter.write("# ", 0, 2);
            this.bufWriter.write(rline, 0, rline.length());
            this.bufWriter.newLine();
        }
    }

    public void writeError(Exception e) throws IOException {
        this.writeComments(e.toString());
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isRequest() {
        return this.requestFile;
    }

    public boolean isPrintable(byte[] bytes) {
        if (bytes == null) {
            throw new RuntimeException("com.novell.ldap.ldif_dsml.LDIFWriter: null pointer");
        }
        if (bytes.length > 0) {
            for (int i = 0; i < bytes.length; ++i) {
                if ((bytes[i] & 0xFF) >= 32 && (bytes[i] & 0xFF) <= 126) continue;
                return false;
            }
        }
        return true;
    }

    private void writeVersionLine() throws IOException {
        String versionLine = new String("version: " + this.getVersion());
        this.bufWriter.write(versionLine, 0, versionLine.length());
        this.bufWriter.newLine();
        this.bufWriter.newLine();
    }

    private void writeLine(String line) throws IOException {
        int len = line.length();
        if (line != null && len != 0) {
            if (len <= 76) {
                this.bufWriter.write(line, 0, len);
            } else {
                int pos = 0;
                this.bufWriter.write(line, pos, 76);
                pos += 76;
                this.bufWriter.newLine();
                while (len - pos > 75) {
                    this.bufWriter.write(" ", 0, 1);
                    this.bufWriter.write(line, pos, 75);
                    pos += 75;
                    this.bufWriter.newLine();
                }
                this.bufWriter.write(" ", 0, 1);
                this.bufWriter.write(line, pos, len - pos);
            }
            this.bufWriter.newLine();
        }
    }

    private void writeAddRequest(LDAPEntry entry, LDAPControl[] ctrls) throws IOException {
        this.writeDN(entry.getDN());
        if (this.isRequest()) {
            if (ctrls != null) {
                this.writeControls(ctrls);
            }
            this.writeLine("changetype: add");
        }
        LDAPAttributeSet attrSet = entry.getAttributeSet();
        Iterator allAttrs = attrSet.iterator();
        while (allAttrs.hasNext()) {
            LDAPAttribute attr = (LDAPAttribute)allAttrs.next();
            String attrName = attr.getName();
            byte[][] values = attr.getByteValueArray();
            if (values == null) continue;
            for (int i = 0; i < values.length; ++i) {
                this.writeAttribute(attrName, values[i]);
            }
        }
    }

    private void writeModifyRequest(String dn, LDAPModification[] mods, LDAPControl[] ctrls) throws IOException {
        int len = mods.length;
        this.writeDN(dn);
        if (ctrls != null) {
            this.writeControls(ctrls);
        }
        this.writeLine("changetype: modify");
        for (int i = 0; i < len; ++i) {
            int modOp = mods[i].getOp();
            LDAPAttribute attr = mods[i].getAttribute();
            String attrName = attr.getName();
            byte[][] attrValue = attr.getByteValueArray();
            switch (modOp) {
                case 0: {
                    this.writeLine("add: " + attrName);
                    break;
                }
                case 1: {
                    this.writeLine("delete: " + attrName);
                    break;
                }
                case 2: {
                    this.writeLine("replace: " + attrName);
                    break;
                }
            }
            for (int j = 0; j < attrValue.length; ++j) {
                this.writeAttribute(attrName, attrValue[j]);
            }
            this.writeLine("-");
        }
    }

    private void writeModifyDNRequest(String dn, String newRDN, boolean deleteOldRDN, String newSuperior, LDAPControl[] ctrls) throws IOException {
        this.writeDN(dn);
        if (ctrls != null) {
            this.writeControls(ctrls);
        }
        this.writeLine("changetype: moddn");
        this.writeLine(Base64.isLDIFSafe(newRDN) ? "newrdn: " + newRDN : "newrdn:: " + Base64.encode(newRDN));
        this.writeLine("deleteoldrdn:" + deleteOldRDN);
        if (newSuperior != null) {
            this.writeLine(Base64.isLDIFSafe(newSuperior) ? "newsuperior: " + newSuperior : "newsuperior:: " + Base64.encode(newSuperior));
        }
    }

    private void writeDeleteRequest(String dn, LDAPControl[] ctrls) throws IOException {
        this.writeDN(dn);
        if (ctrls != null) {
            this.writeControls(ctrls);
        }
        this.writeLine("changetype: delete");
    }

    private void writeDN(String dn) throws IOException {
        this.writeLine(Base64.isLDIFSafe(dn) ? "dn: " + dn : "dn:: " + Base64.encode(dn));
    }

    private void writeControls(LDAPControl[] ctrls) throws IOException {
        for (int i = 0; i < ctrls.length; ++i) {
            byte[] cVal = ctrls[i].getValue();
            this.writeLine(cVal != null && cVal.length > 0 ? "control: " + ctrls[i].getID() + " " + ctrls[i].isCritical() + ":: " + Base64.encode(cVal) : "control: " + ctrls[i].getID() + " " + ctrls[i].isCritical());
        }
    }

    private void writeAttribute(String attrName, String attrVal) throws IOException {
        if (attrVal != null) {
            this.writeLine(Base64.isLDIFSafe(attrVal) ? attrName + ": " + attrVal : attrName + ":: " + Base64.encode(attrVal));
        }
    }

    private void writeAttribute(String attrName, byte[] attrVal) throws IOException {
        if (attrVal != null) {
            this.writeLine(Base64.isLDIFSafe(attrVal) && this.isPrintable(attrVal) ? attrName + ": " + new String(attrVal, "UTF-8") : attrName + ":: " + Base64.encode(attrVal));
        }
    }

    public void finish() throws IOException {
        this.bufWriter.flush();
    }
}

