/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.upload;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class MultipartRequestWrapper
extends HttpServletRequestWrapper {
    protected Map parameters = new HashMap();

    public MultipartRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    public void setParameter(String name, String value) {
        String[] mValue = (String[])this.parameters.get(name);
        if (mValue == null) {
            mValue = new String[]{};
        }
        String[] newValue = new String[mValue.length + 1];
        System.arraycopy(mValue, 0, newValue, 0, mValue.length);
        newValue[mValue.length] = value;
        this.parameters.put(name, newValue);
    }

    public String getParameter(String name) {
        String[] mValue;
        String value = this.getRequest().getParameter(name);
        if (value == null && (mValue = (String[])this.parameters.get(name)) != null && mValue.length > 0) {
            value = mValue[0];
        }
        return value;
    }

    public Enumeration getParameterNames() {
        Enumeration baseParams = this.getRequest().getParameterNames();
        Vector list = new Vector();
        while (baseParams.hasMoreElements()) {
            list.add(baseParams.nextElement());
        }
        Set multipartParams = this.parameters.keySet();
        Iterator iterator = multipartParams.iterator();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return Collections.enumeration(list);
    }

    public String[] getParameterValues(String name) {
        String[] value = this.getRequest().getParameterValues(name);
        if (value == null) {
            value = (String[])this.parameters.get(name);
        }
        return value;
    }

    public Map getParameterMap() {
        HashMap map = new HashMap(this.parameters);
        map.putAll(this.getRequest().getParameterMap());
        return map;
    }
}

